/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.craftbukkit;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class InventoryWorkaround {
    private static final int USABLE_PLAYER_INV_SIZE = 36;
    private static Boolean hasMainHandSupport = null;

    private InventoryWorkaround() {
    }

    private static int firstPartial(Inventory inventory, ItemStack item, int maxAmount) {
        if (item == null) {
            return -1;
        }
        ItemStack[] stacks = inventory.getContents();
        for (int i = 0; i < stacks.length; ++i) {
            ItemStack cItem = stacks[i];
            if (cItem == null || cItem.getAmount() >= maxAmount || !cItem.isSimilar(item)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isCombinedInventory(Inventory inventory) {
        return inventory instanceof PlayerInventory && inventory.getContents().length > 36;
    }

    public static void clearInventoryNoArmor(PlayerInventory inventory) {
        if (InventoryWorkaround.isCombinedInventory((Inventory)inventory)) {
            for (int i = 0; i < 36; ++i) {
                inventory.setItem(i, null);
            }
        } else {
            inventory.clear();
        }
    }

    private static Inventory makeTruncatedPlayerInventory(PlayerInventory playerInventory) {
        Inventory fakeInventory = Bukkit.getServer().createInventory(null, 36);
        fakeInventory.setContents(Arrays.copyOf(playerInventory.getContents(), fakeInventory.getSize()));
        return fakeInventory;
    }

    public static Map<Integer, ItemStack> addAllItems(Inventory inventory, ItemStack ... items) {
        Inventory fakeInventory;
        ItemStack[] contents = inventory.getContents();
        if (InventoryWorkaround.isCombinedInventory(inventory)) {
            fakeInventory = InventoryWorkaround.makeTruncatedPlayerInventory((PlayerInventory)inventory);
        } else {
            fakeInventory = Bukkit.getServer().createInventory(null, inventory.getType());
            fakeInventory.setContents(contents);
        }
        Map<Integer, ItemStack> overflow = InventoryWorkaround.addItems(fakeInventory, items);
        if (overflow.isEmpty()) {
            InventoryWorkaround.addItems(inventory, items);
            return null;
        }
        return InventoryWorkaround.addItems(fakeInventory, items);
    }

    public static Map<Integer, ItemStack> addAllOversizedItems(Inventory inventory, int oversizedStacks, ItemStack ... items) {
        Inventory fakeInventory;
        ItemStack[] contents = inventory.getContents();
        if (InventoryWorkaround.isCombinedInventory(inventory)) {
            fakeInventory = InventoryWorkaround.makeTruncatedPlayerInventory((PlayerInventory)inventory);
        } else {
            fakeInventory = Bukkit.getServer().createInventory(null, inventory.getType());
            fakeInventory.setContents(contents);
        }
        Map<Integer, ItemStack> overflow = InventoryWorkaround.addOversizedItems(fakeInventory, oversizedStacks, items);
        if (overflow.isEmpty()) {
            InventoryWorkaround.addOversizedItems(inventory, oversizedStacks, items);
            return null;
        }
        return overflow;
    }

    public static Map<Integer, ItemStack> addItems(Inventory inventory, ItemStack ... items) {
        return InventoryWorkaround.addOversizedItems(inventory, 0, items);
    }

    public static Map<Integer, ItemStack> addOversizedItems(Inventory inventory, int oversizedStacks, ItemStack ... items) {
        if (InventoryWorkaround.isCombinedInventory(inventory)) {
            Inventory fakeInventory = InventoryWorkaround.makeTruncatedPlayerInventory((PlayerInventory)inventory);
            Map<Integer, ItemStack> overflow = InventoryWorkaround.addOversizedItems(fakeInventory, oversizedStacks, items);
            for (int i = 0; i < fakeInventory.getContents().length; ++i) {
                inventory.setItem(i, fakeInventory.getContents()[i]);
            }
            return overflow;
        }
        HashMap<Integer, ItemStack> leftover = new HashMap<Integer, ItemStack>();
        ItemStack[] combined = new ItemStack[items.length];
        block1: for (ItemStack item : items) {
            if (item == null || item.getAmount() < 1) continue;
            for (int j = 0; j < combined.length; ++j) {
                if (combined[j] == null) {
                    combined[j] = item.clone();
                    continue block1;
                }
                if (!combined[j].isSimilar(item)) continue;
                combined[j].setAmount(combined[j].getAmount() + item.getAmount());
                continue block1;
            }
        }
        block3: for (int i = 0; i < combined.length; ++i) {
            ItemStack item = combined[i];
            if (item == null || item.getType() == Material.AIR) continue;
            while (true) {
                int partialAmount;
                int maxAmount;
                int firstPartial;
                if ((firstPartial = InventoryWorkaround.firstPartial(inventory, item, maxAmount = Math.max(oversizedStacks, item.getType().getMaxStackSize()))) == -1) {
                    int firstFree = inventory.firstEmpty();
                    if (firstFree == -1) {
                        leftover.put(i, item);
                        continue block3;
                    }
                    if (item.getAmount() > maxAmount) {
                        ItemStack stack = item.clone();
                        stack.setAmount(maxAmount);
                        inventory.setItem(firstFree, stack);
                        item.setAmount(item.getAmount() - maxAmount);
                        continue;
                    }
                    inventory.setItem(firstFree, item);
                    continue block3;
                }
                ItemStack partialItem = inventory.getItem(firstPartial);
                int amount = item.getAmount();
                if (amount + (partialAmount = partialItem.getAmount()) <= maxAmount) {
                    partialItem.setAmount(amount + partialAmount);
                    continue block3;
                }
                partialItem.setAmount(maxAmount);
                item.setAmount(amount + partialAmount - maxAmount);
            }
        }
        return leftover;
    }

    public static void setItemInMainHand(Player p, ItemStack item) {
        if (hasMainHandSupport == null) {
            try {
                p.getInventory().setItemInMainHand(item);
                hasMainHandSupport = true;
            }
            catch (Throwable e) {
                p.setItemInHand(item);
                hasMainHandSupport = false;
            }
        } else if (hasMainHandSupport.booleanValue()) {
            p.getInventory().setItemInMainHand(item);
        } else {
            p.setItemInHand(item);
        }
    }

    public static void setItemInMainHand(EntityEquipment invent, ItemStack item) {
        if (hasMainHandSupport == null) {
            try {
                invent.setItemInMainHand(item);
                hasMainHandSupport = true;
            }
            catch (Throwable e) {
                invent.setItemInHand(item);
                hasMainHandSupport = false;
            }
        } else if (hasMainHandSupport.booleanValue()) {
            invent.setItemInMainHand(item);
        } else {
            invent.setItemInHand(item);
        }
    }

    public static void setItemInMainHandDropChance(EntityEquipment invent, float chance) {
        if (hasMainHandSupport == null) {
            try {
                invent.setItemInMainHandDropChance(chance);
                hasMainHandSupport = true;
            }
            catch (Throwable e) {
                invent.setItemInHandDropChance(chance);
                hasMainHandSupport = false;
            }
        } else if (hasMainHandSupport.booleanValue()) {
            invent.setItemInMainHandDropChance(chance);
        } else {
            invent.setItemInHandDropChance(chance);
        }
    }

    public static void setItemInOffHand(Player p, ItemStack item) {
        if (hasMainHandSupport == null || hasMainHandSupport.booleanValue()) {
            try {
                p.getInventory().setItemInOffHand(item);
                hasMainHandSupport = true;
            }
            catch (Throwable e) {
                hasMainHandSupport = false;
            }
        }
    }

    public static int clearItemInOffHand(Player p, ItemStack item) {
        if (hasMainHandSupport == null || hasMainHandSupport.booleanValue()) {
            try {
                int removedAmount = 0;
                if (p.getInventory().getItemInOffHand().getType().equals((Object)item.getType())) {
                    removedAmount = p.getInventory().getItemInOffHand().getAmount();
                    p.getInventory().setItemInOffHand(null);
                }
                hasMainHandSupport = true;
                return removedAmount;
            }
            catch (Throwable e) {
                hasMainHandSupport = false;
            }
        }
        return 0;
    }
}

