/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.libs.configurate.objectmapping.meta;

import com.earth2me.essentials.libs.configurate.CommentedConfigurationNodeIntermediary;
import com.earth2me.essentials.libs.configurate.ConfigurationNode;
import com.earth2me.essentials.libs.configurate.objectmapping.meta.Comment;
import com.earth2me.essentials.libs.configurate.objectmapping.meta.Localization;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ResourceBundle;

@FunctionalInterface
public interface Processor<V> {
    public void process(V var1, ConfigurationNode var2);

    public static Factory<Comment, Object> comments() {
        return (data, fieldType) -> (value, destination) -> {
            if (destination instanceof CommentedConfigurationNodeIntermediary) {
                CommentedConfigurationNodeIntermediary commented = (CommentedConfigurationNodeIntermediary)destination;
                if (data.override()) {
                    commented.comment(data.value());
                } else {
                    commented.commentIfAbsent(data.value());
                }
            }
        };
    }

    public static Factory<Comment, Object> localizedComments(ResourceBundle source) {
        return (data, fieldType) -> {
            String translated = Localization.key(source, data.value());
            return (value, destination) -> {
                if (destination instanceof CommentedConfigurationNodeIntermediary) {
                    CommentedConfigurationNodeIntermediary commented = (CommentedConfigurationNodeIntermediary)destination;
                    if (data.override()) {
                        commented.comment(translated);
                    } else {
                        commented.commentIfAbsent(translated);
                    }
                }
            };
        };
    }

    @FunctionalInterface
    public static interface Factory<A extends Annotation, T> {
        public Processor<T> make(A var1, Type var2);
    }
}

