/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.signs;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.signs.EssentialsSign;
import com.earth2me.essentials.signs.Signs;
import com.earth2me.essentials.utils.FormatUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import net.ess3.api.MaxMoneyException;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;

public class SignBlockListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private final transient IEssentials ess;

    public SignBlockListener(IEssentials ess) {
        this.ess = ess;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSignBlockBreak(BlockBreakEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        try {
            if (this.protectSignsAndBlocks(event.getBlock(), event.getPlayer())) {
                event.setCancelled(true);
            }
        }
        catch (MaxMoneyException ex) {
            event.setCancelled(true);
        }
    }

    public boolean protectSignsAndBlocks(Block block, Player player) throws MaxMoneyException {
        if (EssentialsSign.checkIfBlockBreaksSigns(block)) {
            if (this.ess.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Prevented that a block was broken next to a sign.");
            }
            return true;
        }
        Material mat = block.getType();
        if (MaterialUtil.isSign(mat)) {
            Sign csign = (Sign)block.getState();
            for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
                if (!csign.getLine(0).equalsIgnoreCase(sign.getSuccessName(this.ess)) || sign.onSignBreak(block, player, this.ess)) continue;
                return true;
            }
        }
        for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
            if (!sign.areHeavyEventRequired() || !sign.getBlocks().contains(block.getType()) || sign.onBlockBreak(block, player, this.ess)) continue;
            LOGGER.log(Level.INFO, "A block was protected by a sign.");
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onSignSignChange2(SignChangeEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        for (int i = 0; i < 4; ++i) {
            event.setLine(i, FormatUtil.formatString(user, "essentials.signs", event.getLine(i)));
        }
        String lColorlessTopLine = ChatColor.stripColor((String)event.getLine(0)).toLowerCase().trim();
        if (lColorlessTopLine.isEmpty()) {
            return;
        }
        for (Signs signs : Signs.values()) {
            EssentialsSign sign = signs.getSign();
            String successName = sign.getSuccessName(this.ess);
            if (successName == null) {
                event.getPlayer().sendMessage(I18n.tl("errorWithMessage", "Please report this error to a staff member."));
                return;
            }
            String lSuccessName = ChatColor.stripColor((String)successName.toLowerCase());
            if (!lColorlessTopLine.contains(lSuccessName) || !this.ess.getSettings().enabledSigns().contains(sign) && this.ess.getSettings().getUnprotectedSignNames().contains(sign)) continue;
            event.setLine(0, lColorlessTopLine);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSignSignChange(SignChangeEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
            if (event.getLine(0).equalsIgnoreCase(sign.getSuccessName(this.ess))) {
                event.setCancelled(true);
                return;
            }
            if (!event.getLine(0).equalsIgnoreCase(sign.getTemplateName()) || sign.onSignCreate(event, this.ess)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignBlockPlace(BlockPlaceEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        Block against = event.getBlockAgainst();
        if (MaterialUtil.isSign(against.getType()) && EssentialsSign.isValidSign(this.ess, new EssentialsSign.BlockSign(against))) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        if (MaterialUtil.isSign(block.getType())) {
            return;
        }
        for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
            if (!sign.areHeavyEventRequired() || !sign.getBlocks().contains(block.getType()) || sign.onBlockPlace(block, event.getPlayer(), this.ess)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignBlockBurn(BlockBurnEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        Block block = event.getBlock();
        if (MaterialUtil.isSign(block.getType()) && EssentialsSign.isValidSign(this.ess, new EssentialsSign.BlockSign(block)) || EssentialsSign.checkIfBlockBreaksSigns(block)) {
            event.setCancelled(true);
            return;
        }
        for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
            if (!sign.areHeavyEventRequired() || !sign.getBlocks().contains(block.getType()) || sign.onBlockBurn(block, this.ess)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onSignBlockIgnite(BlockIgniteEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        Block block = event.getBlock();
        if (MaterialUtil.isSign(block.getType()) && EssentialsSign.isValidSign(this.ess, new EssentialsSign.BlockSign(block)) || EssentialsSign.checkIfBlockBreaksSigns(block)) {
            event.setCancelled(true);
            return;
        }
        for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
            if (!sign.areHeavyEventRequired() || !sign.getBlocks().contains(block.getType()) || sign.onBlockIgnite(block, this.ess)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onSignBlockPistonExtend(BlockPistonExtendEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        for (Block block : event.getBlocks()) {
            if (MaterialUtil.isSign(block.getType()) && EssentialsSign.isValidSign(this.ess, new EssentialsSign.BlockSign(block)) || EssentialsSign.checkIfBlockBreaksSigns(block)) {
                event.setCancelled(true);
                return;
            }
            for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
                if (!sign.areHeavyEventRequired() || !sign.getBlocks().contains(block.getType()) || sign.onBlockPush(block, this.ess)) continue;
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onSignBlockPistonRetract(BlockPistonRetractEvent event) {
        if (this.ess.getSettings().areSignsDisabled()) {
            event.getHandlers().unregister((Listener)this);
            return;
        }
        if (event.isSticky()) {
            Block[] affectedBlocks;
            Block pistonBaseBlock = event.getBlock();
            for (Block block : affectedBlocks = new Block[]{pistonBaseBlock, pistonBaseBlock.getRelative(event.getDirection()), event.getRetractLocation().getBlock()}) {
                if (MaterialUtil.isSign(block.getType()) && EssentialsSign.isValidSign(this.ess, new EssentialsSign.BlockSign(block)) || EssentialsSign.checkIfBlockBreaksSigns(block)) {
                    event.setCancelled(true);
                    return;
                }
                for (EssentialsSign sign : this.ess.getSettings().enabledSigns()) {
                    if (!sign.areHeavyEventRequired() || !sign.getBlocks().contains(block.getType()) || sign.onBlockPush(block, this.ess)) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }
    }
}

