/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.utils.EnumUtil;
import com.earth2me.essentials.utils.MaterialUtil;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Set;
import net.ess3.api.IUser;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public final class LocationUtil {
    public static final int RADIUS = 3;
    public static final Vector3D[] VOLUME;
    private static final Set<Material> WATER_TYPES;
    private static final Set<Material> DAMAGING_TYPES;
    private static final Set<Material> LAVA_TYPES;
    private static final Material PORTAL;
    private static final Material LIGHT;
    private static final Set<Material> HOLLOW_MATERIALS;
    private static final Set<Material> TRANSPARENT_MATERIALS;

    private LocationUtil() {
    }

    public static void setIsWaterSafe(boolean isWaterSafe) {
        if (isWaterSafe) {
            HOLLOW_MATERIALS.addAll(WATER_TYPES);
        } else {
            HOLLOW_MATERIALS.removeAll(WATER_TYPES);
        }
    }

    public static ItemStack convertBlockToItem(Block block) {
        return new ItemStack(block.getType(), 1);
    }

    public static Location getTarget(LivingEntity entity) throws Exception {
        Block block = null;
        try {
            block = entity.getTargetBlock(TRANSPARENT_MATERIALS, 300);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        if (block == null) {
            throw new Exception("Not targeting a block");
        }
        return block.getLocation();
    }

    public static boolean isBlockAboveAir(IEssentials ess, World world, int x, int y, int z) {
        return y > ess.getWorldInfoProvider().getMaxHeight(world) || HOLLOW_MATERIALS.contains(world.getBlockAt(x, y - 1, z).getType());
    }

    public static boolean isBlockOutsideWorldBorder(World world, int x, int z) {
        Location center = world.getWorldBorder().getCenter();
        int radius = (int)world.getWorldBorder().getSize() / 2;
        int x1 = center.getBlockX() - radius;
        int x2 = center.getBlockX() + radius;
        int z1 = center.getBlockZ() - radius;
        int z2 = center.getBlockZ() + radius;
        return x < x1 || x > x2 || z < z1 || z > z2;
    }

    public static int getXInsideWorldBorder(World world, int x) {
        Location center = world.getWorldBorder().getCenter();
        int radius = (int)world.getWorldBorder().getSize() / 2;
        int x1 = center.getBlockX() - radius;
        int x2 = center.getBlockX() + radius;
        if (x < x1) {
            return x1;
        }
        if (x > x2) {
            return x2;
        }
        return x;
    }

    public static int getZInsideWorldBorder(World world, int z) {
        Location center = world.getWorldBorder().getCenter();
        int radius = (int)world.getWorldBorder().getSize() / 2;
        int z1 = center.getBlockZ() - radius;
        int z2 = center.getBlockZ() + radius;
        if (z < z1) {
            return z1;
        }
        if (z > z2) {
            return z2;
        }
        return z;
    }

    public static boolean isBlockUnsafeForUser(IEssentials ess, IUser user, World world, int x, int y, int z) {
        if (user.getBase().isOnline() && world.equals(user.getBase().getWorld()) && (user.getBase().getGameMode() == GameMode.CREATIVE || user.getBase().getGameMode() == GameMode.SPECTATOR || user.isGodModeEnabled()) && user.getBase().getAllowFlight()) {
            return false;
        }
        if (LocationUtil.isBlockDamaging(world, x, y, z)) {
            return true;
        }
        if (LocationUtil.isBlockAboveAir(ess, world, x, y, z)) {
            return true;
        }
        return LocationUtil.isBlockOutsideWorldBorder(world, x, z);
    }

    public static boolean isBlockUnsafe(IEssentials ess, World world, int x, int y, int z) {
        return LocationUtil.isBlockDamaging(world, x, y, z) || LocationUtil.isBlockAboveAir(ess, world, x, y, z);
    }

    public static boolean isBlockDamaging(World world, int x, int y, int z) {
        Material block = world.getBlockAt(x, y, z).getType();
        Material below = world.getBlockAt(x, y - 1, z).getType();
        Material above = world.getBlockAt(x, y + 1, z).getType();
        if (DAMAGING_TYPES.contains(below) || LAVA_TYPES.contains(below) || MaterialUtil.isBed(below)) {
            return true;
        }
        if (block == PORTAL) {
            return true;
        }
        return !HOLLOW_MATERIALS.contains(block) || !HOLLOW_MATERIALS.contains(above);
    }

    public static Location getRoundedDestination(Location loc) {
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int y = (int)Math.round(loc.getY());
        int z = loc.getBlockZ();
        return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, loc.getYaw(), loc.getPitch());
    }

    @Deprecated
    public static Location getSafeDestination(IUser user, Location loc) throws Exception {
        return LocationUtil.getSafeDestination(null, user, loc);
    }

    public static Location getSafeDestination(IEssentials ess, IUser user, Location loc) throws Exception {
        if (!(!user.getBase().isOnline() || ess != null && ess.getSettings().isAlwaysTeleportSafety() || user.getBase().getGameMode() != GameMode.CREATIVE && user.getBase().getGameMode() != GameMode.SPECTATOR && !user.isGodModeEnabled())) {
            if (LocationUtil.shouldFly(ess, loc) && user.getBase().getAllowFlight()) {
                user.getBase().setFlying(true);
            }
            if (ess == null || ess.getSettings().isTeleportToCenterLocation()) {
                return LocationUtil.getRoundedDestination(loc);
            }
            return loc;
        }
        return LocationUtil.getSafeDestination(ess, loc);
    }

    public static Location getSafeDestination(IEssentials ess, Location loc) throws Exception {
        if (loc == null || loc.getWorld() == null) {
            throw new Exception(I18n.tl("destinationNotSet", new Object[0]));
        }
        World world = loc.getWorld();
        int worldMinY = ess.getWorldInfoProvider().getMinHeight(world);
        int worldLogicalY = ess.getWorldInfoProvider().getLogicalHeight(world);
        int worldMaxY = loc.getBlockY() < worldLogicalY ? worldLogicalY : ess.getWorldInfoProvider().getMaxHeight(world);
        int x = loc.getBlockX();
        int y = (int)Math.round(loc.getY());
        int z = loc.getBlockZ();
        if (LocationUtil.isBlockOutsideWorldBorder(world, x, z)) {
            x = LocationUtil.getXInsideWorldBorder(world, x);
            z = LocationUtil.getZInsideWorldBorder(world, z);
        }
        int origX = x;
        int origY = y;
        int origZ = z;
        while (LocationUtil.isBlockAboveAir(ess, world, x, y, z)) {
            if (--y >= 0) continue;
            y = origY;
            break;
        }
        if (LocationUtil.isBlockUnsafe(ess, world, x, y, z)) {
            x = Math.round(loc.getX()) == (long)origX ? x - 1 : x + 1;
            z = Math.round(loc.getZ()) == (long)origZ ? z - 1 : z + 1;
        }
        int i = 0;
        while (LocationUtil.isBlockUnsafe(ess, world, x, y, z)) {
            if (++i >= VOLUME.length) {
                x = origX;
                y = Ints.constrainToRange((int)(origY + 3), (int)worldMinY, (int)worldMaxY);
                z = origZ;
                break;
            }
            x = origX + LocationUtil.VOLUME[i].x;
            y = Ints.constrainToRange((int)(origY + LocationUtil.VOLUME[i].y), (int)worldMinY, (int)worldMaxY);
            z = origZ + LocationUtil.VOLUME[i].z;
        }
        while (LocationUtil.isBlockUnsafe(ess, world, x, y, z)) {
            if (++y < worldMaxY) continue;
            ++x;
            break;
        }
        while (LocationUtil.isBlockUnsafe(ess, world, x, y, z)) {
            if (--y > worldMinY + 1) continue;
            y = Math.min(world.getHighestBlockYAt(++x, z) + 1, worldMaxY);
            if (x - 48 <= loc.getBlockX()) continue;
            throw new Exception(I18n.tl("holeInFloor", new Object[0]));
        }
        return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, loc.getYaw(), loc.getPitch());
    }

    public static boolean shouldFly(IEssentials ess, Location loc) {
        int y;
        World world = loc.getWorld();
        int x = loc.getBlockX();
        int z = loc.getBlockZ();
        int count = 0;
        for (y = (int)Math.round(loc.getY()); LocationUtil.isBlockUnsafe(ess, world, x, y, z) && y >= ess.getWorldInfoProvider().getMinHeight(world); --y) {
            if (++count <= 2) continue;
            return true;
        }
        return y < 0;
    }

    static {
        WATER_TYPES = EnumUtil.getAllMatching(Material.class, "FLOWING_WATER", "WATER");
        DAMAGING_TYPES = EnumUtil.getAllMatching(Material.class, "CACTUS", "CAMPFIRE", "FIRE", "MAGMA_BLOCK", "SOUL_CAMPFIRE", "SOUL_FIRE", "SWEET_BERRY_BUSH", "WITHER_ROSE");
        LAVA_TYPES = EnumUtil.getAllMatching(Material.class, "FLOWING_LAVA", "LAVA", "STATIONARY_LAVA");
        PORTAL = EnumUtil.getMaterial("NETHER_PORTAL", "PORTAL");
        LIGHT = EnumUtil.getMaterial("LIGHT");
        HOLLOW_MATERIALS = EnumSet.noneOf(Material.class);
        TRANSPARENT_MATERIALS = EnumSet.noneOf(Material.class);
        for (Material mat : Material.values()) {
            if (!mat.isTransparent()) continue;
            HOLLOW_MATERIALS.add(mat);
        }
        TRANSPARENT_MATERIALS.addAll(HOLLOW_MATERIALS);
        TRANSPARENT_MATERIALS.addAll(WATER_TYPES);
        HOLLOW_MATERIALS.remove(Material.BARRIER);
        if (LIGHT != null) {
            HOLLOW_MATERIALS.add(LIGHT);
        }
        ArrayList<Vector3D> pos = new ArrayList<Vector3D>();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    pos.add(new Vector3D(x, y, z));
                }
            }
        }
        pos.sort(Comparator.comparingInt(a -> a.x * a.x + a.y * a.y + a.z * a.z));
        VOLUME = pos.toArray(new Vector3D[0]);
    }

    public static class Vector3D {
        public final int x;
        public final int y;
        public final int z;

        Vector3D(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

