/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.paperlib.PaperLib;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ess3.nms.refl.ReflUtil;
import org.bukkit.Bukkit;

public final class VersionUtil {
    public static final BukkitVersion v1_14_R01 = BukkitVersion.fromString("1.14-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_8_8_R01 = BukkitVersion.fromString("1.8.8-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_9_R01 = BukkitVersion.fromString("1.9-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_9_4_R01 = BukkitVersion.fromString("1.9.4-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_10_2_R01 = BukkitVersion.fromString("1.10.2-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_11_R01 = BukkitVersion.fromString("1.11-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_11_2_R01 = BukkitVersion.fromString("1.11.2-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_12_0_R01 = BukkitVersion.fromString("1.12.0-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_12_2_R01 = BukkitVersion.fromString("1.12.2-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_13_0_R01 = BukkitVersion.fromString("1.13.0-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_13_2_R01 = BukkitVersion.fromString("1.13.2-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_14_4_R01 = BukkitVersion.fromString("1.14.4-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_15_R01 = BukkitVersion.fromString("1.15-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_15_2_R01 = BukkitVersion.fromString("1.15.2-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_16_1_R01 = BukkitVersion.fromString("1.16.1-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_16_5_R01 = BukkitVersion.fromString("1.16.5-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_17_R01 = BukkitVersion.fromString("1.17-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_17_1_R01 = BukkitVersion.fromString("1.17.1-R0.1-SNAPSHOT");
    public static final BukkitVersion v1_18_1_R01 = BukkitVersion.fromString("1.18.1-R0.1-SNAPSHOT");
    private static final Set<BukkitVersion> supportedVersions = ImmutableSet.of((Object)v1_8_8_R01, (Object)v1_9_4_R01, (Object)v1_10_2_R01, (Object)v1_11_2_R01, (Object)v1_12_2_R01, (Object)v1_13_2_R01, (Object[])new BukkitVersion[]{v1_14_4_R01, v1_15_2_R01, v1_16_5_R01, v1_17_1_R01, v1_18_1_R01});
    private static final Map<String, SupportStatus> unsupportedServerClasses;
    private static BukkitVersion serverVersion;
    private static SupportStatus supportStatus;
    private static String supportStatusClass;

    private VersionUtil() {
    }

    public static boolean isPaper() {
        return PaperLib.isPaper();
    }

    public static BukkitVersion getServerBukkitVersion() {
        if (serverVersion == null) {
            serverVersion = BukkitVersion.fromString(Bukkit.getServer().getBukkitVersion());
        }
        return serverVersion;
    }

    public static SupportStatus getServerSupportStatus() {
        if (supportStatus == null) {
            for (Map.Entry<String, SupportStatus> entry : unsupportedServerClasses.entrySet()) {
                if (entry.getKey().startsWith("brand:")) {
                    if (!Bukkit.getName().equalsIgnoreCase(entry.getKey().replaceFirst("brand:", ""))) continue;
                    supportStatusClass = entry.getKey();
                    supportStatus = entry.getValue();
                    return supportStatus;
                }
                boolean inverted = entry.getKey().contains("!");
                String clazz = entry.getKey().replace("!", "").split("#")[0];
                String method = "";
                if (entry.getKey().contains("#")) {
                    method = entry.getKey().split("#")[1];
                }
                try {
                    Class<?> lolClass = Class.forName(clazz);
                    if (!method.isEmpty()) {
                        for (Method mth : lolClass.getDeclaredMethods()) {
                            if (!mth.getName().equals(method) || inverted) continue;
                            supportStatusClass = entry.getKey();
                            supportStatus = entry.getValue();
                            return supportStatus;
                        }
                        continue;
                    }
                    if (inverted) continue;
                    supportStatusClass = entry.getKey();
                    supportStatus = entry.getValue();
                    return supportStatus;
                }
                catch (ClassNotFoundException ignored) {
                    if (!inverted) continue;
                    supportStatusClass = entry.getKey();
                    supportStatus = entry.getValue();
                    return supportStatus;
                }
            }
            if (!supportedVersions.contains(VersionUtil.getServerBukkitVersion())) {
                supportStatus = SupportStatus.OUTDATED;
                return supportStatus;
            }
            supportStatus = PaperLib.isPaper() ? SupportStatus.FULL : SupportStatus.LIMITED;
            return supportStatus;
        }
        return supportStatus;
    }

    public static String getSupportStatusClass() {
        return supportStatusClass;
    }

    public static boolean isServerSupported() {
        return VersionUtil.getServerSupportStatus().isSupported();
    }

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"org.yatopiamc.yatopia.server.YatopiaConfig", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"net.yatopia.api.event.PlayerAttackEntityEvent", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"org.bukkit.plugin.SimplePluginManager#getPluginLoaders", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"org.bukkit.Bukkit#getLastTickTime", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"brand:Yatopia", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"brand:Hyalus", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"net.kibblelands.server.FastMath", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"io.akarin.server.Config", (Object)SupportStatus.DANGEROUS_FORK);
        builder.put((Object)"net.minecraftforge.common.MinecraftForge", (Object)SupportStatus.UNSTABLE);
        builder.put((Object)"net.fabricmc.loader.launch.knot.KnotServer", (Object)SupportStatus.UNSTABLE);
        if (ReflUtil.getNmsVersionObject().isHigherThanOrEqualTo(ReflUtil.V1_17_R1)) {
            builder.put((Object)"!net.minecraft.server.MinecraftServer", (Object)SupportStatus.NMS_CLEANROOM);
        } else {
            builder.put((Object)("!net.minecraft.server." + ReflUtil.getNMSVersion() + ".MinecraftServer"), (Object)SupportStatus.NMS_CLEANROOM);
        }
        unsupportedServerClasses = builder.build();
        serverVersion = null;
        supportStatus = null;
        supportStatusClass = null;
    }

    public static final class BukkitVersion
    implements Comparable<BukkitVersion> {
        private static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)\\.?([0-9]*)?(?:-pre(\\d))?(?:-rc(\\d+))?(?:-?R?([\\d.]+))?(?:-SNAPSHOT)?");
        private final int major;
        private final int minor;
        private final int preRelease;
        private final int releaseCandidate;
        private final int patch;
        private final double revision;

        private BukkitVersion(int major, int minor, int patch, double revision, int preRelease, int releaseCandidate) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.revision = revision;
            this.preRelease = preRelease;
            this.releaseCandidate = releaseCandidate;
        }

        public static BukkitVersion fromString(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"string cannot be null.");
            Matcher matcher = VERSION_PATTERN.matcher(string);
            if (!matcher.matches()) {
                if (!Bukkit.getName().equals("Essentials Fake Server")) {
                    throw new IllegalArgumentException(string + " is not in valid version format. e.g. 1.8.8-R0.1");
                }
                matcher = VERSION_PATTERN.matcher(v1_14_R01.toString());
                Preconditions.checkArgument((boolean)matcher.matches(), (Object)(string + " is not in valid version format. e.g. 1.8.8-R0.1"));
            }
            return BukkitVersion.from(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(6), matcher.group(4), matcher.group(5));
        }

        private static BukkitVersion from(String major, String minor, String patch, String revision, String preRelease, String releaseCandidate) {
            if (patch == null || patch.isEmpty()) {
                patch = "0";
            }
            if (revision == null || revision.isEmpty()) {
                revision = "0";
            }
            if (preRelease == null || preRelease.isEmpty()) {
                preRelease = "-1";
            }
            if (releaseCandidate == null || releaseCandidate.isEmpty()) {
                releaseCandidate = "-1";
            }
            return new BukkitVersion(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch), Double.parseDouble(revision), Integer.parseInt(preRelease), Integer.parseInt(releaseCandidate));
        }

        public boolean isHigherThan(BukkitVersion o) {
            return this.compareTo(o) > 0;
        }

        public boolean isHigherThanOrEqualTo(BukkitVersion o) {
            return this.compareTo(o) >= 0;
        }

        public boolean isLowerThan(BukkitVersion o) {
            return this.compareTo(o) < 0;
        }

        public boolean isLowerThanOrEqualTo(BukkitVersion o) {
            return this.compareTo(o) <= 0;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        public double getRevision() {
            return this.revision;
        }

        public int getPrerelease() {
            return this.preRelease;
        }

        public int getReleaseCandidate() {
            return this.releaseCandidate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BukkitVersion that = (BukkitVersion)o;
            return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.revision == that.revision && this.preRelease == that.preRelease;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.major, this.minor, this.patch, this.revision, this.preRelease, this.releaseCandidate});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.major + "." + this.minor);
            if (this.patch != 0) {
                sb.append(".").append(this.patch);
            }
            if (this.preRelease != -1) {
                sb.append("-pre").append(this.preRelease);
            }
            if (this.releaseCandidate != -1) {
                sb.append("-rc").append(this.releaseCandidate);
            }
            return sb.append("-R").append(this.revision).toString();
        }

        @Override
        public int compareTo(BukkitVersion o) {
            if (this.major < o.major) {
                return -1;
            }
            if (this.major > o.major) {
                return 1;
            }
            if (this.minor < o.minor) {
                return -1;
            }
            if (this.minor > o.minor) {
                return 1;
            }
            if (this.patch < o.patch) {
                return -1;
            }
            if (this.patch > o.patch) {
                return 1;
            }
            if (this.preRelease < o.preRelease) {
                return -1;
            }
            if (this.preRelease > o.preRelease) {
                return 1;
            }
            if (this.releaseCandidate < o.releaseCandidate) {
                return -1;
            }
            if (this.releaseCandidate > o.releaseCandidate) {
                return 1;
            }
            return Double.compare(this.revision, o.revision);
        }
    }

    public static enum SupportStatus {
        FULL(true),
        LIMITED(true),
        DANGEROUS_FORK(false),
        NMS_CLEANROOM(false),
        UNSTABLE(false),
        OUTDATED(false);

        private final boolean supported;

        private SupportStatus(boolean supported) {
            this.supported = supported;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }
}

