/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.nms.refl;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public final class ReflUtil {
    public static final NMSVersion V1_12_R1 = NMSVersion.fromString("v1_12_R1");
    public static final NMSVersion V1_11_R1 = NMSVersion.fromString("v1_11_R1");
    public static final NMSVersion V1_17_R1 = NMSVersion.fromString("v1_17_R1");
    public static final NMSVersion V1_18_R1 = NMSVersion.fromString("v1_18_R1");
    private static final Map<String, Class<?>> classCache = new HashMap();
    private static final Table<Class<?>, String, Method> methodCache = HashBasedTable.create();
    private static final Table<Class<?>, MethodParams, Method> methodParamCache = HashBasedTable.create();
    private static final Table<Class<?>, String, Field> fieldCache = HashBasedTable.create();
    private static final Map<Class<?>, Constructor<?>> constructorCache = new HashMap();
    private static final Table<Class<?>, ConstructorParams, Constructor<?>> constructorParamCache = HashBasedTable.create();
    private static NMSVersion nmsVersionObject;
    private static String nmsVersion;

    private ReflUtil() {
    }

    public static String getNMSVersion() {
        if (nmsVersion == null) {
            String name = Bukkit.getServer().getClass().getName();
            String[] parts = name.split("\\.");
            if (parts.length > 3) {
                nmsVersion = parts[3];
                return nmsVersion;
            }
            nmsVersion = "";
            return "";
        }
        return nmsVersion;
    }

    public static NMSVersion getNmsVersionObject() {
        if (nmsVersionObject == null) {
            try {
                nmsVersionObject = NMSVersion.fromString(ReflUtil.getNMSVersion());
            }
            catch (IllegalArgumentException e) {
                try {
                    Class.forName("org.bukkit.craftbukkit.CraftServer");
                    nmsVersionObject = new NMSVersion(99, 99, 99);
                }
                catch (ClassNotFoundException ignored) {
                    throw e;
                }
            }
        }
        return nmsVersionObject;
    }

    public static boolean isMojMap() {
        return ReflUtil.getNmsVersionObject().getMajor() == 99;
    }

    public static Class<?> getNMSClass(String className) {
        return ReflUtil.getClassCached("net.minecraft.server" + (ReflUtil.getNmsVersionObject().isLowerThan(V1_17_R1) ? "." + ReflUtil.getNMSVersion() : "") + "." + className);
    }

    public static Class<?> getOBCClass(String className) {
        return ReflUtil.getClassCached("org.bukkit.craftbukkit" + (ReflUtil.getNmsVersionObject().getMajor() == 99 ? "" : "." + ReflUtil.getNMSVersion()) + "." + className);
    }

    public static Class<?> getClassCached(String className) {
        if (classCache.containsKey(className)) {
            return classCache.get(className);
        }
        try {
            Class<?> classForName = Class.forName(className);
            classCache.put(className, classForName);
            return classForName;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method getMethodCached(Class<?> clazz, String methodName) {
        if (methodCache.contains(clazz, (Object)methodName)) {
            return (Method)methodCache.get(clazz, (Object)methodName);
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            methodCache.put(clazz, (Object)methodName, (Object)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getMethodCached(Class<?> clazz, String methodName, Class<?> ... params) {
        MethodParams methodParams = new MethodParams(methodName, params);
        if (methodParamCache.contains(clazz, (Object)methodParams)) {
            return (Method)methodParamCache.get(clazz, (Object)methodParams);
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, params);
            method.setAccessible(true);
            methodParamCache.put(clazz, (Object)methodParams, (Object)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Field getFieldCached(Class<?> clazz, String fieldName) {
        if (fieldCache.contains(clazz, (Object)fieldName)) {
            return (Field)fieldCache.get(clazz, (Object)fieldName);
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldCache.put(clazz, (Object)fieldName, (Object)field);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Constructor<?> getConstructorCached(Class<?> clazz) {
        if (constructorCache.containsKey(clazz)) {
            return constructorCache.get(clazz);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructorCache.put(clazz, constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Constructor<?> getConstructorCached(Class<?> clazz, Class<?> ... params) {
        ConstructorParams constructorParams = new ConstructorParams(params);
        if (constructorParamCache.contains(clazz, (Object)constructorParams)) {
            return (Constructor)constructorParamCache.get(clazz, (Object)constructorParams);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(params);
            constructor.setAccessible(true);
            constructorParamCache.put(clazz, (Object)constructorParams, constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static final class NMSVersion
    implements Comparable<NMSVersion> {
        private static final Pattern VERSION_PATTERN = Pattern.compile("^v(\\d+)_(\\d+)_R(\\d+)");
        private final int major;
        private final int minor;
        private final int release;

        private NMSVersion(int major, int minor, int release) {
            this.major = major;
            this.minor = minor;
            this.release = release;
        }

        public static NMSVersion fromString(String string) {
            Preconditions.checkNotNull((Object)string, (Object)"string cannot be null.");
            Matcher matcher = VERSION_PATTERN.matcher(string);
            if (!matcher.matches()) {
                if (!Bukkit.getName().equals("Essentials Fake Server")) {
                    throw new IllegalArgumentException(string + " is not in valid version format. e.g. v1_10_R1");
                }
                matcher = VERSION_PATTERN.matcher(V1_12_R1.toString());
                Preconditions.checkArgument((boolean)matcher.matches(), (Object)(string + " is not in valid version format. e.g. v1_10_R1"));
            }
            return new NMSVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
        }

        public boolean isHigherThan(NMSVersion o) {
            return this.compareTo(o) > 0;
        }

        public boolean isHigherThanOrEqualTo(NMSVersion o) {
            return this.compareTo(o) >= 0;
        }

        public boolean isLowerThan(NMSVersion o) {
            return this.compareTo(o) < 0;
        }

        public boolean isLowerThanOrEqualTo(NMSVersion o) {
            return this.compareTo(o) <= 0;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getRelease() {
            return this.release;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NMSVersion that = (NMSVersion)o;
            return this.major == that.major && this.minor == that.minor && this.release == that.release;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.major, this.minor, this.release});
        }

        public String toString() {
            return "v" + this.major + "_" + this.minor + "_R" + this.release;
        }

        @Override
        public int compareTo(NMSVersion o) {
            if (this.major < o.major) {
                return -1;
            }
            if (this.major > o.major) {
                return 1;
            }
            if (this.minor < o.minor) {
                return -1;
            }
            if (this.minor > o.minor) {
                return 1;
            }
            return Integer.compare(this.release, o.release);
        }
    }

    private static class MethodParams {
        private final String name;
        private final Class<?>[] params;

        MethodParams(String name, Class<?>[] params) {
            this.name = name;
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodParams)) {
                return false;
            }
            MethodParams that = (MethodParams)o;
            if (!that.canEqual(this)) {
                return false;
            }
            String thisName = this.name;
            String thatName = that.name;
            if (thisName == null ? thatName == null : thisName.equals(thatName)) {
                return Arrays.deepEquals(this.params, that.params);
            }
            return false;
        }

        boolean canEqual(Object that) {
            return that instanceof MethodParams;
        }

        public int hashCode() {
            int result = 1;
            String thisName = this.name;
            result = result * 31 + (thisName == null ? 0 : thisName.hashCode());
            result = result * 31 + Arrays.deepHashCode(this.params);
            return result;
        }
    }

    private static class ConstructorParams {
        private final Class<?>[] params;

        ConstructorParams(Class<?>[] params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstructorParams that = (ConstructorParams)o;
            return Arrays.deepEquals(this.params, that.params);
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.params);
        }
    }
}

