/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.nms.refl.providers;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.bukkit.Bukkit;

public class ReflOnlineModeProvider {
    private final MethodHandle spigotBungeeGetter;
    private final MethodHandle paperBungeeGetter;
    private final boolean fancyPaperCheck;

    public ReflOnlineModeProvider() {
        MethodHandle spigotBungeeGetter = null;
        MethodHandle paperBungeeGetter = null;
        boolean fancyCheck = false;
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            spigotBungeeGetter = lookup.findStaticGetter(Class.forName("org.spigotmc.SpigotConfig"), "bungee", Boolean.TYPE);
            Class<?> paperConfig = Class.forName("com.destroystokyo.paper.PaperConfig");
            paperBungeeGetter = lookup.findStaticGetter(paperConfig, "bungeeOnlineMode", Boolean.TYPE);
            paperBungeeGetter = lookup.findStatic(paperConfig, "isProxyOnlineMode", MethodType.methodType(Boolean.TYPE));
            fancyCheck = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.spigotBungeeGetter = spigotBungeeGetter;
        this.paperBungeeGetter = paperBungeeGetter;
        this.fancyPaperCheck = fancyCheck;
    }

    public String getOnlineModeString() {
        if (this.spigotBungeeGetter == null) {
            return Bukkit.getOnlineMode() ? "Online Mode" : "Offline Mode";
        }
        try {
            if (Bukkit.getOnlineMode()) {
                return "Online Mode";
            }
            if (this.fancyPaperCheck) {
                if (this.paperBungeeGetter.invoke()) {
                    return "Proxy Mode";
                }
                return "Offline Mode";
            }
            if (this.spigotBungeeGetter.invoke() && (this.paperBungeeGetter == null || this.paperBungeeGetter.invoke())) {
                return "Bungee Mode";
            }
            return "Offline Mode";
        }
        catch (Throwable ignored) {
            return "Unknown";
        }
    }
}

