/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.ArmorStand;
import me.neznamy.tab.api.TabPlayer;

public class ArmorStandManager {
    private final Map<String, ArmorStand> armorStands = new LinkedHashMap<String, ArmorStand>();
    private final List<TabPlayer> nearbyPlayers = new ArrayList<TabPlayer>();
    private ArmorStand[] armorStandArray = new ArmorStand[0];
    private TabPlayer[] nearbyPlayerArray = new TabPlayer[0];

    public void addArmorStand(String name, ArmorStand as) {
        this.armorStands.put(name, as);
        this.armorStandArray = this.armorStands.values().toArray(new ArmorStand[0]);
        for (TabPlayer p : this.nearbyPlayerArray) {
            as.spawn(p);
        }
    }

    public ArmorStand getArmorStand(String name) {
        return this.armorStands.get(name);
    }

    public void removeArmorStand(String name) {
        this.armorStands.get(name).destroy();
        this.armorStands.remove(name);
        this.armorStandArray = this.armorStands.values().toArray(new ArmorStand[0]);
    }

    public void spawn(TabPlayer viewer) {
        this.nearbyPlayers.add(viewer);
        this.nearbyPlayerArray = this.nearbyPlayers.toArray(new TabPlayer[0]);
        if (viewer.getVersion().getMinorVersion() < 8) {
            return;
        }
        for (ArmorStand a : this.armorStandArray) {
            a.spawn(viewer);
        }
    }

    public void sneak(boolean sneaking) {
        for (ArmorStand a : this.armorStandArray) {
            a.sneak(sneaking);
        }
    }

    public void teleport() {
        for (ArmorStand a : this.armorStandArray) {
            a.teleport();
        }
    }

    public void teleport(TabPlayer viewer) {
        for (ArmorStand a : this.armorStandArray) {
            a.teleport(viewer);
        }
    }

    public void refresh() {
        for (ArmorStand a : this.armorStandArray) {
            a.refresh();
        }
    }

    public void updateVisibility(boolean force) {
        for (ArmorStand a : this.armorStandArray) {
            a.updateVisibility(force);
        }
    }

    public void unregisterPlayer(TabPlayer viewer) {
        if (this.nearbyPlayers.remove(viewer)) {
            this.nearbyPlayerArray = this.nearbyPlayers.toArray(new TabPlayer[0]);
        }
    }

    public void destroy() {
        for (ArmorStand a : this.armorStandArray) {
            a.destroy();
        }
        this.nearbyPlayers.clear();
        this.nearbyPlayerArray = new TabPlayer[0];
    }

    public void destroy(TabPlayer viewer) {
        for (ArmorStand a : this.armorStandArray) {
            a.destroy(viewer);
        }
        this.unregisterPlayer(viewer);
    }

    public boolean hasArmorStandWithID(int entityId) {
        for (ArmorStand a : this.armorStandArray) {
            if (a.getEntityId() != entityId) continue;
            return true;
        }
        return false;
    }

    public ArmorStand[] getArmorStands() {
        return this.armorStandArray;
    }

    public TabPlayer[] getNearbyPlayers() {
        return this.nearbyPlayerArray;
    }

    public boolean isNearby(TabPlayer viewer) {
        return this.nearbyPlayers.contains(viewer);
    }

    public void respawn() {
        for (ArmorStand a : this.armorStandArray) {
            for (TabPlayer viewer : this.nearbyPlayerArray) {
                a.respawn(viewer);
            }
        }
    }
}

