/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.chat;

import java.util.UUID;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.chat.ChatClickable;
import me.neznamy.tab.api.chat.ChatComponentEntity;
import me.neznamy.tab.api.chat.ChatHoverable;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.chat.TextColor;
import me.neznamy.tab.libs.org.json.simple.JSONObject;

public class ChatModifier {
    private TextColor color;
    private Boolean bold;
    private Boolean italic;
    private Boolean underlined;
    private Boolean strikethrough;
    private Boolean obfuscated;
    private ChatClickable clickEvent;
    private ChatHoverable hoverEvent;
    private String font;
    private ProtocolVersion targetVersion;

    public ChatModifier() {
    }

    public ChatModifier(ChatModifier modifier) {
        this.color = modifier.color == null ? null : new TextColor(modifier.color);
        this.bold = modifier.bold;
        this.italic = modifier.italic;
        this.underlined = modifier.underlined;
        this.strikethrough = modifier.strikethrough;
        this.obfuscated = modifier.obfuscated;
        this.clickEvent = modifier.clickEvent == null ? null : new ChatClickable(modifier.clickEvent.getAction(), modifier.clickEvent.getValue());
        this.hoverEvent = modifier.hoverEvent == null ? null : new ChatHoverable(modifier.hoverEvent.getAction(), modifier.hoverEvent.getValue());
        this.font = modifier.font;
        this.targetVersion = modifier.targetVersion;
    }

    public TextColor getColor() {
        return this.color;
    }

    public void setColor(TextColor color) {
        this.color = color;
    }

    public Boolean getBold() {
        return this.bold;
    }

    public void setBold(Boolean bold) {
        this.bold = bold;
    }

    public Boolean getItalic() {
        return this.italic;
    }

    public void setItalic(Boolean italic) {
        this.italic = italic;
    }

    public Boolean getUnderlined() {
        return this.underlined;
    }

    public void setUnderlined(Boolean underlined) {
        this.underlined = underlined;
    }

    public Boolean getStrikethrough() {
        return this.strikethrough;
    }

    public void setStrikethrough(Boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    public Boolean getObfuscated() {
        return this.obfuscated;
    }

    public void setObfuscated(Boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    public boolean isBold() {
        return Boolean.TRUE.equals(this.bold);
    }

    public boolean isItalic() {
        return Boolean.TRUE.equals(this.italic);
    }

    public boolean isUnderlined() {
        return Boolean.TRUE.equals(this.underlined);
    }

    public boolean isStrikethrough() {
        return Boolean.TRUE.equals(this.strikethrough);
    }

    public boolean isObfuscated() {
        return Boolean.TRUE.equals(this.obfuscated);
    }

    public ChatClickable getClickEvent() {
        return this.clickEvent;
    }

    public void setClickEvent(ChatClickable clickEvent) {
        this.clickEvent = clickEvent;
    }

    public ChatHoverable getHoverEvent() {
        return this.hoverEvent;
    }

    public void setHoverEvent(ChatHoverable hoverEvent) {
        this.hoverEvent = hoverEvent;
    }

    public void onClickOpenUrl(String url) {
        this.clickEvent = new ChatClickable(ChatClickable.EnumClickAction.OPEN_URL, url);
    }

    public void onClickRunCommand(String command) {
        this.clickEvent = new ChatClickable(ChatClickable.EnumClickAction.RUN_COMMAND, command);
    }

    public void onClickSuggestCommand(String command) {
        this.clickEvent = new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, command);
    }

    public void onClickChangePage(int newPage) {
        if (TabAPI.getInstance().getServerVersion().getMinorVersion() < 8) {
            throw new UnsupportedOperationException("change_page click action is not supported on <1.8");
        }
        this.clickEvent = new ChatClickable(ChatClickable.EnumClickAction.CHANGE_PAGE, String.valueOf(newPage));
    }

    public void onClickCopyToClipBoard(String text) {
        this.clickEvent = new ChatClickable(ChatClickable.EnumClickAction.COPY_TO_CLIPBOARD, text);
    }

    public void onClick(ChatClickable.EnumClickAction action, String value) {
        this.clickEvent = new ChatClickable(action, value);
    }

    public void onHoverShowText(IChatBaseComponent text) {
        this.hoverEvent = new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, text);
    }

    public void onHoverShowItem(String serializedItem) {
        this.hoverEvent = new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ITEM, new IChatBaseComponent(serializedItem));
    }

    public void onHoverShowEntity(String type, UUID id, String name) {
        if (TabAPI.getInstance().getServerVersion().getMinorVersion() >= 16) {
            this.hoverEvent = new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ENTITY, new ChatComponentEntity(type, id, name));
        } else if (TabAPI.getInstance().getServerVersion().getMinorVersion() >= 13) {
            this.hoverEvent = new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ENTITY, new IChatBaseComponent(String.format("{type:\"%s\",id:\"%s\",name:\"{\\\"text\\\":\\\"%s\\\"}\"}", type, id, name)));
        } else if (TabAPI.getInstance().getServerVersion().getMinorVersion() == 12) {
            this.hoverEvent = new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ENTITY, new IChatBaseComponent(String.format("{type:\"%s\",id:\"%s\",name:\"%s\"}", type, id, name)));
        } else if (TabAPI.getInstance().getServerVersion().getMinorVersion() >= 8) {
            this.hoverEvent = new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_ENTITY, new IChatBaseComponent(String.format("{type:%s,id:%s,name:%s}", type, id, name)));
        } else {
            throw new IllegalStateException("show_entity hover action is not supported on <1.8");
        }
    }

    public void onHover(ChatHoverable.EnumHoverAction action, IChatBaseComponent value) {
        this.hoverEvent = new ChatHoverable(action, value);
    }

    public String getFont() {
        return this.font;
    }

    public void setFont(String font) {
        this.font = font;
    }

    public JSONObject serialize() {
        JSONObject json = new JSONObject();
        if (this.color != null) {
            json.put("color", this.targetVersion.getMinorVersion() >= 16 ? this.color.toString() : this.color.getLegacyColor().toString().toLowerCase());
        }
        if (this.bold != null) {
            json.put("bold", this.bold);
        }
        if (this.italic != null) {
            json.put("italic", this.italic);
        }
        if (this.underlined != null) {
            json.put("underlined", this.underlined);
        }
        if (this.strikethrough != null) {
            json.put("strikethrough", this.strikethrough);
        }
        if (this.obfuscated != null) {
            json.put("obfuscated", this.obfuscated);
        }
        if (this.clickEvent != null) {
            JSONObject click = new JSONObject();
            click.put("action", this.clickEvent.getAction().toString().toLowerCase());
            click.put("value", this.clickEvent.getValue());
            json.put("clickEvent", click);
        }
        if (this.hoverEvent != null) {
            JSONObject hover = new JSONObject();
            hover.put("action", this.hoverEvent.getAction().toString().toLowerCase());
            if (TabAPI.getInstance().getServerVersion().getMinorVersion() >= 16) {
                hover.put("contents", this.hoverEvent.getValue());
            } else {
                hover.put("value", TabAPI.getInstance().getServerVersion().getMinorVersion() >= 9 ? this.hoverEvent.getValue() : this.hoverEvent.getValue().toRawText());
            }
            json.put("hoverEvent", hover);
        }
        if (this.font != null) {
            json.put("font", this.font);
        }
        return json;
    }

    public String getMagicCodes() {
        StringBuilder builder = new StringBuilder();
        if (this.isBold()) {
            builder.append(EnumChatFormat.BOLD.getFormat());
        }
        if (this.isItalic()) {
            builder.append(EnumChatFormat.ITALIC.getFormat());
        }
        if (this.isUnderlined()) {
            builder.append(EnumChatFormat.UNDERLINE.getFormat());
        }
        if (this.isStrikethrough()) {
            builder.append(EnumChatFormat.STRIKETHROUGH.getFormat());
        }
        if (this.isObfuscated()) {
            builder.append(EnumChatFormat.OBFUSCATED.getFormat());
        }
        return builder.toString();
    }

    public void setTargetVersion(ProtocolVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    public ProtocolVersion getTargetVersion() {
        return this.targetVersion;
    }
}

