/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.chat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.chat.ChatClickable;
import me.neznamy.tab.api.chat.ChatComponentEntity;
import me.neznamy.tab.api.chat.ChatHoverable;
import me.neznamy.tab.api.chat.ChatModifier;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.TextColor;
import me.neznamy.tab.api.chat.rgb.RGBUtils;
import me.neznamy.tab.api.util.Preconditions;
import me.neznamy.tab.libs.org.json.simple.JSONObject;
import me.neznamy.tab.libs.org.json.simple.parser.JSONParser;
import me.neznamy.tab.libs.org.json.simple.parser.ParseException;

public class IChatBaseComponent {
    private static final Map<String, IChatBaseComponent> componentCache = new HashMap<String, IChatBaseComponent>();
    private static final Map<IChatBaseComponent, String> serializeCacheModern = new HashMap<IChatBaseComponent, String>();
    private static final Map<IChatBaseComponent, String> serializeCacheLegacy = new HashMap<IChatBaseComponent, String>();
    private String text;
    private ChatModifier modifier = new ChatModifier();
    private List<IChatBaseComponent> extra;

    public IChatBaseComponent() {
    }

    public IChatBaseComponent(IChatBaseComponent component) {
        this.text = component.text;
        this.modifier = new ChatModifier(component.modifier);
        for (IChatBaseComponent child : component.getExtra()) {
            this.addExtra(new IChatBaseComponent(child));
        }
    }

    public IChatBaseComponent(String text) {
        this.text = text;
    }

    public List<IChatBaseComponent> getExtra() {
        if (this.extra == null) {
            return Collections.emptyList();
        }
        return this.extra;
    }

    public IChatBaseComponent setExtra(List<IChatBaseComponent> components) {
        if (components.isEmpty()) {
            throw new IllegalArgumentException("Unexpected empty array of components");
        }
        this.extra = components;
        return this;
    }

    public void addExtra(IChatBaseComponent child) {
        if (this.extra == null) {
            this.extra = new ArrayList<IChatBaseComponent>();
        }
        this.extra.add(child);
    }

    public String getText() {
        return this.text;
    }

    public ChatModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(ChatModifier modifier) {
        Preconditions.checkNotNull(modifier, "modifier");
        this.modifier = modifier;
    }

    public void setText(String text) {
        this.text = text;
    }

    public static IChatBaseComponent deserialize(String json) {
        String value;
        String action;
        JSONObject jsonObject;
        if (json == null) {
            return null;
        }
        if (json.startsWith("\"") && json.endsWith("\"") && json.length() > 1) {
            return new IChatBaseComponent(json.substring(1, json.length() - 1));
        }
        try {
            jsonObject = (JSONObject)new JSONParser().parse(json);
        }
        catch (ParseException e) {
            TabAPI.getInstance().logError("Failed to deserialize json component " + json, e);
            return null;
        }
        if (jsonObject.containsKey("type")) {
            return new ChatComponentEntity((String)jsonObject.get("type"), UUID.fromString((String)jsonObject.get("id")), IChatBaseComponent.deserialize(jsonObject.get("name").toString()).toFlatText());
        }
        IChatBaseComponent component = new IChatBaseComponent();
        component.setText((String)jsonObject.get("text"));
        component.modifier.setBold(IChatBaseComponent.getBoolean(jsonObject, "bold"));
        component.modifier.setItalic(IChatBaseComponent.getBoolean(jsonObject, "italic"));
        component.modifier.setUnderlined(IChatBaseComponent.getBoolean(jsonObject, "underlined"));
        component.modifier.setStrikethrough(IChatBaseComponent.getBoolean(jsonObject, "strikethrough"));
        component.modifier.setObfuscated(IChatBaseComponent.getBoolean(jsonObject, "obfuscated"));
        component.modifier.setColor(TextColor.fromString((String)jsonObject.get("color")));
        if (jsonObject.containsKey("clickEvent")) {
            JSONObject clickEvent = (JSONObject)jsonObject.get("clickEvent");
            action = (String)clickEvent.get("action");
            value = clickEvent.get("value").toString();
            component.modifier.onClick(ChatClickable.EnumClickAction.valueOf(action.toUpperCase()), value);
        }
        if (jsonObject.containsKey("hoverEvent")) {
            JSONObject hoverEvent = (JSONObject)jsonObject.get("hoverEvent");
            action = (String)hoverEvent.get("action");
            value = (String)hoverEvent.get("value");
            component.modifier.onHover(ChatHoverable.EnumHoverAction.valueOf(action.toUpperCase()), IChatBaseComponent.deserialize(value));
        }
        if (jsonObject.containsKey("extra")) {
            List list = (List)jsonObject.get("extra");
            for (Object extra : list) {
                String string = extra.toString();
                if (!string.startsWith("{")) {
                    string = "\"" + string + "\"";
                }
                component.addExtra(IChatBaseComponent.deserialize(string));
            }
        }
        return component;
    }

    private static Boolean getBoolean(JSONObject jsonObject, String key) {
        String value = String.valueOf(jsonObject.getOrDefault(key, null));
        return "null".equals(value) ? null : Boolean.valueOf(Boolean.parseBoolean(value));
    }

    public String toString() {
        JSONObject json = new JSONObject();
        if (this.text != null) {
            json.put("text", this.text);
        }
        if (this.modifier.getTargetVersion() == null) {
            this.modifier.setTargetVersion(TabAPI.getInstance().getServerVersion());
        }
        json.putAll(this.modifier.serialize());
        if (this.extra != null) {
            json.put("extra", this.extra);
        }
        return json.toString();
    }

    public String toString(ProtocolVersion clientVersion) {
        return this.toString(clientVersion, false);
    }

    public String toString(ProtocolVersion clientVersion, boolean sendTranslatableIfEmpty) {
        String string;
        if (this.extra == null) {
            if (this.text == null) {
                return null;
            }
            if (this.text.length() == 0) {
                if (sendTranslatableIfEmpty) {
                    return "{\"translate\":\"\"}";
                }
                return "{\"text\":\"\"}";
            }
        }
        this.modifier.setTargetVersion(clientVersion);
        for (IChatBaseComponent child : this.getExtra()) {
            child.modifier.setTargetVersion(clientVersion);
        }
        if (clientVersion.getMinorVersion() >= 16) {
            if (serializeCacheModern.containsKey(this)) {
                return serializeCacheModern.get(this);
            }
            string = this.toString();
            if (serializeCacheModern.size() > 10000) {
                serializeCacheModern.clear();
            }
            serializeCacheModern.put(this, string);
        } else {
            if (serializeCacheLegacy.containsKey(this)) {
                return serializeCacheLegacy.get(this);
            }
            string = this.toString();
            if (serializeCacheLegacy.size() > 10000) {
                serializeCacheLegacy.clear();
            }
            serializeCacheLegacy.put(this, string);
        }
        return string;
    }

    public static IChatBaseComponent fromColoredText(String originalText) {
        String text = RGBUtils.getInstance().applyFormats(EnumChatFormat.color(originalText), false);
        ArrayList<IChatBaseComponent> components = new ArrayList<IChatBaseComponent>();
        StringBuilder builder = new StringBuilder();
        IChatBaseComponent component = new IChatBaseComponent();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\u00a7') {
                EnumChatFormat format;
                if (++i >= text.length()) break;
                c = text.charAt(i);
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if ((format = EnumChatFormat.getByChar(c)) == null) continue;
                if (builder.length() > 0) {
                    component.setText(builder.toString());
                    components.add(component);
                    component = new IChatBaseComponent(component);
                    component.text = null;
                    builder = new StringBuilder();
                }
                switch (format) {
                    case BOLD: {
                        component.modifier.setBold(true);
                        break;
                    }
                    case ITALIC: {
                        component.modifier.setItalic(true);
                        break;
                    }
                    case UNDERLINE: {
                        component.modifier.setUnderlined(true);
                        break;
                    }
                    case STRIKETHROUGH: {
                        component.modifier.setStrikethrough(true);
                        break;
                    }
                    case OBFUSCATED: {
                        component.modifier.setObfuscated(true);
                        break;
                    }
                    case RESET: {
                        component = new IChatBaseComponent();
                        component.modifier.setColor(new TextColor(EnumChatFormat.WHITE));
                        break;
                    }
                    default: {
                        component = new IChatBaseComponent();
                        component.modifier.setColor(new TextColor(format));
                    }
                }
                continue;
            }
            if (c == '#' && text.length() > i + 6) {
                String hex = text.substring(i + 1, i + 7);
                if (RGBUtils.getInstance().isHexCode(hex)) {
                    TextColor color;
                    if (IChatBaseComponent.containsLegacyCode(text, i)) {
                        color = new TextColor(hex, EnumChatFormat.getByChar(text.charAt(i + 8)));
                        i += 8;
                    } else {
                        color = new TextColor(hex);
                        i += 6;
                    }
                    if (builder.length() > 0) {
                        component.setText(builder.toString());
                        components.add(component);
                        builder = new StringBuilder();
                    }
                    component = new IChatBaseComponent();
                    component.modifier.setColor(color);
                    continue;
                }
                builder.append(c);
                continue;
            }
            builder.append(c);
        }
        component.setText(builder.toString());
        components.add(component);
        return new IChatBaseComponent("").setExtra(components);
    }

    private static boolean containsLegacyCode(String text, int i) {
        if (text.length() - i < 9 || text.charAt(i + 7) != '|') {
            return false;
        }
        return EnumChatFormat.getByChar(text.charAt(i + 8)) != null;
    }

    public String toLegacyText() {
        StringBuilder builder = new StringBuilder();
        this.append(builder, "");
        return builder.toString();
    }

    private String append(StringBuilder builder, String previousFormatting) {
        String formatting = previousFormatting;
        if (this.text != null) {
            formatting = this.getFormatting();
            if (!formatting.equals(previousFormatting)) {
                builder.append(formatting);
            }
            builder.append(this.text);
        }
        for (IChatBaseComponent component : this.getExtra()) {
            formatting = component.append(builder, formatting);
        }
        return formatting;
    }

    private String getFormatting() {
        StringBuilder builder = new StringBuilder();
        if (this.modifier.getColor() != null) {
            if (this.modifier.getColor().getLegacyColor() == EnumChatFormat.WHITE) {
                builder.append(EnumChatFormat.RESET.getFormat());
            } else {
                builder.append(this.modifier.getColor().getLegacyColor().getFormat());
            }
        }
        builder.append(this.modifier.getMagicCodes());
        return builder.toString();
    }

    public String toRawText() {
        StringBuilder builder = new StringBuilder();
        if (this.text != null) {
            builder.append(this.text);
        }
        for (IChatBaseComponent child : this.getExtra()) {
            if (child.text == null) continue;
            builder.append(child.text);
        }
        return builder.toString();
    }

    public String toFlatText() {
        StringBuilder builder = new StringBuilder();
        if (this.modifier.getColor() != null) {
            builder.append("#").append(this.modifier.getColor().getHexCode());
        }
        builder.append(this.modifier.getMagicCodes());
        if (this.text != null) {
            builder.append(this.text);
        }
        for (IChatBaseComponent child : this.getExtra()) {
            builder.append(child.toFlatText());
        }
        return builder.toString();
    }

    public static IChatBaseComponent optimizedComponent(String text) {
        if (text == null) {
            return null;
        }
        if (componentCache.containsKey(text)) {
            return componentCache.get(text);
        }
        IChatBaseComponent component = text.contains("#") || text.contains("&x") || text.contains("\u00a7x") ? IChatBaseComponent.fromColoredText(text) : new IChatBaseComponent(text);
        if (componentCache.size() > 10000) {
            componentCache.clear();
        }
        componentCache.put(text, component);
        return component;
    }
}

