/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.chat;

import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.util.Preconditions;

public class TextColor {
    private int rgb = -1;
    private EnumChatFormat legacyColor;
    private String hexCode;
    private boolean legacyColorForced;

    public TextColor(TextColor color) {
        Preconditions.checkNotNull(color, "color cannot be null");
        this.rgb = color.rgb;
        this.legacyColor = color.legacyColor;
        this.hexCode = color.hexCode;
        this.legacyColorForced = color.legacyColorForced;
    }

    public TextColor(String hexCode) {
        Preconditions.checkNotNull(hexCode, "hex code cannot be null");
        this.hexCode = hexCode;
    }

    public TextColor(String hexCode, EnumChatFormat legacyColor) {
        Preconditions.checkNotNull(hexCode, "hex code cannot be null");
        Preconditions.checkNotNull((Object)legacyColor, "legacy color cannot be null");
        this.hexCode = hexCode;
        this.legacyColorForced = true;
        this.legacyColor = legacyColor;
    }

    public TextColor(EnumChatFormat legacyColor) {
        Preconditions.checkNotNull((Object)legacyColor, "legacy color cannot be null");
        this.rgb = (legacyColor.getRed() << 16) + (legacyColor.getGreen() << 8) + legacyColor.getBlue();
        this.hexCode = legacyColor.getHexCode();
    }

    public TextColor(int red, int green, int blue) {
        Preconditions.checkRange(red, 0, 255, "red color");
        Preconditions.checkRange(green, 0, 255, "green color");
        Preconditions.checkRange(blue, 0, 255, "blue color");
        this.rgb = (red << 16) + (green << 8) + blue;
    }

    private EnumChatFormat loadClosestColor() {
        double minMaxDist = 9999.0;
        EnumChatFormat closestColor = EnumChatFormat.WHITE;
        for (EnumChatFormat color : EnumChatFormat.values()) {
            int rDiff = Math.abs(color.getRed() - this.getRed());
            int gDiff = Math.abs(color.getGreen() - this.getGreen());
            int bDiff = Math.abs(color.getBlue() - this.getBlue());
            double maxDist = rDiff;
            if ((double)gDiff > maxDist) {
                maxDist = gDiff;
            }
            if ((double)bDiff > maxDist) {
                maxDist = bDiff;
            }
            if (!(maxDist < minMaxDist)) continue;
            minMaxDist = maxDist;
            closestColor = color;
        }
        return closestColor;
    }

    public int getRed() {
        if (this.rgb == -1) {
            this.rgb = Integer.parseInt(this.hexCode, 16);
        }
        return this.rgb >> 16 & 0xFF;
    }

    public int getGreen() {
        if (this.rgb == -1) {
            this.rgb = Integer.parseInt(this.hexCode, 16);
        }
        return this.rgb >> 8 & 0xFF;
    }

    public int getBlue() {
        if (this.rgb == -1) {
            this.rgb = Integer.parseInt(this.hexCode, 16);
        }
        return this.rgb & 0xFF;
    }

    public EnumChatFormat getLegacyColor() {
        if (this.legacyColor == null) {
            this.legacyColor = this.loadClosestColor();
        }
        return this.legacyColor;
    }

    public String getHexCode() {
        if (this.hexCode == null) {
            this.hexCode = String.format("%06X", this.rgb);
        }
        return this.hexCode;
    }

    public String toString() {
        EnumChatFormat legacyEquivalent = EnumChatFormat.fromRGBExact(this.getRed(), this.getGreen(), this.getBlue());
        if (legacyEquivalent != null) {
            return legacyEquivalent.toString().toLowerCase();
        }
        return "#" + this.getHexCode();
    }

    public boolean isLegacyColorForced() {
        return this.legacyColorForced;
    }

    public static TextColor fromString(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("#")) {
            return new TextColor(string.substring(1));
        }
        return new TextColor(EnumChatFormat.valueOf(string.toUpperCase()));
    }
}

