/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.config.ConfigurationFile;
import me.neznamy.yamlassist.YamlAssist;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlConfigurationFile
extends ConfigurationFile {
    private static final Yaml yaml;

    public YamlConfigurationFile(InputStream source, File destination) throws YAMLException, IOException {
        super(source, destination);
        FileInputStream input = null;
        try {
            input = new FileInputStream(this.file);
            this.values = (Map)yaml.load((InputStream)input);
            if (this.values == null) {
                this.values = new LinkedHashMap();
            }
            input.close();
        }
        catch (YAMLException e) {
            if (input != null) {
                input.close();
            }
            TabAPI tab = TabAPI.getInstance();
            tab.sendConsoleMessage("&c[TAB] File " + destination + " has broken syntax.", true);
            tab.sendConsoleMessage("&6[TAB] Error message from yaml parser: " + e.getMessage(), true);
            List<String> suggestions = YamlAssist.getSuggestions(this.file);
            if (!suggestions.isEmpty()) {
                tab.sendConsoleMessage("&d[TAB] Suggestions to fix yaml syntax:", true);
                for (String suggestion : suggestions) {
                    tab.sendConsoleMessage("&d[TAB] - " + suggestion, true);
                }
            }
            throw e;
        }
    }

    @Override
    public void save() {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), StandardCharsets.UTF_8);
            yaml.dump((Object)this.values, (Writer)writer);
            ((Writer)writer).close();
            this.fixHeader();
        }
        catch (IOException e) {
            TabAPI.getInstance().sendConsoleMessage("&c[TAB] Failed to save yaml file " + this.file.getPath() + " with content " + this.values.toString(), true);
        }
    }

    static {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        yaml = new Yaml(options);
    }
}

