/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.protocol;

import java.util.HashMap;
import java.util.Map;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.chat.rgb.RGBUtils;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.PacketPlayOutChat;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerListHeaderFooter;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.api.util.BiFunctionWithException;

public abstract class PacketBuilder {
    protected final Map<Class<? extends TabPacket>, BiFunctionWithException<TabPacket, ProtocolVersion, Object>> buildMap = new HashMap<Class<? extends TabPacket>, BiFunctionWithException<TabPacket, ProtocolVersion, Object>>();

    protected PacketBuilder() {
        this.buildMap.put(PacketPlayOutBoss.class, (packet, version) -> this.build((PacketPlayOutBoss)packet, (ProtocolVersion)((Object)version)));
        this.buildMap.put(PacketPlayOutChat.class, (packet, version) -> this.build((PacketPlayOutChat)packet, (ProtocolVersion)((Object)version)));
        this.buildMap.put(PacketPlayOutPlayerInfo.class, (packet, version) -> this.build((PacketPlayOutPlayerInfo)packet, (ProtocolVersion)((Object)version)));
        this.buildMap.put(PacketPlayOutPlayerListHeaderFooter.class, (packet, version) -> this.build((PacketPlayOutPlayerListHeaderFooter)packet, (ProtocolVersion)((Object)version)));
        this.buildMap.put(PacketPlayOutScoreboardDisplayObjective.class, (packet, version) -> this.build((PacketPlayOutScoreboardDisplayObjective)packet, (ProtocolVersion)((Object)version)));
        this.buildMap.put(PacketPlayOutScoreboardObjective.class, (packet, version) -> this.build((PacketPlayOutScoreboardObjective)packet, (ProtocolVersion)((Object)version)));
        this.buildMap.put(PacketPlayOutScoreboardScore.class, (packet, version) -> this.build((PacketPlayOutScoreboardScore)packet, (ProtocolVersion)((Object)version)));
        this.buildMap.put(PacketPlayOutScoreboardTeam.class, (packet, version) -> this.build((PacketPlayOutScoreboardTeam)packet, (ProtocolVersion)((Object)version)));
    }

    public Object build(TabPacket packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        return this.buildMap.get(packet.getClass()).apply(packet, clientVersion);
    }

    public abstract Object build(PacketPlayOutBoss var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public abstract Object build(PacketPlayOutChat var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public abstract Object build(PacketPlayOutPlayerInfo var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public abstract Object build(PacketPlayOutPlayerListHeaderFooter var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public abstract Object build(PacketPlayOutScoreboardDisplayObjective var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public abstract Object build(PacketPlayOutScoreboardObjective var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public abstract Object build(PacketPlayOutScoreboardScore var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public abstract Object build(PacketPlayOutScoreboardTeam var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public String cutTo(String string, int length) {
        if (string == null) {
            return "";
        }
        String legacyText = string;
        if (string.contains("#")) {
            legacyText = RGBUtils.getInstance().convertRGBtoLegacy(string);
        }
        if (legacyText.length() <= length) {
            return legacyText;
        }
        if (legacyText.charAt(length - 1) == '\u00a7') {
            return legacyText.substring(0, length - 1);
        }
        return legacyText.substring(0, length);
    }

    public String jsonOrCut(String text, ProtocolVersion clientVersion, int length) {
        if (text == null) {
            return null;
        }
        if (clientVersion.getMinorVersion() >= 13) {
            return IChatBaseComponent.optimizedComponent(text).toString(clientVersion);
        }
        return this.cutTo(text, length);
    }

    public abstract PacketPlayOutPlayerInfo readPlayerInfo(Object var1, ProtocolVersion var2) throws ReflectiveOperationException;

    public abstract PacketPlayOutScoreboardObjective readObjective(Object var1) throws ReflectiveOperationException;

    public abstract PacketPlayOutScoreboardDisplayObjective readDisplayObjective(Object var1) throws ReflectiveOperationException;
}

