/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.protocol;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.TabPacket;

public class PacketPlayOutPlayerInfo
implements TabPacket {
    private final EnumPlayerInfoAction action;
    private final List<PlayerInfoData> entries;

    public PacketPlayOutPlayerInfo(EnumPlayerInfoAction action, PlayerInfoData ... entries) {
        this.action = action;
        this.entries = Arrays.asList(entries);
    }

    public PacketPlayOutPlayerInfo(EnumPlayerInfoAction action, List<PlayerInfoData> entries) {
        this.action = action;
        this.entries = entries;
    }

    @Override
    public String toString() {
        return String.format("PacketPlayOutPlayerInfo{action=%s,entries=%s}", new Object[]{this.action, this.entries});
    }

    public EnumPlayerInfoAction getAction() {
        return this.action;
    }

    public List<PlayerInfoData> getEntries() {
        return this.entries;
    }

    public static enum EnumPlayerInfoAction {
        ADD_PLAYER,
        UPDATE_GAME_MODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }

    public static enum EnumGamemode {
        NOT_SET,
        SURVIVAL,
        CREATIVE,
        ADVENTURE,
        SPECTATOR;

    }

    public static class PlayerInfoData {
        private int latency;
        private EnumGamemode gameMode = EnumGamemode.SURVIVAL;
        private IChatBaseComponent displayName;
        private String name;
        private UUID uniqueId;
        private Object skin;

        public PlayerInfoData(String name, UUID uniqueId, Object skin, int latency, EnumGamemode gameMode, IChatBaseComponent displayName) {
            this.name = name;
            this.uniqueId = uniqueId;
            this.skin = skin;
            this.latency = latency;
            this.gameMode = gameMode;
            this.displayName = displayName;
        }

        public PlayerInfoData(UUID uniqueId, EnumGamemode gameMode) {
            this.uniqueId = uniqueId;
            this.gameMode = gameMode;
        }

        public PlayerInfoData(UUID uniqueId, int latency) {
            this.uniqueId = uniqueId;
            this.latency = latency;
        }

        public PlayerInfoData(UUID uniqueId, IChatBaseComponent displayName) {
            this.uniqueId = uniqueId;
            this.displayName = displayName;
        }

        public PlayerInfoData(UUID uniqueId) {
            this.uniqueId = uniqueId;
        }

        public String toString() {
            return String.format("PlayerInfoData{latency=%s,gameMode=%s,displayName=%s,name=%s,uniqueId=%s,skin=%s}", new Object[]{this.latency, this.gameMode, this.displayName, this.name, this.uniqueId, this.skin});
        }

        public int getLatency() {
            return this.latency;
        }

        public void setLatency(int latency) {
            this.latency = latency;
        }

        public IChatBaseComponent getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(IChatBaseComponent displayName) {
            this.displayName = displayName;
        }

        public UUID getUniqueId() {
            return this.uniqueId;
        }

        public void setUniqueId(UUID uniqueId) {
            this.uniqueId = uniqueId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public EnumGamemode getGameMode() {
            return this.gameMode;
        }

        public void setGameMode(EnumGamemode gameMode) {
            this.gameMode = gameMode;
        }

        public Object getSkin() {
            return this.skin;
        }

        public void setSkin(Object skin) {
            this.skin = skin;
        }
    }
}

