/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.api.protocol;

import me.neznamy.tab.api.protocol.TabPacket;

public class PacketPlayOutScoreboardObjective
implements TabPacket {
    private final String objectiveName;
    private final String displayName;
    private final EnumScoreboardHealthDisplay renderType;
    private final int method;

    public PacketPlayOutScoreboardObjective(int method, String objectiveName, String displayName, EnumScoreboardHealthDisplay renderType) {
        if (objectiveName == null) {
            throw new IllegalArgumentException("objectiveName cannot be null");
        }
        if (objectiveName.length() > 16) {
            throw new IllegalArgumentException("objectiveName cannot be longer than 16 character (is " + objectiveName.length() + ")");
        }
        this.objectiveName = objectiveName;
        this.displayName = displayName;
        this.renderType = renderType;
        this.method = method;
    }

    public PacketPlayOutScoreboardObjective(String objectiveName) {
        if (objectiveName == null) {
            throw new IllegalArgumentException("objectiveName cannot be null");
        }
        if (objectiveName.length() > 16) {
            throw new IllegalArgumentException("objectiveName cannot be longer than 16 character (is " + objectiveName.length() + ")");
        }
        this.objectiveName = objectiveName;
        this.displayName = "";
        this.method = 1;
        this.renderType = null;
    }

    @Override
    public String toString() {
        return String.format("PacketPlayOutScoreboardObjective{objectiveName=%s,displayName=%s,renderType=%s,method=%s}", new Object[]{this.objectiveName, this.displayName, this.renderType, this.method});
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getObjectiveName() {
        return this.objectiveName;
    }

    public EnumScoreboardHealthDisplay getRenderType() {
        return this.renderType;
    }

    public int getMethod() {
        return this.method;
    }

    public static enum EnumScoreboardHealthDisplay {
        INTEGER,
        HEARTS;

    }
}

