/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.chat.ChatClickable;
import me.neznamy.tab.api.chat.ChatComponentEntity;
import me.neznamy.tab.api.chat.ChatHoverable;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.chat.TextColor;
import me.neznamy.tab.api.protocol.PacketBuilder;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.PacketPlayOutChat;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerListHeaderFooter;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardDisplayObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardObjective;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardScore;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityDestroy;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityMetadata;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityTeleport;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutSpawnEntityLiving;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcher;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.EntityType;

public class BukkitPacketBuilder
extends PacketBuilder {
    private final NMSStorage nms = NMSStorage.getInstance();
    private final EnumMap<EntityType, Integer> entityIds = new EnumMap(EntityType.class);
    private final Map<IChatBaseComponent, Object> componentCacheModern = new HashMap<IChatBaseComponent, Object>();
    private final Map<IChatBaseComponent, Object> componentCacheLegacy = new HashMap<IChatBaseComponent, Object>();
    private Object emptyScoreboard;
    private Object dummyEntity;

    public BukkitPacketBuilder() {
        if (this.nms.getMinorVersion() >= 13) {
            this.entityIds.put(EntityType.ARMOR_STAND, 1);
            this.entityIds.put(EntityType.WITHER, 83);
        } else {
            this.entityIds.put(EntityType.WITHER, 64);
            if (this.nms.getMinorVersion() >= 8) {
                this.entityIds.put(EntityType.ARMOR_STAND, 30);
            }
        }
        try {
            this.emptyScoreboard = this.nms.newScoreboard.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Bukkit.getConsoleSender().sendMessage(EnumChatFormat.color("&c[TAB] Failed to create instance of \"Scoreboard\""));
        }
        if (this.nms.getMinorVersion() >= 8) {
            try {
                this.dummyEntity = this.nms.newEntityArmorStand.newInstance(this.nms.World_getHandle.invoke(Bukkit.getWorlds().get(0), new Object[0]), 0, 0, 0);
            }
            catch (ReflectiveOperationException e) {
                Bukkit.getConsoleSender().sendMessage(EnumChatFormat.color("&c[TAB] Failed to create instance of \"EntityArmorStand\""));
            }
        }
        this.buildMap.put(PacketPlayOutEntityMetadata.class, (packet, version) -> this.build((PacketPlayOutEntityMetadata)packet));
        this.buildMap.put(PacketPlayOutEntityTeleport.class, (packet, version) -> this.build((PacketPlayOutEntityTeleport)packet));
        this.buildMap.put(PacketPlayOutEntityDestroy.class, (packet, version) -> this.build((PacketPlayOutEntityDestroy)packet));
        this.buildMap.put(PacketPlayOutSpawnEntityLiving.class, (packet, version) -> this.build((PacketPlayOutSpawnEntityLiving)packet));
    }

    @Override
    public Object build(PacketPlayOutBoss packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() >= 9 || clientVersion.getMinorVersion() >= 9) {
            return packet;
        }
        return this.buildBossPacketEntity(packet, clientVersion);
    }

    @Override
    public Object build(PacketPlayOutChat packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        Object component = this.toNMSComponent(packet.getMessage(), clientVersion);
        if (this.nms.getMinorVersion() >= 16) {
            return this.nms.newPacketPlayOutChat.newInstance(component, this.nms.ChatMessageType_values[packet.getType().ordinal()], UUID.randomUUID());
        }
        if (this.nms.getMinorVersion() >= 12) {
            return this.nms.newPacketPlayOutChat.newInstance(component, Enum.valueOf(this.nms.ChatMessageType, packet.getType().toString()));
        }
        if (this.nms.getMinorVersion() >= 8) {
            return this.nms.newPacketPlayOutChat.newInstance(component, (byte)packet.getType().ordinal());
        }
        if (this.nms.getMinorVersion() == 7) {
            return this.nms.newPacketPlayOutChat.newInstance(component);
        }
        throw new IllegalStateException("Not supported on <1.7");
    }

    @Override
    public Object build(PacketPlayOutPlayerInfo packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() < 8) {
            return null;
        }
        Object nmsPacket = this.nms.newPacketPlayOutPlayerInfo.newInstance(this.nms.EnumPlayerInfoAction_values[packet.getAction().ordinal()], Array.newInstance(this.nms.EntityPlayer, 0));
        ArrayList items = new ArrayList();
        for (PacketPlayOutPlayerInfo.PlayerInfoData data : packet.getEntries()) {
            GameProfile profile = new GameProfile(data.getUniqueId(), data.getName());
            if (data.getSkin() != null) {
                profile.getProperties().putAll((Multimap)((PropertyMap)data.getSkin()));
            }
            ArrayList<Object> parameters = new ArrayList<Object>();
            if (this.nms.newPlayerInfoData.getParameterCount() == 5) {
                parameters.add(nmsPacket);
            }
            parameters.add(profile);
            parameters.add(data.getLatency());
            parameters.add(data.getGameMode() == null ? null : this.nms.EnumGamemode_values[this.nms.EnumGamemode_values.length - PacketPlayOutPlayerInfo.EnumGamemode.values().length + data.getGameMode().ordinal()]);
            parameters.add(data.getDisplayName() == null ? null : this.toNMSComponent(data.getDisplayName(), clientVersion));
            items.add(this.nms.newPlayerInfoData.newInstance(parameters.toArray()));
        }
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutPlayerInfo_PLAYERS, items);
        return nmsPacket;
    }

    @Override
    public Object build(PacketPlayOutPlayerListHeaderFooter packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() < 8) {
            return null;
        }
        if (this.nms.newPacketPlayOutPlayerListHeaderFooter.getParameterCount() == 2) {
            return this.nms.newPacketPlayOutPlayerListHeaderFooter.newInstance(this.toNMSComponent(packet.getHeader(), clientVersion), this.toNMSComponent(packet.getFooter(), clientVersion));
        }
        Object nmsPacket = this.nms.newPacketPlayOutPlayerListHeaderFooter.newInstance(new Object[0]);
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutPlayerListHeaderFooter_HEADER, this.toNMSComponent(packet.getHeader(), clientVersion));
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutPlayerListHeaderFooter_FOOTER, this.toNMSComponent(packet.getFooter(), clientVersion));
        return nmsPacket;
    }

    @Override
    public Object build(PacketPlayOutScoreboardDisplayObjective packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        return this.nms.newPacketPlayOutScoreboardDisplayObjective.newInstance(packet.getSlot(), this.newScoreboardObjective(packet.getObjectiveName()));
    }

    @Override
    public Object build(PacketPlayOutScoreboardObjective packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        String displayName;
        String string = displayName = clientVersion.getMinorVersion() < 13 ? this.cutTo(packet.getDisplayName(), 32) : packet.getDisplayName();
        if (this.nms.getMinorVersion() >= 13) {
            return this.nms.newPacketPlayOutScoreboardObjective.newInstance(this.nms.newScoreboardObjective.newInstance(null, packet.getObjectiveName(), null, this.toNMSComponent(IChatBaseComponent.optimizedComponent(displayName), clientVersion), packet.getRenderType() == null ? null : this.nms.EnumScoreboardHealthDisplay_values[packet.getRenderType().ordinal()]), packet.getMethod());
        }
        Object nmsPacket = this.nms.newPacketPlayOutScoreboardObjective.newInstance(new Object[0]);
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutScoreboardObjective_OBJECTIVENAME, packet.getObjectiveName());
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutScoreboardObjective_DISPLAYNAME, displayName);
        if (this.nms.getMinorVersion() >= 8 && packet.getRenderType() != null) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutScoreboardObjective_RENDERTYPE, Enum.valueOf(this.nms.EnumScoreboardHealthDisplay, packet.getRenderType().toString()));
        }
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutScoreboardObjective_METHOD, packet.getMethod());
        return nmsPacket;
    }

    @Override
    public Object build(PacketPlayOutScoreboardScore packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() >= 13) {
            return this.nms.newPacketPlayOutScoreboardScore_1_13.newInstance(this.nms.EnumScoreboardAction_values[packet.getAction().ordinal()], packet.getObjectiveName(), packet.getPlayer(), packet.getScore());
        }
        if (packet.getAction() == PacketPlayOutScoreboardScore.Action.REMOVE) {
            return this.nms.newPacketPlayOutScoreboardScore_String.newInstance(packet.getPlayer());
        }
        Object score = this.nms.newScoreboardScore.newInstance(this.emptyScoreboard, this.newScoreboardObjective(packet.getObjectiveName()), packet.getPlayer());
        this.nms.ScoreboardScore_setScore.invoke(score, packet.getScore());
        if (this.nms.getMinorVersion() >= 8) {
            return this.nms.newPacketPlayOutScoreboardScore.newInstance(score);
        }
        return this.nms.newPacketPlayOutScoreboardScore.newInstance(score, 0);
    }

    @Override
    public Object build(PacketPlayOutScoreboardTeam packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.PacketPlayOutScoreboardTeam == null) {
            return null;
        }
        Object team = this.nms.newScoreboardTeam.newInstance(this.emptyScoreboard, packet.getName());
        String prefix = packet.getPlayerPrefix();
        String suffix = packet.getPlayerSuffix();
        if (clientVersion.getMinorVersion() < 13) {
            prefix = this.cutTo(prefix, 16);
            suffix = this.cutTo(suffix, 16);
        }
        ((Collection)this.nms.ScoreboardTeam_getPlayerNameSet.invoke(team, new Object[0])).addAll(packet.getPlayers());
        this.nms.ScoreboardTeam_setAllowFriendlyFire.invoke(team, (packet.getOptions() & 1) > 0);
        this.nms.ScoreboardTeam_setCanSeeFriendlyInvisibles.invoke(team, (packet.getOptions() & 2) > 0);
        if (this.nms.getMinorVersion() >= 13) {
            this.createTeamModern(packet, clientVersion, team, prefix, suffix);
        } else {
            this.createTeamLegacy(packet, team, prefix, suffix);
        }
        if (this.nms.getMinorVersion() >= 17) {
            switch (packet.getMethod()) {
                case 0: {
                    return this.nms.PacketPlayOutScoreboardTeam_ofBoolean.invoke(null, team, true);
                }
                case 1: {
                    return this.nms.PacketPlayOutScoreboardTeam_of.invoke(null, team);
                }
                case 2: {
                    return this.nms.PacketPlayOutScoreboardTeam_ofBoolean.invoke(null, team, false);
                }
                case 3: {
                    return this.nms.PacketPlayOutScoreboardTeam_ofString.invoke(null, team, packet.getPlayers().toArray(new String[0])[0], this.nms.PacketPlayOutScoreboardTeam_PlayerAction_values[0]);
                }
                case 4: {
                    return this.nms.PacketPlayOutScoreboardTeam_ofString.invoke(null, team, packet.getPlayers().toArray(new String[0])[0], this.nms.PacketPlayOutScoreboardTeam_PlayerAction_values[1]);
                }
            }
            throw new IllegalArgumentException("Invalid action: " + packet.getMethod());
        }
        return this.nms.newPacketPlayOutScoreboardTeam.newInstance(team, packet.getMethod());
    }

    public Object build(PacketPlayOutEntityDestroy packet) throws ReflectiveOperationException {
        try {
            return this.nms.newPacketPlayOutEntityDestroy.newInstance(new Object[]{packet.getEntities()});
        }
        catch (IllegalArgumentException e) {
            return this.nms.newPacketPlayOutEntityDestroy.newInstance(packet.getEntities()[0]);
        }
    }

    public Object build(PacketPlayOutEntityMetadata packet) throws ReflectiveOperationException {
        return this.nms.newPacketPlayOutEntityMetadata.newInstance(packet.getEntityId(), packet.getDataWatcher().toNMS(), true);
    }

    public Object build(PacketPlayOutSpawnEntityLiving packet) throws ReflectiveOperationException {
        Object nmsPacket = this.nms.getMinorVersion() >= 17 ? this.nms.newPacketPlayOutSpawnEntityLiving.newInstance(this.dummyEntity) : this.nms.newPacketPlayOutSpawnEntityLiving.newInstance(new Object[0]);
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_ENTITYID, packet.getEntityId());
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_ENTITYTYPE, this.entityIds.get(packet.getEntityType()));
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_YAW, (byte)(packet.getLocation().getYaw() * 256.0f / 360.0f));
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_PITCH, (byte)(packet.getLocation().getPitch() * 256.0f / 360.0f));
        if (this.nms.getMinorVersion() <= 14) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_DATAWATCHER, packet.getDataWatcher().toNMS());
        }
        if (this.nms.getMinorVersion() >= 9) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_UUID, packet.getUniqueId());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_X, packet.getLocation().getX());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_Y, packet.getLocation().getY());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_Z, packet.getLocation().getZ());
        } else {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_X, this.floor(packet.getLocation().getX() * 32.0));
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_Y, this.floor(packet.getLocation().getY() * 32.0));
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutSpawnEntityLiving_Z, this.floor(packet.getLocation().getZ() * 32.0));
        }
        return nmsPacket;
    }

    public Object build(PacketPlayOutEntityTeleport packet) throws ReflectiveOperationException {
        Object nmsPacket = this.nms.getMinorVersion() >= 17 ? this.nms.newPacketPlayOutEntityTeleport.newInstance(this.dummyEntity) : this.nms.newPacketPlayOutEntityTeleport.newInstance(new Object[0]);
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_ENTITYID, packet.getEntityId());
        if (this.nms.getMinorVersion() >= 9) {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_X, packet.getLocation().getX());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_Y, packet.getLocation().getY());
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_Z, packet.getLocation().getZ());
        } else {
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_X, this.floor(packet.getLocation().getX() * 32.0));
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_Y, this.floor(packet.getLocation().getY() * 32.0));
            this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_Z, this.floor(packet.getLocation().getZ() * 32.0));
        }
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_YAW, (byte)(packet.getLocation().getYaw() / 360.0f * 256.0f));
        this.nms.setField(nmsPacket, this.nms.PacketPlayOutEntityTeleport_PITCH, (byte)(packet.getLocation().getPitch() / 360.0f * 256.0f));
        return nmsPacket;
    }

    private void createTeamModern(PacketPlayOutScoreboardTeam packet, ProtocolVersion clientVersion, Object team, String prefix, String suffix) throws ReflectiveOperationException {
        if (prefix != null) {
            this.nms.ScoreboardTeam_setPrefix.invoke(team, this.toNMSComponent(IChatBaseComponent.optimizedComponent(prefix), clientVersion));
        }
        if (suffix != null) {
            this.nms.ScoreboardTeam_setSuffix.invoke(team, this.toNMSComponent(IChatBaseComponent.optimizedComponent(suffix), clientVersion));
        }
        EnumChatFormat format = packet.getColor() != null ? packet.getColor() : EnumChatFormat.lastColorsOf(prefix);
        this.nms.ScoreboardTeam_setColor.invoke(team, this.nms.EnumChatFormat_values[format.ordinal()]);
        this.nms.ScoreboardTeam_setNameTagVisibility.invoke(team, String.valueOf(packet.getNameTagVisibility()).equals("always") ? this.nms.EnumNameTagVisibility_values[0] : this.nms.EnumNameTagVisibility_values[1]);
        this.nms.ScoreboardTeam_setCollisionRule.invoke(team, String.valueOf(packet.getCollisionRule()).equals("always") ? this.nms.EnumTeamPush_values[0] : this.nms.EnumTeamPush_values[1]);
    }

    private void createTeamLegacy(PacketPlayOutScoreboardTeam packet, Object team, String prefix, String suffix) throws ReflectiveOperationException {
        if (prefix != null) {
            this.nms.ScoreboardTeam_setPrefix.invoke(team, prefix);
        }
        if (suffix != null) {
            this.nms.ScoreboardTeam_setSuffix.invoke(team, suffix);
        }
        if (this.nms.getMinorVersion() >= 8) {
            this.nms.ScoreboardTeam_setNameTagVisibility.invoke(team, String.valueOf(packet.getNameTagVisibility()).equals("always") ? this.nms.EnumNameTagVisibility_values[0] : this.nms.EnumNameTagVisibility_values[1]);
        }
        if (this.nms.getMinorVersion() >= 9) {
            this.nms.ScoreboardTeam_setCollisionRule.invoke(team, String.valueOf(packet.getCollisionRule()).equals("always") ? this.nms.EnumTeamPush_values[0] : this.nms.EnumTeamPush_values[1]);
        }
    }

    @Override
    public PacketPlayOutPlayerInfo readPlayerInfo(Object nmsPacket, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() < 8) {
            return null;
        }
        PacketPlayOutPlayerInfo.EnumPlayerInfoAction action = PacketPlayOutPlayerInfo.EnumPlayerInfoAction.valueOf(this.nms.PacketPlayOutPlayerInfo_ACTION.get(nmsPacket).toString());
        ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData> listData = new ArrayList<PacketPlayOutPlayerInfo.PlayerInfoData>();
        for (Object nmsData : (List)this.nms.PacketPlayOutPlayerInfo_PLAYERS.get(nmsPacket)) {
            Object nmsGameMode = this.nms.PlayerInfoData_getGamemode.invoke(nmsData, new Object[0]);
            PacketPlayOutPlayerInfo.EnumGamemode gameMode = nmsGameMode == null ? null : PacketPlayOutPlayerInfo.EnumGamemode.valueOf(nmsGameMode.toString());
            GameProfile profile = (GameProfile)this.nms.PlayerInfoData_getProfile.invoke(nmsData, new Object[0]);
            Object nmsComponent = this.nms.PlayerInfoData_getDisplayName.invoke(nmsData, new Object[0]);
            IChatBaseComponent listName = nmsComponent == null ? null : this.fromNMSComponent(nmsComponent);
            PropertyMap map = new PropertyMap();
            map.putAll((Multimap)profile.getProperties());
            listData.add(new PacketPlayOutPlayerInfo.PlayerInfoData(profile.getName(), profile.getId(), map, (Integer)this.nms.PlayerInfoData_getLatency.invoke(nmsData, new Object[0]), gameMode, listName));
        }
        return new PacketPlayOutPlayerInfo(action, listData);
    }

    @Override
    public PacketPlayOutScoreboardObjective readObjective(Object nmsPacket) throws ReflectiveOperationException {
        return new PacketPlayOutScoreboardObjective(this.nms.PacketPlayOutScoreboardObjective_METHOD.getInt(nmsPacket), (String)this.nms.PacketPlayOutScoreboardObjective_OBJECTIVENAME.get(nmsPacket), null, null);
    }

    @Override
    public PacketPlayOutScoreboardDisplayObjective readDisplayObjective(Object nmsPacket) throws ReflectiveOperationException {
        return new PacketPlayOutScoreboardDisplayObjective(this.nms.PacketPlayOutScoreboardDisplayObjective_POSITION.getInt(nmsPacket), (String)this.nms.PacketPlayOutScoreboardDisplayObjective_OBJECTIVENAME.get(nmsPacket));
    }

    private Object buildBossPacketEntity(PacketPlayOutBoss packet, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        if (packet.getOperation() == PacketPlayOutBoss.Action.UPDATE_STYLE) {
            return null;
        }
        int entityId = packet.getId().hashCode();
        if (packet.getOperation() == PacketPlayOutBoss.Action.REMOVE) {
            return this.build(new PacketPlayOutEntityDestroy(entityId));
        }
        DataWatcher w = new DataWatcher();
        if (packet.getOperation() == PacketPlayOutBoss.Action.UPDATE_PCT || packet.getOperation() == PacketPlayOutBoss.Action.ADD) {
            float health = 300.0f * packet.getPct();
            if (health == 0.0f) {
                health = 1.0f;
            }
            w.helper().setHealth(health);
        }
        if (packet.getOperation() == PacketPlayOutBoss.Action.UPDATE_NAME || packet.getOperation() == PacketPlayOutBoss.Action.ADD) {
            w.helper().setCustomName(packet.getName(), clientVersion);
        }
        if (packet.getOperation() == PacketPlayOutBoss.Action.ADD) {
            w.helper().setEntityFlags((byte)32);
            return this.build(new PacketPlayOutSpawnEntityLiving(entityId, null, EntityType.WITHER, new Location(null, 0.0, 0.0, 0.0), w));
        }
        return this.build(new PacketPlayOutEntityMetadata(entityId, w));
    }

    private int floor(double paramDouble) {
        int i = (int)paramDouble;
        return paramDouble < (double)i ? i - 1 : i;
    }

    private IChatBaseComponent fromNMSComponent(Object component) throws ReflectiveOperationException {
        if (!this.nms.ChatComponentText.isInstance(component)) {
            return null;
        }
        IChatBaseComponent chat = new IChatBaseComponent((String)this.nms.ChatComponentText_text.get(component));
        Object modifier = this.nms.ChatBaseComponent_modifier.get(component);
        if (modifier != null) {
            Object hoverEvent;
            chat.getModifier().setColor(this.fromNMSColor(this.nms.ChatModifier_color.get(modifier)));
            chat.getModifier().setBold((Boolean)this.nms.ChatModifier_bold.get(modifier));
            chat.getModifier().setItalic((Boolean)this.nms.ChatModifier_italic.get(modifier));
            chat.getModifier().setObfuscated((Boolean)this.nms.ChatModifier_obfuscated.get(modifier));
            chat.getModifier().setStrikethrough((Boolean)this.nms.ChatModifier_strikethrough.get(modifier));
            chat.getModifier().setUnderlined((Boolean)this.nms.ChatModifier_underlined.get(modifier));
            Object clickEvent = this.nms.ChatModifier_clickEvent.get(modifier);
            if (clickEvent != null) {
                chat.getModifier().onClick(ChatClickable.EnumClickAction.valueOf(this.nms.ChatClickable_action.get(clickEvent).toString().toUpperCase()), (String)this.nms.ChatClickable_value.get(clickEvent));
            }
            if ((hoverEvent = this.nms.ChatModifier_hoverEvent.get(modifier)) != null) {
                IChatBaseComponent value;
                ChatHoverable.EnumHoverAction action;
                if (this.nms.getMinorVersion() >= 16) {
                    JsonObject json = (JsonObject)this.nms.ChatHoverable_serialize.invoke(hoverEvent, new Object[0]);
                    action = ChatHoverable.EnumHoverAction.valueOf(json.get("action").getAsString().toUpperCase());
                    value = IChatBaseComponent.deserialize(json.get("contents").getAsJsonObject().toString());
                } else {
                    action = ChatHoverable.EnumHoverAction.valueOf(this.nms.ChatHoverable_getAction.invoke(hoverEvent, new Object[0]).toString().toUpperCase());
                    value = this.fromNMSComponent(this.nms.ChatHoverable_getValue.invoke(hoverEvent, new Object[0]));
                }
                chat.getModifier().onHover(action, value);
            }
        }
        for (Object extra : (List)this.nms.ChatBaseComponent_extra.get(component)) {
            chat.addExtra(this.fromNMSComponent(extra));
        }
        return chat;
    }

    private TextColor fromNMSColor(Object color) throws ReflectiveOperationException {
        if (color == null) {
            return null;
        }
        if (this.nms.getMinorVersion() >= 16) {
            String name = (String)this.nms.ChatHexColor_name.get(color);
            if (name != null) {
                return new TextColor(EnumChatFormat.valueOf(name.toUpperCase(Locale.US)));
            }
            int rgb = (Integer)this.nms.ChatHexColor_rgb.get(color);
            return new TextColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
        return new TextColor(EnumChatFormat.valueOf(((Enum)color).name()));
    }

    public Object toNMSComponent(IChatBaseComponent component, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        Object obj;
        if (clientVersion.getMinorVersion() >= 16) {
            if (this.componentCacheModern.containsKey(component)) {
                return this.componentCacheModern.get(component);
            }
            obj = this.toNMSComponent0(component, clientVersion);
            if (this.componentCacheModern.size() > 10000) {
                this.componentCacheModern.clear();
            }
            this.componentCacheModern.put(component, obj);
        } else {
            if (this.componentCacheLegacy.containsKey(component)) {
                return this.componentCacheLegacy.get(component);
            }
            obj = this.toNMSComponent0(component, clientVersion);
            if (this.componentCacheLegacy.size() > 10000) {
                this.componentCacheLegacy.clear();
            }
            this.componentCacheLegacy.put(component, obj);
        }
        return obj;
    }

    private Object toNMSComponent0(IChatBaseComponent component, ProtocolVersion clientVersion) throws ReflectiveOperationException {
        Object modifier;
        Object clickEvent;
        if (component == null) {
            return null;
        }
        Object chat = this.nms.newChatComponentText.newInstance(component.getText());
        Object v0 = clickEvent = component.getModifier().getClickEvent() == null ? null : this.nms.newChatClickable.newInstance(Enum.valueOf(this.nms.EnumClickAction, component.getModifier().getClickEvent().getAction().toString().toUpperCase()), component.getModifier().getClickEvent().getValue());
        if (this.nms.getMinorVersion() >= 16) {
            Object color = null;
            if (component.getModifier().getColor() != null) {
                color = clientVersion.getMinorVersion() >= 16 ? this.nms.ChatHexColor_ofInt.invoke(null, (component.getModifier().getColor().getRed() << 16) + (component.getModifier().getColor().getGreen() << 8) + component.getModifier().getColor().getBlue()) : this.nms.ChatHexColor_ofString.invoke(null, component.getModifier().getColor().getLegacyColor().toString().toLowerCase());
            }
            Object hoverEvent = null;
            if (component.getModifier().getHoverEvent() != null) {
                Object nmsAction = this.nms.EnumHoverAction_a.invoke(null, component.getModifier().getHoverEvent().getAction().toString().toLowerCase());
                switch (component.getModifier().getHoverEvent().getAction()) {
                    case SHOW_TEXT: {
                        hoverEvent = this.nms.newChatHoverable.newInstance(nmsAction, this.toNMSComponent0(component.getModifier().getHoverEvent().getValue(), clientVersion));
                        break;
                    }
                    case SHOW_ENTITY: {
                        hoverEvent = this.nms.EnumHoverAction_fromJson.invoke(nmsAction, ((ChatComponentEntity)component.getModifier().getHoverEvent().getValue()).toJson());
                        break;
                    }
                    case SHOW_ITEM: {
                        hoverEvent = this.nms.EnumHoverAction_fromLegacyComponent.invoke(nmsAction, this.toNMSComponent0(component.getModifier().getHoverEvent().getValue(), clientVersion));
                        break;
                    }
                }
            }
            modifier = this.nms.newChatModifier.newInstance(color, component.getModifier().getBold(), component.getModifier().getItalic(), component.getModifier().getUnderlined(), component.getModifier().getStrikethrough(), component.getModifier().getObfuscated(), clickEvent, hoverEvent, null, null);
        } else {
            modifier = this.nms.newChatModifier.newInstance(new Object[0]);
            if (component.getModifier().getColor() != null) {
                this.nms.setField(modifier, this.nms.ChatModifier_color, Enum.valueOf(this.nms.EnumChatFormat, component.getModifier().getColor().getLegacyColor().toString()));
            }
            this.nms.setField(modifier, this.nms.ChatModifier_bold, component.getModifier().getBold());
            this.nms.setField(modifier, this.nms.ChatModifier_italic, component.getModifier().getItalic());
            this.nms.setField(modifier, this.nms.ChatModifier_underlined, component.getModifier().getUnderlined());
            this.nms.setField(modifier, this.nms.ChatModifier_strikethrough, component.getModifier().getStrikethrough());
            this.nms.setField(modifier, this.nms.ChatModifier_obfuscated, component.getModifier().getObfuscated());
            if (clickEvent != null) {
                this.nms.setField(modifier, this.nms.ChatModifier_clickEvent, clickEvent);
            }
            if (component.getModifier().getHoverEvent() != null) {
                this.nms.setField(modifier, this.nms.ChatModifier_hoverEvent, this.nms.newChatHoverable.newInstance(this.nms.EnumHoverAction_a.invoke(null, component.getModifier().getHoverEvent().getAction().toString().toLowerCase()), this.toNMSComponent0(component.getModifier().getHoverEvent().getValue(), clientVersion)));
            }
        }
        this.nms.setField(chat, this.nms.ChatBaseComponent_modifier, modifier);
        for (IChatBaseComponent extra : component.getExtra()) {
            this.nms.ChatComponentText_addSibling.invoke(chat, this.toNMSComponent0(extra, clientVersion));
        }
        return chat;
    }

    private Object newScoreboardObjective(String objectiveName) throws ReflectiveOperationException {
        if (this.nms.getMinorVersion() >= 13) {
            return this.nms.newScoreboardObjective.newInstance(null, objectiveName, null, this.nms.newChatComponentText.newInstance(""), null);
        }
        return this.nms.newScoreboardObjective.newInstance(null, objectiveName, this.nms.IScoreboardCriteria_self.get(null));
    }
}

