/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import com.earth2me.essentials.Essentials;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.PlaceholderManager;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.PlaceholderRegistry;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class BukkitPlaceholderRegistry
implements PlaceholderRegistry {
    public final DecimalFormat decimal2 = (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
    private final Plugin plugin;
    private Object chat;
    private final Plugin essentials = Bukkit.getPluginManager().getPlugin("Essentials");
    private Object server;
    private Field recentTps;
    private boolean paperTps;
    private boolean paperMspt;
    private boolean purpur;
    private Method playerIsAfk;
    private Listener healthListener = null;

    public BukkitPlaceholderRegistry(Plugin plugin) {
        this.plugin = plugin;
        this.decimal2.applyPattern("#.##");
        try {
            RegisteredServiceProvider rspChat;
            if (Bukkit.getPluginManager().isPluginEnabled("Vault") && (rspChat = Bukkit.getServicesManager().getRegistration(Class.forName("net.milkbowl.vault.chat.Chat"))) != null) {
                this.chat = rspChat.getProvider();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            this.server = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            this.recentTps = this.server.getClass().getField("recentTps");
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        try {
            Bukkit.class.getMethod("getTPS", new Class[0]);
            this.paperTps = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            Bukkit.class.getMethod("getAverageTickTime", new Class[0]);
            this.paperMspt = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.playerIsAfk = Player.class.getMethod("isAfk", new Class[0]);
            this.purpur = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public void registerPlaceholders(PlaceholderManager manager) {
        NumberFormat roundDown = NumberFormat.getNumberInstance(Locale.ENGLISH);
        roundDown.setRoundingMode(RoundingMode.DOWN);
        roundDown.setMaximumFractionDigits(2);
        manager.registerPlayerPlaceholder("%displayname%", 500, p -> ((Player)p.getPlayer()).getDisplayName());
        if (this.paperTps) {
            manager.registerServerPlaceholder("%tps%", 1000, () -> this.formatTPS(Bukkit.getTPS()[0]));
        } else if (this.recentTps != null) {
            manager.registerServerPlaceholder("%tps%", 1000, () -> {
                try {
                    return this.formatTPS(((double[])this.recentTps.get(this.server))[0]);
                }
                catch (IllegalAccessException e) {
                    return "-1";
                }
            });
        } else {
            manager.registerServerPlaceholder("%tps%", -1, () -> "-1").enableTriggerMode();
        }
        if (this.paperMspt) {
            manager.registerServerPlaceholder("%mspt%", 1000, () -> roundDown.format(Bukkit.getAverageTickTime()));
        }
        manager.registerPlayerPlaceholder("%afk%", 500, p -> {
            if (this.essentials != null && ((Essentials)this.essentials).getUser(p.getUniqueId()).isAfk()) {
                return true;
            }
            if (!this.purpur || this.playerIsAfk == null) {
                return false;
            }
            try {
                return this.playerIsAfk.invoke(p.getPlayer(), new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                TAB.getInstance().getErrorManager().printError("Failed to invoke isAfk!", exception);
                return false;
            }
        });
        manager.registerPlayerPlaceholder("%essentialsnick%", 1000, p -> {
            String nickname = null;
            if (this.essentials != null) {
                nickname = ((Essentials)this.essentials).getUser(p.getUniqueId()).getNickname();
            }
            return nickname == null || nickname.length() == 0 ? p.getName() : nickname;
        });
        if (this.chat != null) {
            manager.registerPlayerPlaceholder("%vault-prefix%", 500, p -> ((Chat)this.chat).getPlayerPrefix((Player)p.getPlayer()));
            manager.registerPlayerPlaceholder("%vault-suffix%", 500, p -> ((Chat)this.chat).getPlayerSuffix((Player)p.getPlayer()));
        } else {
            manager.registerServerPlaceholder("%vault-prefix%", -1, () -> "").enableTriggerMode();
            manager.registerServerPlaceholder("%vault-suffix%", -1, () -> "").enableTriggerMode();
        }
        this.registerOnlinePlaceholders(manager);
        this.registerHealthPlaceholder(manager);
    }

    private String formatTPS(double tps) {
        return this.decimal2.format(Math.min(20.0, tps));
    }

    private void registerOnlinePlaceholders(PlaceholderManager manager) {
        manager.registerPlayerPlaceholder("%online%", 1000, p -> {
            int count = 0;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!((Player)p.getPlayer()).canSee((Player)all.getPlayer())) continue;
                ++count;
            }
            return count;
        });
        manager.registerPlayerPlaceholder("%staffonline%", 2000, p -> {
            int count = 0;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!all.hasPermission("tab.staff") || !((Player)p.getPlayer()).canSee((Player)all.getPlayer())) continue;
                ++count;
            }
            return count;
        });
        manager.registerPlayerPlaceholder("%nonstaffonline%", 2000, p -> {
            int count = 0;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all.hasPermission("tab.staff") || !((Player)p.getPlayer()).canSee((Player)all.getPlayer())) continue;
                ++count;
            }
            return count;
        });
    }

    private void registerHealthPlaceholder(PlaceholderManager manager) {
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 6) {
            final PlayerPlaceholder health = manager.registerPlayerPlaceholder("%health%", -1, p -> (int)Math.ceil(((Player)p.getPlayer()).getHealth()));
            health.enableTriggerMode(() -> {
                this.healthListener = new Listener(){

                    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
                    public void onDamage(EntityDamageEvent e) {
                        if (e.getEntity() instanceof Player) {
                            Player p = (Player)e.getEntity();
                            TabPlayer tabp = TAB.getInstance().getPlayer(e.getEntity().getUniqueId());
                            if (tabp == null) {
                                return;
                            }
                            health.updateValue(tabp, (int)Math.ceil(Math.max(p.getHealth() - e.getFinalDamage(), 0.0)));
                        }
                    }

                    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
                    public void onRegain(EntityRegainHealthEvent e) {
                        if (e.getEntity() instanceof Player) {
                            Player p = (Player)e.getEntity();
                            TabPlayer tabp = TAB.getInstance().getPlayer(e.getEntity().getUniqueId());
                            if (tabp == null) {
                                return;
                            }
                            health.updateValue(tabp, (int)Math.ceil(Math.min(p.getHealth() + e.getAmount(), p.getMaxHealth())));
                        }
                    }

                    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
                    public void onRespawn(PlayerRespawnEvent e) {
                        health.updateValue(TAB.getInstance().getPlayer(e.getPlayer().getUniqueId()), (int)e.getPlayer().getMaxHealth());
                    }
                };
                Bukkit.getPluginManager().registerEvents(this.healthListener, this.plugin);
            }, () -> HandlerList.unregisterAll((Listener)this.healthListener));
        }
    }
}

