/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import com.earth2me.essentials.Essentials;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.io.File;
import java.util.Collection;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.protocol.PacketBuilder;
import me.neznamy.tab.platforms.bukkit.BukkitPacketBuilder;
import me.neznamy.tab.platforms.bukkit.BukkitPipelineInjector;
import me.neznamy.tab.platforms.bukkit.BukkitPlaceholderRegistry;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.Main;
import me.neznamy.tab.platforms.bukkit.event.TabLoadEvent;
import me.neznamy.tab.platforms.bukkit.event.TabPlayerLoadEvent;
import me.neznamy.tab.platforms.bukkit.features.PerWorldPlayerList;
import me.neznamy.tab.platforms.bukkit.features.PetFix;
import me.neznamy.tab.platforms.bukkit.features.TabExpansion;
import me.neznamy.tab.platforms.bukkit.features.WitherBossBar;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.NameTagX;
import me.neznamy.tab.platforms.bukkit.permission.Vault;
import me.neznamy.tab.shared.Platform;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.permission.LuckPerms;
import me.neznamy.tab.shared.permission.None;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import me.neznamy.tab.shared.permission.UltraPermissions;
import me.neznamy.tab.shared.placeholders.PlayerPlaceholderImpl;
import me.neznamy.tab.shared.placeholders.UniversalPlaceholderRegistry;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class BukkitPlatform
implements Platform {
    private final Main plugin;
    private final BukkitPacketBuilder packetBuilder = new BukkitPacketBuilder();
    private boolean placeholderAPI;
    private boolean libsDisguises;
    private Plugin essentials;

    public BukkitPlatform(Main plugin) {
        this.plugin = plugin;
    }

    @Override
    public PermissionPlugin detectPermissionPlugin() {
        if (Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
            return new LuckPerms(this.getPluginVersion("LuckPerms"));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("UltraPermissions")) {
            return new UltraPermissions(this.getPluginVersion("UltraPermissions"));
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            RegisteredServiceProvider provider = Bukkit.getServicesManager().getRegistration(Permission.class);
            if (provider == null) {
                return new None();
            }
            return new Vault((Permission)provider.getProvider(), this.getPluginVersion("Vault"));
        }
        return new None();
    }

    @Override
    public void loadFeatures() {
        if (Bukkit.getPluginManager().isPluginEnabled("ViaVersion")) {
            try {
                Class.forName("com.viaversion.viaversion.api.Via");
            }
            catch (ClassNotFoundException e) {
                TAB.getInstance().sendConsoleMessage("&c[TAB] An outdated version of ViaVersion (" + this.getPluginVersion("ViaVersion") + ") was detected.", true);
                TAB.getInstance().sendConsoleMessage("&c[TAB] TAB only supports ViaVersion 4.0.0 and above. Disabling ViaVersion hook.", true);
                TAB.getInstance().sendConsoleMessage("&c[TAB] This might cause problems, such as limitations still being present for latest MC clients as well as RGB not working.", true);
            }
        }
        if (Bukkit.getPluginManager().isPluginEnabled("Tablisknu")) {
            TAB.getInstance().sendConsoleMessage("&c[TAB] Detected plugin \"Tablisknu\", which causes TAB to not work properly. Consider removing the plugin.", true);
        }
        this.placeholderAPI = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.libsDisguises = Bukkit.getPluginManager().isPluginEnabled("LibsDisguises");
        this.essentials = Bukkit.getPluginManager().getPlugin("Essentials");
        TAB tab = TAB.getInstance();
        if (tab.getConfiguration().isPipelineInjection()) {
            tab.getFeatureManager().registerFeature("injection", new BukkitPipelineInjector());
        }
        new BukkitPlaceholderRegistry((Plugin)this.plugin).registerPlaceholders(tab.getPlaceholderManager());
        new UniversalPlaceholderRegistry().registerPlaceholders(tab.getPlaceholderManager());
        this.loadNameTagFeature(tab);
        tab.loadUniversalFeatures();
        if (tab.getConfiguration().getConfig().getBoolean("bossbar.enabled", false)) {
            if (tab.getServerVersion().getMinorVersion() < 9) {
                tab.getFeatureManager().registerFeature("BossBar", new WitherBossBar(this.plugin));
            } else {
                tab.getFeatureManager().registerFeature("BossBar", new BossBarManagerImpl());
            }
        }
        if (tab.getServerVersion().getMinorVersion() >= 9 && tab.getConfiguration().getConfig().getBoolean("fix-pet-names.enabled", false)) {
            tab.getFeatureManager().registerFeature("PetFix", new PetFix());
        }
        if (tab.getConfiguration().getConfig().getBoolean("per-world-playerlist.enabled", false)) {
            tab.getFeatureManager().registerFeature("PerWorldPlayerList", new PerWorldPlayerList(this.plugin));
        }
        if (this.placeholderAPI) {
            new TabExpansion(this.plugin);
        }
        for (Player p : this.getOnlinePlayers()) {
            tab.addPlayer(new BukkitTabPlayer(p, this.plugin.getProtocolVersion(p)));
        }
    }

    private String getPluginVersion(String plugin) {
        Plugin pl = Bukkit.getPluginManager().getPlugin(plugin);
        return pl == null ? "" : pl.getDescription().getVersion();
    }

    private void loadNameTagFeature(TAB tab) {
        if (tab.getConfiguration().getConfig().getBoolean("scoreboard-teams.enabled", true)) {
            if (tab.getConfiguration().getConfig().getBoolean("scoreboard-teams.unlimited-nametag-mode.enabled", false) && tab.getServerVersion().getMinorVersion() >= 8) {
                tab.getFeatureManager().registerFeature("NameTagX", new NameTagX(this.plugin));
            } else {
                tab.getFeatureManager().registerFeature("NameTag16", new NameTag());
            }
        }
    }

    private Player[] getOnlinePlayers() {
        try {
            Object players = Bukkit.class.getMethod("getOnlinePlayers", new Class[0]).invoke(null, new Object[0]);
            if (players instanceof Player[]) {
                return (Player[])players;
            }
            return ((Collection)players).toArray(new Player[0]);
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get online players", e);
            return new Player[0];
        }
    }

    @Override
    public void sendConsoleMessage(String message, boolean translateColors) {
        Bukkit.getConsoleSender().sendMessage(translateColors ? EnumChatFormat.color(message) : message);
    }

    @Override
    public void registerUnknownPlaceholder(String identifier) {
        PlaceholderManagerImpl pl = TAB.getInstance().getPlaceholderManager();
        if (identifier.startsWith("%rel_")) {
            TAB.getInstance().getPlaceholderManager().registerRelationalPlaceholder(identifier, pl.getRelationalRefresh(identifier), (viewer, target) -> this.placeholderAPI ? PlaceholderAPI.setRelationalPlaceholders((Player)((Player)viewer.getPlayer()), (Player)((Player)target.getPlayer()), (String)identifier) : identifier);
        } else {
            if (identifier.startsWith("%sync:")) {
                int refresh = pl.getServerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getPlayerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getDefaultRefresh()));
                pl.registerPlaceholder(new PlayerPlaceholderImpl(identifier, refresh, null){

                    @Override
                    public Object request(TabPlayer p) {
                        Bukkit.getScheduler().runTask((Plugin)BukkitPlatform.this.plugin, () -> {
                            long time = System.nanoTime();
                            String syncedPlaceholder = this.identifier.substring(6, this.identifier.length() - 1);
                            String value = BukkitPlatform.this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)p.getPlayer()), (String)("%" + syncedPlaceholder + "%")) : this.identifier;
                            this.getLastValues().put(p, value);
                            this.getForceUpdate().add(p);
                            TAB.getInstance().getCPUManager().addPlaceholderTime(this.getIdentifier(), System.nanoTime() - time);
                        });
                        String value = this.getLastValues().get(p);
                        return value == null ? this.identifier : value;
                    }
                });
                return;
            }
            if (pl.getServerPlaceholderRefreshIntervals().containsKey(identifier)) {
                TAB.getInstance().getPlaceholderManager().registerServerPlaceholder(identifier, pl.getServerPlaceholderRefreshIntervals().get(identifier), () -> this.placeholderAPI ? PlaceholderAPI.setPlaceholders(null, (String)identifier) : identifier);
            } else {
                int refresh = pl.getPlayerPlaceholderRefreshIntervals().getOrDefault(identifier, pl.getDefaultRefresh());
                TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder(identifier, refresh, p -> this.placeholderAPI ? PlaceholderAPI.setPlaceholders((Player)((Player)p.getPlayer()), (String)identifier) : identifier);
            }
        }
    }

    @Override
    public String getServerVersion() {
        return Bukkit.getBukkitVersion().split("-")[0] + " (" + Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3] + ")";
    }

    @Override
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public void callLoadEvent() {
        Bukkit.getPluginManager().callEvent((Event)new TabLoadEvent());
    }

    @Override
    public void callLoadEvent(TabPlayer player) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> Bukkit.getPluginManager().callEvent((Event)new TabPlayerLoadEvent(player)));
    }

    @Override
    public int getMaxPlayers() {
        return Bukkit.getMaxPlayers();
    }

    public boolean isLibsDisguisesEnabled() {
        return this.libsDisguises;
    }

    public void setLibsDisguisesEnabled(boolean enabled) {
        this.libsDisguises = enabled;
    }

    public Essentials getEssentials() {
        return (Essentials)this.essentials;
    }

    @Override
    public PacketBuilder getPacketBuilder() {
        return this.packetBuilder;
    }

    @Override
    public Object getSkin(List<String> properties) {
        PropertyMap map = new PropertyMap();
        map.put((Object)"textures", (Object)new Property("textures", properties.get(0), properties.get(1)));
        return map;
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public boolean isPluginEnabled(String plugin) {
        return Bukkit.getPluginManager().isPluginEnabled(plugin);
    }

    @Override
    public String getConfigName() {
        return "bukkitconfig.yml";
    }
}

