/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit;

import com.earth2me.essentials.Essentials;
import com.mojang.authlib.GameProfile;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.legacy.bossbar.BossColor;
import com.viaversion.viaversion.api.legacy.bossbar.BossFlag;
import com.viaversion.viaversion.api.legacy.bossbar.BossStyle;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.libraryaddict.disguise.DisguiseAPI;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.chat.rgb.RGBUtils;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.platforms.bukkit.BukkitPlatform;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.potion.PotionEffectType;

public class BukkitTabPlayer
extends ITabPlayer {
    private Object handle;
    private Object playerConnection;
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    private final Map<UUID, com.viaversion.viaversion.api.legacy.bossbar.BossBar> viaBossBars = new HashMap<UUID, com.viaversion.viaversion.api.legacy.bossbar.BossBar>();

    public BukkitTabPlayer(Player p, int protocolVersion) {
        super(p, p.getUniqueId(), p.getName(), "N/A", p.getWorld().getName());
        try {
            this.handle = NMSStorage.getInstance().getHandle.invoke(this.player, new Object[0]);
            this.playerConnection = NMSStorage.getInstance().PLAYER_CONNECTION.get(this.handle);
            if (NMSStorage.getInstance().CHANNEL != null) {
                this.channel = (Channel)NMSStorage.getInstance().CHANNEL.get(NMSStorage.getInstance().NETWORK_MANAGER.get(this.playerConnection));
            }
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get playerConnection or channel of " + p.getName(), e);
        }
        this.version = ProtocolVersion.fromNetworkId(protocolVersion);
    }

    @Override
    public boolean hasPermission(String permission) {
        long time = System.nanoTime();
        boolean value = this.getPlayer().hasPermission(permission);
        TAB.getInstance().getCPUManager().addMethodTime("hasPermission", System.nanoTime() - time);
        return value;
    }

    @Override
    public int getPing() {
        try {
            int ping = NMSStorage.getInstance().PING.getInt(this.handle);
            if (ping > 10000 || ping < 0) {
                ping = -1;
            }
            return ping;
        }
        catch (IllegalAccessException e) {
            return -1;
        }
    }

    @Override
    public void sendPacket(Object nmsPacket) {
        if (nmsPacket == null || !this.getPlayer().isOnline()) {
            return;
        }
        long time = System.nanoTime();
        try {
            if (nmsPacket instanceof PacketPlayOutBoss) {
                if (TAB.getInstance().getServerVersion().getMinorVersion() >= 9) {
                    this.handle((PacketPlayOutBoss)nmsPacket);
                } else {
                    this.handleVia((PacketPlayOutBoss)nmsPacket);
                }
            } else {
                NMSStorage.getInstance().sendPacket.invoke(this.playerConnection, nmsPacket);
            }
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("An error occurred when sending " + nmsPacket.getClass().getSimpleName(), e);
        }
        TAB.getInstance().getCPUManager().addMethodTime("sendPacket", System.nanoTime() - time);
    }

    private void handle(PacketPlayOutBoss packet) {
        BossBar bar = this.bossBars.get(packet.getId());
        if (packet.getOperation() == PacketPlayOutBoss.Action.ADD) {
            if (this.bossBars.containsKey(packet.getId())) {
                return;
            }
            bar = Bukkit.createBossBar((String)RGBUtils.getInstance().convertToBukkitFormat(packet.getName(), this.getVersion().getMinorVersion() >= 16 && TAB.getInstance().getServerVersion().getMinorVersion() >= 16), (BarColor)BarColor.valueOf((String)packet.getColor().name()), (BarStyle)BarStyle.valueOf((String)packet.getOverlay().getBukkitName()), (BarFlag[])new BarFlag[0]);
            if (packet.isCreateWorldFog()) {
                bar.addFlag(BarFlag.CREATE_FOG);
            }
            if (packet.isDarkenScreen()) {
                bar.addFlag(BarFlag.DARKEN_SKY);
            }
            if (packet.isPlayMusic()) {
                bar.addFlag(BarFlag.PLAY_BOSS_MUSIC);
            }
            bar.setProgress((double)packet.getPct());
            this.bossBars.put(packet.getId(), bar);
            bar.addPlayer(this.getPlayer());
            return;
        }
        if (bar == null) {
            return;
        }
        switch (packet.getOperation()) {
            case REMOVE: {
                bar.removePlayer(this.getPlayer());
                this.bossBars.remove(packet.getId());
                break;
            }
            case UPDATE_PCT: {
                bar.setProgress((double)packet.getPct());
                break;
            }
            case UPDATE_NAME: {
                bar.setTitle(RGBUtils.getInstance().convertToBukkitFormat(packet.getName(), this.getVersion().getMinorVersion() >= 16 && TAB.getInstance().getServerVersion().getMinorVersion() >= 16));
                break;
            }
            case UPDATE_STYLE: {
                bar.setColor(BarColor.valueOf((String)packet.getColor().name()));
                bar.setStyle(BarStyle.valueOf((String)packet.getOverlay().getBukkitName()));
                break;
            }
            case UPDATE_PROPERTIES: {
                bar = this.bossBars.get(packet.getId());
                this.processFlag(bar, packet.isCreateWorldFog(), BarFlag.CREATE_FOG);
                this.processFlag(bar, packet.isDarkenScreen(), BarFlag.DARKEN_SKY);
                this.processFlag(bar, packet.isPlayMusic(), BarFlag.PLAY_BOSS_MUSIC);
                break;
            }
        }
    }

    private void handleVia(PacketPlayOutBoss packet) {
        switch (packet.getOperation()) {
            case ADD: {
                if (this.viaBossBars.containsKey(packet.getId())) {
                    return;
                }
                com.viaversion.viaversion.api.legacy.bossbar.BossBar bar = Via.getAPI().legacyAPI().createLegacyBossBar(RGBUtils.getInstance().convertToBukkitFormat(packet.getName(), this.getVersion().getMinorVersion() >= 16), packet.getPct(), BossColor.valueOf((String)packet.getColor().name()), BossStyle.valueOf((String)packet.getOverlay().getBukkitName()));
                if (packet.isDarkenScreen()) {
                    bar.addFlag(BossFlag.DARKEN_SKY);
                }
                if (packet.isPlayMusic()) {
                    bar.addFlag(BossFlag.PLAY_BOSS_MUSIC);
                }
                this.viaBossBars.put(packet.getId(), bar);
                bar.addPlayer(this.getPlayer().getUniqueId());
                break;
            }
            case REMOVE: {
                this.viaBossBars.get(packet.getId()).removePlayer(this.getPlayer().getUniqueId());
                this.viaBossBars.remove(packet.getId());
                break;
            }
            case UPDATE_PCT: {
                this.viaBossBars.get(packet.getId()).setHealth(packet.getPct());
                break;
            }
            case UPDATE_NAME: {
                this.viaBossBars.get(packet.getId()).setTitle(RGBUtils.getInstance().convertToBukkitFormat(packet.getName(), this.getVersion().getMinorVersion() >= 16));
                break;
            }
            case UPDATE_STYLE: {
                this.viaBossBars.get(packet.getId()).setColor(BossColor.valueOf((String)packet.getColor().name()));
                this.viaBossBars.get(packet.getId()).setStyle(BossStyle.valueOf((String)packet.getOverlay().getBukkitName()));
                break;
            }
            case UPDATE_PROPERTIES: {
                com.viaversion.viaversion.api.legacy.bossbar.BossBar bar = this.viaBossBars.get(packet.getId());
                this.processFlagVia(bar, packet.isDarkenScreen(), BossFlag.DARKEN_SKY);
                this.processFlagVia(bar, packet.isPlayMusic(), BossFlag.PLAY_BOSS_MUSIC);
                break;
            }
        }
    }

    private void processFlag(BossBar bar, boolean targetValue, BarFlag flag) {
        if (targetValue) {
            if (!bar.hasFlag(flag)) {
                bar.addFlag(flag);
            }
        } else if (bar.hasFlag(flag)) {
            bar.removeFlag(flag);
        }
    }

    private void processFlagVia(com.viaversion.viaversion.api.legacy.bossbar.BossBar bar, boolean targetValue, BossFlag flag) {
        if (targetValue) {
            if (!bar.hasFlag(flag)) {
                bar.addFlag(flag);
            }
        } else if (bar.hasFlag(flag)) {
            bar.removeFlag(flag);
        }
    }

    @Override
    public boolean hasInvisibilityPotion() {
        return this.getPlayer().hasPotionEffect(PotionEffectType.INVISIBILITY);
    }

    @Override
    public boolean isDisguised() {
        try {
            if (!((BukkitPlatform)TAB.getInstance().getPlatform()).isLibsDisguisesEnabled()) {
                return false;
            }
            return DisguiseAPI.isDisguised((Entity)this.getPlayer());
        }
        catch (LinkageError e) {
            TAB.getInstance().getErrorManager().printError("Failed to check disguise status using LibsDisguises", e);
            ((BukkitPlatform)TAB.getInstance().getPlatform()).setLibsDisguisesEnabled(false);
            return false;
        }
    }

    @Override
    public Object getSkin() {
        try {
            return ((GameProfile)NMSStorage.getInstance().getProfile.invoke(this.handle, new Object[0])).getProperties();
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get skin of " + this.getName(), e);
            return null;
        }
    }

    public Player getPlayer() {
        return (Player)this.player;
    }

    @Override
    public boolean isOnline() {
        return this.getPlayer().isOnline();
    }

    @Override
    public boolean isVanished() {
        Essentials essentials = ((BukkitPlatform)TAB.getInstance().getPlatform()).getEssentials();
        if (essentials != null && essentials.getUser(this.getUniqueId()).isVanished()) {
            return true;
        }
        List metadata = this.getPlayer().getMetadata("vanished");
        return !metadata.isEmpty() && ((MetadataValue)metadata.get(0)).asBoolean();
    }

    @Override
    public int getGamemode() {
        return this.getPlayer().getGameMode().getValue();
    }
}

