/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features;

import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.bossbar.BossBarManager;
import me.neznamy.tab.api.scoreboard.Scoreboard;
import me.neznamy.tab.api.scoreboard.ScoreboardManager;
import me.neznamy.tab.shared.TAB;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class TabExpansion
extends PlaceholderExpansion {
    private final JavaPlugin plugin;

    public TabExpansion(JavaPlugin plugin) {
        this.plugin = plugin;
        this.register();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getIdentifier() {
        return "tab";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        TabPlayer p = TAB.getInstance().getPlayer(player.getUniqueId());
        if ("scoreboard_visible".equals(identifier)) {
            return this.translate(this.hasScoreboardVisible(p));
        }
        if ("scoreboard_name".equals(identifier)) {
            return this.getActiveScoreboard(p);
        }
        if ("bossbar_visible".equals(identifier)) {
            return this.translate(this.hasBossBarVisible(p));
        }
        if ("ntpreview".equals(identifier)) {
            return this.translate(p.isPreviewingNametag());
        }
        if (identifier.startsWith("replace_")) {
            return this.findReplacement("%" + identifier.substring(8) + "%", player);
        }
        if (identifier.startsWith("placeholder_")) {
            return TAB.getInstance().getPlaceholderManager().getPlaceholder("%" + identifier.substring(12) + "%").getLastValue(p);
        }
        return this.getProperty(identifier, p);
    }

    private boolean hasBossBarVisible(TabPlayer p) {
        BossBarManager boss = (BossBarManager)((Object)TAB.getInstance().getFeatureManager().getFeature("BossBar"));
        if (boss == null) {
            return false;
        }
        return boss.hasBossBarVisible(p);
    }

    private boolean hasScoreboardVisible(TabPlayer p) {
        ScoreboardManager scoreboard = (ScoreboardManager)((Object)TAB.getInstance().getFeatureManager().getFeature("ScoreBoard"));
        if (scoreboard == null) {
            return false;
        }
        return scoreboard.hasScoreboardVisible(p);
    }

    private String getActiveScoreboard(TabPlayer p) {
        ScoreboardManager sb = TabAPI.getInstance().getScoreboardManager();
        if (sb == null) {
            return "";
        }
        Scoreboard active = sb.getActiveScoreboard(p);
        if (active == null) {
            return "";
        }
        return active.getName();
    }

    private String translate(boolean b) {
        return b ? "Enabled" : "Disabled";
    }

    private String findReplacement(String placeholder, Player player) {
        String output = PlaceholderAPI.setPlaceholders((Player)player, (String)placeholder);
        return TAB.getInstance().getPlaceholderManager().findReplacement(placeholder, output).replace("%value%", output);
    }

    private String getProperty(String name, TabPlayer player) {
        String propName = name.replace("_raw", "");
        Property prop = player.getProperty(propName);
        if (prop != null) {
            if (name.endsWith("_raw")) {
                return prop.getCurrentRawValue();
            }
            return prop.get();
        }
        return null;
    }
}

