/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import java.util.UUID;
import me.neznamy.tab.api.ArmorStand;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.NameTagX;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityDestroy;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityMetadata;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutEntityTeleport;
import me.neznamy.tab.platforms.bukkit.nms.PacketPlayOutSpawnEntityLiving;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcher;
import me.neznamy.tab.shared.TAB;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Pose;

public class BukkitArmorStand
implements ArmorStand {
    private final boolean alwaysVisible = TAB.getInstance().getConfiguration().isArmorStandsAlwaysVisible();
    private static int idCounter = 2000000000;
    private final NameTagX manager = (NameTagX)TAB.getInstance().getFeatureManager().getFeature("NameTagX");
    private final TabPlayer owner;
    private final Player player;
    private double yOffset;
    private final int entityId = idCounter++;
    private final UUID uuid = UUID.randomUUID();
    private boolean sneaking;
    private boolean visible;
    private final Property property;
    private final boolean staticOffset;
    private final PacketPlayOutEntityDestroy destroyPacket = new PacketPlayOutEntityDestroy(this.entityId);

    public BukkitArmorStand(TabPlayer owner, Property property, double yOffset, boolean staticOffset) {
        this.owner = owner;
        this.staticOffset = staticOffset;
        this.player = (Player)owner.getPlayer();
        this.yOffset = yOffset;
        this.property = property;
        this.visible = this.getVisibility();
    }

    @Override
    public void refresh() {
        this.visible = this.getVisibility();
        this.updateMetadata();
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public boolean hasStaticOffset() {
        return this.staticOffset;
    }

    @Override
    public double getOffset() {
        return this.yOffset;
    }

    @Override
    public void setOffset(double offset) {
        if (this.yOffset == offset) {
            return;
        }
        this.yOffset = offset;
        for (TabPlayer all : this.owner.getArmorStandManager().getNearbyPlayers()) {
            all.sendCustomPacket((TabPacket)this.getTeleportPacket(all), "Unlimited NameTags (Changing offset)");
        }
    }

    @Override
    public void spawn(TabPlayer viewer) {
        for (TabPacket packet : this.getSpawnPackets(viewer)) {
            viewer.sendCustomPacket(packet, "Unlimited NameTags (Spawning)");
        }
    }

    @Override
    public void destroy() {
        for (TabPlayer all : this.owner.getArmorStandManager().getNearbyPlayers()) {
            all.sendCustomPacket((TabPacket)this.destroyPacket, "Unlimited NameTags (Despawning)");
        }
    }

    @Override
    public void destroy(TabPlayer viewer) {
        viewer.sendCustomPacket((TabPacket)this.destroyPacket, "Unlimited NameTags (Despawning)");
    }

    @Override
    public void teleport() {
        for (TabPlayer all : this.owner.getArmorStandManager().getNearbyPlayers()) {
            all.sendCustomPacket((TabPacket)this.getTeleportPacket(all), "Unlimited NameTags (Teleporting)");
        }
    }

    @Override
    public void teleport(TabPlayer viewer) {
        if (!this.owner.getArmorStandManager().isNearby(viewer) && viewer != this.owner) {
            this.owner.getArmorStandManager().spawn(viewer);
        } else {
            viewer.sendCustomPacket((TabPacket)this.getTeleportPacket(viewer), "Unlimited NameTags (Teleporting)");
        }
    }

    @Override
    public void sneak(boolean sneaking) {
        if (this.sneaking == sneaking) {
            return;
        }
        this.sneaking = sneaking;
        for (TabPlayer viewer : this.owner.getArmorStandManager().getNearbyPlayers()) {
            if (viewer.getVersion().getMinorVersion() == 14 && !this.alwaysVisible) {
                if (sneaking) {
                    viewer.sendCustomPacket((TabPacket)this.destroyPacket, "Unlimited NameTags (Sneaking)");
                    continue;
                }
                this.spawn(viewer);
                continue;
            }
            this.respawn(viewer);
        }
    }

    @Override
    public void updateVisibility(boolean force) {
        boolean visibility = this.getVisibility();
        if (this.visible != visibility || force) {
            this.visible = visibility;
            this.updateMetadata();
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    public PacketPlayOutEntityTeleport getTeleportPacket(TabPlayer viewer) {
        return new PacketPlayOutEntityTeleport(this.entityId, this.getArmorStandLocationFor(viewer));
    }

    public void updateMetadata() {
        for (TabPlayer viewer : this.owner.getArmorStandManager().getNearbyPlayers()) {
            viewer.sendCustomPacket((TabPacket)new PacketPlayOutEntityMetadata(this.entityId, this.createDataWatcher(this.property.getFormat(viewer), viewer)), "Unlimited NameTags (Metadata)");
        }
    }

    public boolean getVisibility() {
        if (this.owner.isDisguised() || this.manager.getVehicleManager().isOnBoat(this.owner)) {
            return false;
        }
        if (this.alwaysVisible) {
            return true;
        }
        return !this.owner.hasInvisibilityPotion() && this.owner.getGamemode() != 3 && !this.manager.hasHiddenNametag(this.owner) && this.property.get().length() > 0;
    }

    public Location getLocation() {
        double x = this.player.getLocation().getX();
        double y = this.getY() + this.yOffset + 2.0;
        double z = this.player.getLocation().getZ();
        y = this.player.isSleeping() ? (y -= 1.76) : (TAB.getInstance().getServerVersion().getMinorVersion() >= 9 ? (y -= this.sneaking ? 0.45 : 0.18) : (y -= this.sneaking ? 0.3 : 0.18));
        return new Location(null, x, y, z);
    }

    protected double getY() {
        Entity vehicle = this.player.getVehicle();
        if (vehicle != null) {
            if (vehicle.getType().toString().contains("HORSE")) {
                return vehicle.getLocation().getY() + 0.85;
            }
            if (vehicle.getType().toString().equals("DONKEY")) {
                return vehicle.getLocation().getY() + 0.525;
            }
            if (vehicle.getType() == EntityType.PIG) {
                return vehicle.getLocation().getY() + 0.325;
            }
            if (vehicle.getType().toString().equals("STRIDER")) {
                return vehicle.getLocation().getY() + 1.15;
            }
        }
        if (this.isSwimming() || TAB.getInstance().getServerVersion().getMinorVersion() >= 9 && this.player.isGliding()) {
            return this.player.getLocation().getY() - 1.22;
        }
        return this.player.getLocation().getY();
    }

    private boolean isSwimming() {
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 14 && this.player.getPose() == Pose.SWIMMING) {
            return true;
        }
        return TAB.getInstance().getServerVersion().getMinorVersion() == 13 && this.player.isSwimming();
    }

    public DataWatcher createDataWatcher(String displayName, TabPlayer viewer) {
        DataWatcher datawatcher = new DataWatcher();
        byte flag = 32;
        if (this.sneaking) {
            flag = (byte)(flag + 2);
        }
        datawatcher.helper().setEntityFlags(flag);
        datawatcher.helper().setCustomName(displayName, viewer.getVersion());
        boolean visibility = this.isNameVisiblyEmpty(displayName) || !((Player)viewer.getPlayer()).canSee(this.player) || this.manager.hasHiddenNametag(this.owner, viewer) ? false : this.visible;
        datawatcher.helper().setCustomNameVisible(visibility);
        if (viewer.getVersion().getMinorVersion() > 8 || this.manager.isMarkerFor18x()) {
            datawatcher.helper().setArmorStandFlags((byte)16);
        }
        return datawatcher;
    }

    private boolean isNameVisiblyEmpty(String displayName) {
        if (displayName.length() == 0) {
            return true;
        }
        if (!(displayName.startsWith(EnumChatFormat.COLOR_STRING) || displayName.startsWith("&") || displayName.startsWith("#"))) {
            return false;
        }
        String text = IChatBaseComponent.fromColoredText(displayName).toRawText();
        if (text.contains(" ")) {
            text = text.replace(" ", "");
        }
        return text.length() == 0;
    }

    public TabPacket[] getSpawnPackets(TabPlayer viewer) {
        this.visible = this.getVisibility();
        DataWatcher dataWatcher = this.createDataWatcher(this.property.getFormat(viewer), viewer);
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 15) {
            return new TabPacket[]{new PacketPlayOutSpawnEntityLiving(this.entityId, this.uuid, EntityType.ARMOR_STAND, this.getArmorStandLocationFor(viewer), null), new PacketPlayOutEntityMetadata(this.entityId, dataWatcher)};
        }
        return new TabPacket[]{new PacketPlayOutSpawnEntityLiving(this.entityId, this.uuid, EntityType.ARMOR_STAND, this.getArmorStandLocationFor(viewer), dataWatcher)};
    }

    public Location getArmorStandLocationFor(TabPlayer viewer) {
        return viewer.getVersion().getMinorVersion() == 8 && !this.manager.isMarkerFor18x() ? this.getLocation().clone().add(0.0, -2.0, 0.0) : this.getLocation();
    }

    @Override
    public void respawn(TabPlayer viewer) {
        viewer.sendCustomPacket((TabPacket)this.destroyPacket, "Unlimited NameTags (Despawning)");
        Runnable spawn = () -> this.spawn(viewer);
        if (viewer.getVersion().getMinorVersion() == 8) {
            TAB.getInstance().getCPUManager().runTaskLater(50, "compensating for 1.8.0 bugs", this.manager, "Compensating for 1.8.0 bugs", spawn);
        } else {
            spawn.run();
        }
    }
}

