/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.NameTagX;
import me.neznamy.tab.shared.TAB;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;

public class EventListener
implements Listener {
    private final NameTagX feature;

    public EventListener(NameTagX feature) {
        this.feature = feature;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSneak(PlayerToggleSneakEvent e) {
        TabPlayer p = TAB.getInstance().getPlayer(e.getPlayer().getUniqueId());
        if (p == null || this.feature.isPlayerDisabled(p)) {
            return;
        }
        TAB.getInstance().getCPUManager().runMeasuredTask("processing PlayerToggleSneakEvent", this.feature, "Player Sneak", () -> {
            if (p.getArmorStandManager() != null) {
                p.getArmorStandManager().sneak(e.isSneaking());
            }
        });
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        TAB.getInstance().getCPUManager().runMeasuredTask("processing PlayerRespawnEvent", this.feature, "Player Respawn", () -> {
            TabPlayer respawned = TAB.getInstance().getPlayer(e.getPlayer().getUniqueId());
            if (this.feature.isPlayerDisabled(respawned)) {
                return;
            }
            respawned.getArmorStandManager().teleport();
        });
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        TabPlayer p = TAB.getInstance().getPlayer(e.getPlayer().getUniqueId());
        if (p == null || !p.isLoaded()) {
            return;
        }
        long time = System.nanoTime();
        String to = e.getPlayer().getWorld().getName();
        if (this.feature.isDisabled(to)) {
            this.feature.getPlayersInDisabledUnlimitedWorlds().add(p);
        } else {
            this.feature.getPlayersInDisabledUnlimitedWorlds().remove(p);
        }
        TabPlayer[] nearby = p.getArmorStandManager().getNearbyPlayers();
        p.getArmorStandManager().destroy();
        this.feature.loadArmorStands(p);
        this.feature.getVehicleManager().loadPassengers(p);
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getArmorStandManager() != null) {
                viewer.getArmorStandManager().destroy(p);
            }
            if (!to.equals(viewer.getWorld())) continue;
            for (TabPlayer player : nearby) {
                if (player != viewer) continue;
                this.feature.spawnArmorStands(p, viewer, true);
            }
        }
        TAB.getInstance().getCPUManager().addTime(this.feature, "World Switch", System.nanoTime() - time);
    }
}

