/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.ArmorStand;
import me.neznamy.tab.api.ArmorStandManager;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.team.UnlimitedNametagManager;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.BukkitArmorStand;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.EventListener;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.PacketListener;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.VehicleRefresher;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.nametags.NameTag;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class NameTagX
extends NameTag
implements UnlimitedNametagManager {
    private final boolean markerFor18x = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.unlimited-nametag-mode.use-marker-tag-for-1-8-x-clients", false);
    private final boolean disableOnBoats = TAB.getInstance().getConfiguration().getConfig().getBoolean("scoreboard-teams.unlimited-nametag-mode.disable-on-boats", true);
    private final double spaceBetweenLines = TAB.getInstance().getConfiguration().getConfig().getDouble("scoreboard-teams.unlimited-nametag-mode.space-between-lines", 0.22);
    protected final List<String> disabledUnlimitedWorlds = TAB.getInstance().getConfiguration().getConfig().getStringList("scoreboard-teams.unlimited-nametag-mode.disable-in-worlds", new ArrayList<String>());
    private final List<String> dynamicLines = new ArrayList<String>(TAB.getInstance().getConfiguration().getConfig().getStringList("scoreboard-teams.unlimited-nametag-mode.dynamic-lines", Arrays.asList("abovename", "nametag", "belowname", "another")));
    private final Map<String, Object> staticLines = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("scoreboard-teams.unlimited-nametag-mode.static-lines");
    private final Map<Integer, TabPlayer> entityIdMap = new ConcurrentHashMap<Integer, TabPlayer>();
    private final EventListener eventListener = new EventListener(this);
    private final Set<TabPlayer> playersInDisabledUnlimitedWorlds = Collections.newSetFromMap(new WeakHashMap());
    private final String[] disabledUnlimitedWorldsArray = this.disabledUnlimitedWorlds.toArray(new String[0]);
    private final boolean unlimitedWorldWhitelistMode = this.disabledUnlimitedWorlds.contains("WHITELIST");
    private final Set<TabPlayer> playersDisabledWithAPI = Collections.newSetFromMap(new WeakHashMap());
    private final VehicleRefresher vehicleManager = new VehicleRefresher(this);

    public NameTagX(JavaPlugin plugin) {
        Collections.reverse(this.dynamicLines);
        Bukkit.getPluginManager().registerEvents((Listener)this.eventListener, (Plugin)plugin);
        TAB.getInstance().getFeatureManager().registerFeature("nametagx-packet", new PacketListener(this));
        TAB.getInstance().getFeatureManager().registerFeature("nametagx-vehicle", this.vehicleManager);
        TAB.getInstance().debug(String.format("Loaded Unlimited NameTag feature with parameters markerFor18x=%s, disableOnBoats=%s, spaceBetweenLines=%s, disabledUnlimitedWorlds=%s", this.markerFor18x, this.disableOnBoats, this.spaceBetweenLines, this.disabledUnlimitedWorlds));
    }

    @Override
    public void load() {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            this.getEntityIdMap().put(((Player)all.getPlayer()).getEntityId(), all);
            this.updateProperties(all);
            this.loadArmorStands(all);
            if (this.isDisabled(all.getWorld())) {
                this.playersInDisabledUnlimitedWorlds.add(all);
            }
            if (this.isPlayerDisabled(all)) continue;
            this.vehicleManager.loadPassengers(all);
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                this.spawnArmorStands(all, viewer, false);
            }
        }
        super.load();
        this.startVisibilityRefreshTask();
    }

    private void startVisibilityRefreshTask() {
        TAB.getInstance().getCPUManager().startRepeatingMeasuredTask(500, "refreshing NameTag visibility", this, "Refreshing NameTag visibility", () -> {
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                if (this.isPlayerDisabled(p)) continue;
                p.getArmorStandManager().updateVisibility(false);
            }
        });
    }

    @Override
    public void unload() {
        super.unload();
        HandlerList.unregisterAll((Listener)this.eventListener);
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (p.getArmorStandManager() == null) continue;
            p.getArmorStandManager().destroy();
        }
        this.getEntityIdMap().clear();
    }

    @Override
    public void onJoin(TabPlayer connectedPlayer) {
        if (this.isDisabled(connectedPlayer.getWorld())) {
            this.playersInDisabledUnlimitedWorlds.add(connectedPlayer);
        }
        super.onJoin(connectedPlayer);
        this.getEntityIdMap().put(((Player)connectedPlayer.getPlayer()).getEntityId(), connectedPlayer);
        this.loadArmorStands(connectedPlayer);
        if (this.isPlayerDisabled(connectedPlayer)) {
            return;
        }
        this.vehicleManager.loadPassengers(connectedPlayer);
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            this.spawnArmorStands(connectedPlayer, viewer, true);
        }
    }

    private double getDistance(TabPlayer player1, TabPlayer player2) {
        Location loc1 = ((Player)player1.getPlayer()).getLocation();
        Location loc2 = ((Player)player2.getPlayer()).getLocation();
        return Math.sqrt(Math.pow(loc1.getX() - loc2.getX(), 2.0) + Math.pow(loc1.getZ() - loc2.getZ(), 2.0));
    }

    @Override
    public void onQuit(TabPlayer disconnectedPlayer) {
        super.onQuit(disconnectedPlayer);
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            if (all.getArmorStandManager() == null) continue;
            all.getArmorStandManager().unregisterPlayer(disconnectedPlayer);
        }
        this.entityIdMap.remove(((Player)disconnectedPlayer.getPlayer()).getEntityId());
        if (disconnectedPlayer.getArmorStandManager() != null) {
            disconnectedPlayer.getArmorStandManager().destroy();
            TAB.getInstance().getCPUManager().runTaskLater(500, "processing onQuit", this, "Player Quit", () -> disconnectedPlayer.getArmorStandManager().destroy());
        }
    }

    public void spawnArmorStands(TabPlayer owner, TabPlayer viewer, boolean sendMutually) {
        if (owner == viewer) {
            return;
        }
        if (((Player)viewer.getPlayer()).getWorld() != ((Player)owner.getPlayer()).getWorld()) {
            return;
        }
        if (this.isPlayerDisabled(owner)) {
            return;
        }
        if (this.getDistance(viewer, owner) <= 48.0) {
            if (((Player)viewer.getPlayer()).canSee((Player)owner.getPlayer()) && !owner.isVanished()) {
                owner.getArmorStandManager().spawn(viewer);
            }
            if (sendMutually && viewer.getArmorStandManager() != null && ((Player)owner.getPlayer()).canSee((Player)viewer.getPlayer()) && !viewer.isVanished()) {
                viewer.getArmorStandManager().spawn(owner);
            }
        }
    }

    public void loadArmorStands(TabPlayer pl) {
        Property p;
        pl.setArmorStandManager(new ArmorStandManager());
        pl.setProperty(this, "nametag", pl.getProperty("tagprefix").getCurrentRawValue() + pl.getProperty("customtagname").getCurrentRawValue() + pl.getProperty("tagsuffix").getCurrentRawValue());
        double height = 0.0;
        for (String string : this.dynamicLines) {
            p = pl.getProperty(string);
            if (p.getCurrentRawValue().length() == 0) continue;
            pl.getArmorStandManager().addArmorStand(string, new BukkitArmorStand(pl, p, height, false));
            height += this.spaceBetweenLines;
        }
        for (Map.Entry entry : this.staticLines.entrySet()) {
            p = pl.getProperty((String)entry.getKey());
            if (p.getCurrentRawValue().length() == 0) continue;
            pl.getArmorStandManager().addArmorStand((String)entry.getKey(), new BukkitArmorStand(pl, p, Double.parseDouble(entry.getValue().toString()), true));
        }
        this.fixArmorStandHeights(pl);
    }

    public void fixArmorStandHeights(TabPlayer p) {
        double currentY = -this.spaceBetweenLines;
        for (ArmorStand as : p.getArmorStandManager().getArmorStands()) {
            if (as.hasStaticOffset() || as.getProperty().get().length() == 0) continue;
            as.setOffset(currentY += this.spaceBetweenLines);
        }
    }

    @Override
    public void refresh(TabPlayer refreshed, boolean force) {
        super.refresh(refreshed, force);
        if (this.isPlayerDisabled(refreshed)) {
            return;
        }
        if (force) {
            refreshed.getArmorStandManager().destroy();
            this.loadArmorStands(refreshed);
            this.vehicleManager.loadPassengers(refreshed);
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                if (viewer == refreshed || !viewer.getWorld().equals(refreshed.getWorld())) continue;
                refreshed.getArmorStandManager().spawn(viewer);
            }
        } else {
            boolean fix = false;
            for (ArmorStand as : refreshed.getArmorStandManager().getArmorStands()) {
                if (!as.getProperty().update()) continue;
                as.refresh();
                fix = true;
            }
            if (fix) {
                this.fixArmorStandHeights(refreshed);
            }
        }
    }

    @Override
    public boolean updateProperties(TabPlayer p) {
        boolean changed = super.updateProperties(p);
        if (p.loadPropertyFromConfig(this, "customtagname", p.getName())) {
            changed = true;
        }
        if (p.setProperty(this, "nametag", p.getProperty("tagprefix").getCurrentRawValue() + p.getProperty("customtagname").getCurrentRawValue() + p.getProperty("tagsuffix").getCurrentRawValue())) {
            changed = true;
        }
        for (String property : this.dynamicLines) {
            if (property.equals("nametag") || !p.loadPropertyFromConfig(this, property)) continue;
            changed = true;
        }
        for (String property : this.staticLines.keySet()) {
            if (property.equals("nametag") || !p.loadPropertyFromConfig(this, property)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public String getFeatureName() {
        return "Unlimited NameTags";
    }

    @Override
    public boolean getTeamVisibility(TabPlayer p, TabPlayer viewer) {
        if (p.hasInvisibilityPotion()) {
            return false;
        }
        if (this.vehicleManager == null) {
            return false;
        }
        return this.vehicleManager.isOnBoat(p) || this.isPlayerDisabled(p);
    }

    public Map<Integer, TabPlayer> getEntityIdMap() {
        return this.entityIdMap;
    }

    public boolean isDisabled(String world) {
        boolean contains = this.contains(this.disabledUnlimitedWorldsArray, world);
        if (this.unlimitedWorldWhitelistMode) {
            contains = !contains;
        }
        return contains;
    }

    public boolean isPlayerDisabled(TabPlayer p) {
        return this.isDisabledPlayer(p) || this.playersInDisabledUnlimitedWorlds.contains(p) || this.hasTeamHandlingPaused(p) || this.hasDisabledArmorStands(p);
    }

    public boolean isMarkerFor18x() {
        return this.markerFor18x;
    }

    public Set<TabPlayer> getPlayersInDisabledUnlimitedWorlds() {
        return this.playersInDisabledUnlimitedWorlds;
    }

    public VehicleRefresher getVehicleManager() {
        return this.vehicleManager;
    }

    @Override
    public void pauseTeamHandling(TabPlayer player) {
        if (this.teamHandlingPaused.contains(player)) {
            return;
        }
        if (!this.isDisabledPlayer(player)) {
            this.unregisterTeam(player);
        }
        this.teamHandlingPaused.add(player);
        player.getArmorStandManager().destroy();
    }

    @Override
    public void resumeTeamHandling(TabPlayer player) {
        if (!this.teamHandlingPaused.contains(player)) {
            return;
        }
        this.teamHandlingPaused.remove(player);
        if (!this.isDisabledPlayer(player)) {
            this.registerTeam(player);
        }
        if (!this.isPlayerDisabled(player)) {
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                this.spawnArmorStands(player, viewer, false);
            }
        }
    }

    @Override
    public void disableArmorStands(TabPlayer player) {
        if (this.playersDisabledWithAPI.contains(player)) {
            return;
        }
        this.playersDisabledWithAPI.add(player);
        player.getArmorStandManager().destroy();
        this.updateTeamData(player);
    }

    @Override
    public void enableArmorStands(TabPlayer player) {
        if (!this.playersDisabledWithAPI.contains(player)) {
            return;
        }
        this.playersDisabledWithAPI.remove(player);
        if (!this.isPlayerDisabled(player)) {
            for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                this.spawnArmorStands(player, viewer, false);
            }
        }
        this.updateTeamData(player);
    }

    @Override
    public boolean hasDisabledArmorStands(TabPlayer player) {
        return this.playersDisabledWithAPI.contains(player);
    }

    @Override
    public void setPrefix(TabPlayer player, String prefix) {
        player.getProperty("tagprefix").setTemporaryValue(prefix);
        this.rebuildNameTagLine(player);
        player.forceRefresh();
    }

    @Override
    public void setSuffix(TabPlayer player, String suffix) {
        player.getProperty("tagsuffix").setTemporaryValue(suffix);
        this.rebuildNameTagLine(player);
        player.forceRefresh();
    }

    @Override
    public void resetPrefix(TabPlayer player) {
        player.getProperty("tagprefix").setTemporaryValue(null);
        this.rebuildNameTagLine(player);
        player.forceRefresh();
    }

    @Override
    public void resetSuffix(TabPlayer player) {
        player.getProperty("tagsuffix").setTemporaryValue(null);
        this.rebuildNameTagLine(player);
        player.forceRefresh();
    }

    @Override
    public void setName(TabPlayer player, String customName) {
        player.getProperty("customtagname").setTemporaryValue(customName);
        this.rebuildNameTagLine(player);
        player.forceRefresh();
    }

    @Override
    public void setLine(TabPlayer player, String line, String value) {
        player.getProperty(line).setTemporaryValue(value);
        player.forceRefresh();
    }

    @Override
    public void resetName(TabPlayer player) {
        player.getProperty("customtagname").setTemporaryValue(null);
        this.rebuildNameTagLine(player);
        player.forceRefresh();
    }

    @Override
    public void resetLine(TabPlayer player, String line) {
        player.getProperty(line).setTemporaryValue(null);
        player.forceRefresh();
    }

    @Override
    public String getCustomName(TabPlayer player) {
        return player.getProperty("customtagname").getTemporaryValue();
    }

    @Override
    public String getCustomLineValue(TabPlayer player, String line) {
        return player.getProperty(line).getTemporaryValue();
    }

    @Override
    public String getOriginalName(TabPlayer player) {
        return player.getProperty("customtagname").getOriginalRawValue();
    }

    @Override
    public String getOriginalLineValue(TabPlayer player, String line) {
        return player.getProperty(line).getOriginalRawValue();
    }

    private void rebuildNameTagLine(TabPlayer player) {
        player.setProperty(this, "nametag", player.getProperty("tagprefix").getCurrentRawValue() + player.getProperty("customtagname").getCurrentRawValue() + player.getProperty("tagsuffix").getCurrentRawValue());
    }

    public boolean isDisableOnBoats() {
        return this.disableOnBoats;
    }

    @Override
    public List<String> getDefinedLines() {
        ArrayList<String> lines = new ArrayList<String>(this.dynamicLines);
        lines.addAll(this.staticLines.keySet());
        return lines;
    }
}

