/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import java.util.List;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.NameTagX;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import me.neznamy.tab.shared.TAB;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PacketListener
extends TabFeature {
    private final NameTagX nameTagX;
    private final NMSStorage nms = NMSStorage.getInstance();

    public PacketListener(NameTagX nameTagX) {
        super(nameTagX.getFeatureName(), null);
        this.nameTagX = nameTagX;
    }

    @Override
    public boolean onPacketReceive(TabPlayer sender, Object packet) throws ReflectiveOperationException {
        if (sender.getVersion().getMinorVersion() == 8 && this.nms.PacketPlayInUseEntity.isInstance(packet)) {
            int entityId = this.nms.PacketPlayInUseEntity_ENTITY.getInt(packet);
            TabPlayer attacked = null;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!all.isLoaded() || !all.getArmorStandManager().hasArmorStandWithID(entityId)) continue;
                attacked = all;
                break;
            }
            if (attacked != null && attacked != sender) {
                this.nms.setField(packet, this.nms.PacketPlayInUseEntity_ENTITY, ((Player)attacked.getPlayer()).getEntityId());
            }
        }
        return false;
    }

    @Override
    public void onPacketSend(TabPlayer receiver, Object packet) throws ReflectiveOperationException {
        if (receiver.getVersion().getMinorVersion() < 8) {
            return;
        }
        if (!receiver.isLoaded() || this.nameTagX.isDisabledPlayer(receiver) || this.nameTagX.getPlayersInDisabledUnlimitedWorlds().contains(receiver)) {
            return;
        }
        if (this.nms.PacketPlayOutEntity.isInstance(packet) && !this.nms.PacketPlayOutEntityLook.isInstance(packet)) {
            this.onEntityMove(receiver, this.nms.PacketPlayOutEntity_ENTITYID.getInt(packet));
        } else if (this.nms.PacketPlayOutEntityTeleport.isInstance(packet)) {
            this.onEntityMove(receiver, this.nms.PacketPlayOutEntityTeleport_ENTITYID.getInt(packet));
        } else if (this.nms.PacketPlayOutNamedEntitySpawn.isInstance(packet)) {
            this.onEntitySpawn(receiver, this.nms.PacketPlayOutNamedEntitySpawn_ENTITYID.getInt(packet));
        } else if (this.nms.PacketPlayOutEntityDestroy.isInstance(packet)) {
            if (this.nms.getMinorVersion() >= 17) {
                Object entities = this.nms.PacketPlayOutEntityDestroy_ENTITIES.get(packet);
                if (entities instanceof List) {
                    this.onEntityDestroy(receiver, (List)entities);
                } else {
                    this.onEntityDestroy(receiver, (int)((Integer)entities));
                }
            } else {
                this.onEntityDestroy(receiver, (int[])this.nms.PacketPlayOutEntityDestroy_ENTITIES.get(packet));
            }
        }
    }

    private void onEntityMove(TabPlayer receiver, int entityId) {
        TabPlayer pl = this.nameTagX.getEntityIdMap().get(entityId);
        if (pl != null) {
            if (this.nameTagX.isPlayerDisabled(pl)) {
                return;
            }
            TAB.getInstance().getCPUManager().runMeasuredTask("processing EntityMove", this.nameTagX, "PacketPlayOutEntity", () -> pl.getArmorStandManager().teleport(receiver));
        } else {
            List<Entity> vehicleList = this.nameTagX.getVehicleManager().getVehicles().get(entityId);
            if (vehicleList != null) {
                for (Entity entity : vehicleList) {
                    TabPlayer passenger = this.nameTagX.getEntityIdMap().get(entity.getEntityId());
                    if (passenger == null || passenger.getArmorStandManager() == null) continue;
                    TAB.getInstance().getCPUManager().runMeasuredTask("processing EntityMove", this.nameTagX, "PacketPlayOutEntity (passenger)", () -> passenger.getArmorStandManager().teleport(receiver));
                }
            }
        }
    }

    private void onEntitySpawn(TabPlayer receiver, int entityId) {
        TabPlayer spawnedPlayer = this.nameTagX.getEntityIdMap().get(entityId);
        if (spawnedPlayer != null && spawnedPlayer.isLoaded() && !this.nameTagX.isPlayerDisabled(spawnedPlayer)) {
            TAB.getInstance().getCPUManager().runMeasuredTask("processing NamedEntitySpawn", this.nameTagX, "PacketPlayOutNamedEntitySpawn", () -> spawnedPlayer.getArmorStandManager().spawn(receiver));
        }
    }

    private void onEntityDestroy(TabPlayer receiver, List<Integer> entities) {
        for (int entity : entities) {
            this.onEntityDestroy(receiver, entity);
        }
    }

    private void onEntityDestroy(TabPlayer receiver, int ... entities) {
        for (int entity : entities) {
            this.onEntityDestroy(receiver, entity);
        }
    }

    private void onEntityDestroy(TabPlayer receiver, int entity) {
        TabPlayer deSpawnedPlayer = this.nameTagX.getEntityIdMap().get(entity);
        if (deSpawnedPlayer != null && deSpawnedPlayer.isLoaded() && !this.nameTagX.isPlayerDisabled(deSpawnedPlayer)) {
            TAB.getInstance().getCPUManager().runMeasuredTask("processing EntityDestroy", this.nameTagX, "PacketPlayOutEntityDestroy", () -> deSpawnedPlayer.getArmorStandManager().destroy(receiver));
        }
    }
}

