/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.features.unlimitedtags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bukkit.features.unlimitedtags.NameTagX;
import me.neznamy.tab.shared.TAB;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class VehicleRefresher
extends TabFeature {
    private final WeakHashMap<TabPlayer, Entity> playersInVehicle = new WeakHashMap();
    private final Map<Integer, List<Entity>> vehicles = new ConcurrentHashMap<Integer, List<Entity>>();
    private final Set<TabPlayer> playersOnBoats = Collections.newSetFromMap(new WeakHashMap());
    private final NameTagX feature;

    public VehicleRefresher(NameTagX feature) {
        super(feature.getFeatureName(), "Refreshing vehicles");
        this.feature = feature;
        TAB.getInstance().getCPUManager().startRepeatingMeasuredTask(50, "processing player movement", this, "Processing player movement", () -> {
            for (TabPlayer inVehicle : this.playersInVehicle.keySet()) {
                inVehicle.getArmorStandManager().teleport();
            }
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                if (!p.isPreviewingNametag()) continue;
                p.getArmorStandManager().teleport(p);
            }
        });
        this.addUsedPlaceholders(Collections.singletonList("%vehicle%"));
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%vehicle%", 100, p -> ((Player)p.getPlayer()).getVehicle() == null ? "" : ((Player)p.getPlayer()).getVehicle());
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            Entity vehicle = ((Player)p.getPlayer()).getVehicle();
            if (vehicle == null) continue;
            this.vehicles.put(vehicle.getEntityId(), this.getPassengers(vehicle));
            this.playersInVehicle.put(p, vehicle);
            if (!this.feature.isDisableOnBoats() || vehicle.getType() != EntityType.BOAT) continue;
            this.playersOnBoats.add(p);
        }
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        if (this.feature.isPlayerDisabled(p)) {
            return;
        }
        Entity vehicle = ((Player)p.getPlayer()).getVehicle();
        if (this.playersInVehicle.containsKey(p) && vehicle == null) {
            this.vehicles.remove(this.playersInVehicle.get(p).getEntityId());
            p.getArmorStandManager().teleport();
            this.playersInVehicle.remove(p);
            if (this.feature.isDisableOnBoats() && this.playersOnBoats.contains(p)) {
                this.playersOnBoats.remove(p);
                this.feature.updateTeamData(p);
            }
        }
        if (!this.playersInVehicle.containsKey(p) && vehicle != null) {
            this.vehicles.put(vehicle.getEntityId(), this.getPassengers(vehicle));
            p.getArmorStandManager().respawn();
            this.playersInVehicle.put(p, vehicle);
            if (this.feature.isDisableOnBoats() && vehicle.getType() == EntityType.BOAT) {
                this.playersOnBoats.add(p);
                this.feature.updateTeamData(p);
            }
        }
    }

    public boolean isOnBoat(TabPlayer p) {
        return this.playersOnBoats.contains(p);
    }

    @Override
    public void onQuit(TabPlayer disconnectedPlayer) {
        if (this.playersInVehicle.containsKey(disconnectedPlayer)) {
            this.vehicles.remove(this.playersInVehicle.get(disconnectedPlayer).getEntityId());
        }
    }

    public Map<Integer, List<Entity>> getVehicles() {
        return this.vehicles;
    }

    public List<Entity> getPassengers(Entity vehicle) {
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 11) {
            return vehicle.getPassengers();
        }
        if (vehicle.getPassenger() != null) {
            return Collections.singletonList(vehicle.getPassenger());
        }
        return new ArrayList<Entity>();
    }

    public void loadPassengers(TabPlayer p) {
        Entity vehicle = ((Entity)p.getPlayer()).getVehicle();
        if (vehicle == null) {
            return;
        }
        this.vehicles.put(vehicle.getEntityId(), this.getPassengers(vehicle));
    }

    public void processPassengers(Entity vehicle) {
        for (Entity passenger : this.getPassengers(vehicle)) {
            if (passenger instanceof Player) {
                TAB.getInstance().getPlayer(passenger.getUniqueId()).getArmorStandManager().teleport();
            }
            this.processPassengers(passenger);
        }
    }
}

