/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.nms;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.netty.channel.Channel;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.platforms.bukkit.Main;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcherRegistry;
import me.neznamy.tab.shared.TAB;
import org.bukkit.Bukkit;

public final class NMSStorage {
    private static NMSStorage instance;
    private final String serverPackage = Bukkit.getServer().getClass().getPackage().getName().split("\\.")[3];
    private final int minorVersion = Integer.parseInt(this.serverPackage.split("_")[1]);
    private final ProtocolVersion serverVersion = ProtocolVersion.fromFriendlyName(Bukkit.getBukkitVersion().split("-")[0]);
    private final Class<?> Packet = this.getNMSClass("net.minecraft.network.protocol.Packet", "Packet");
    public final Class<?> EnumChatFormat = this.getNMSClass("net.minecraft.EnumChatFormat", "EnumChatFormat");
    public final Class<?> EntityPlayer = this.getNMSClass("net.minecraft.server.level.EntityPlayer", "EntityPlayer");
    private final Class<?> Entity = this.getNMSClass("net.minecraft.world.entity.Entity", "Entity");
    private final Class<?> EntityLiving = this.getNMSClass("net.minecraft.world.entity.EntityLiving", "EntityLiving");
    private final Class<?> PlayerConnection = this.getNMSClass("net.minecraft.server.network.PlayerConnection", "PlayerConnection");
    public Constructor<?> newEntityArmorStand;
    public final Field PING = this.getField(this.EntityPlayer, "ping", "latency", "field_71138_i", "field_13967", "e");
    public final Field PLAYER_CONNECTION = this.getFields(this.EntityPlayer, this.PlayerConnection).get(0);
    public Field NETWORK_MANAGER;
    public Field CHANNEL;
    public final Method getHandle = Class.forName("org.bukkit.craftbukkit." + this.serverPackage + ".entity.CraftPlayer").getMethod("getHandle", new Class[0]);
    public final Method sendPacket = this.getMethods(this.PlayerConnection, Void.TYPE, this.Packet).get(0);
    public Method getProfile;
    public final Method World_getHandle = Class.forName("org.bukkit.craftbukkit." + this.serverPackage + ".CraftWorld").getMethod("getHandle", new Class[0]);
    public final Enum[] EnumChatFormat_values = this.getEnumValues(this.EnumChatFormat);
    public Class<?> ChatComponentText;
    public Class<?> ChatHoverable;
    public Class<?> EnumClickAction;
    private Class<?> IChatBaseComponent;
    public Constructor<?> newChatComponentText;
    public Constructor<?> newChatClickable;
    public Constructor<?> newChatModifier;
    public Constructor<?> newChatHoverable;
    public Field ChatBaseComponent_extra;
    public Field ChatBaseComponent_modifier;
    public Field ChatComponentText_text;
    public Field ChatClickable_action;
    public Field ChatClickable_value;
    public Field ChatModifier_bold;
    public Field ChatModifier_italic;
    public Field ChatModifier_underlined;
    public Field ChatModifier_strikethrough;
    public Field ChatModifier_obfuscated;
    public Field ChatModifier_clickEvent;
    public Field ChatModifier_hoverEvent;
    public Field ChatHexColor_name;
    public Field ChatHexColor_rgb;
    public Field ChatModifier_color;
    public Method ChatComponentText_addSibling;
    public Method EnumHoverAction_a;
    public Method ChatHoverable_getAction;
    public Method ChatHexColor_ofInt;
    public Method ChatHexColor_ofString;
    public Method ChatHoverable_serialize;
    public Method ChatHoverable_getValue;
    public Method EnumHoverAction_fromJson;
    public Method EnumHoverAction_fromLegacyComponent;
    public Class<?> ChatMessageType;
    public Constructor<?> newPacketPlayOutChat;
    public Enum[] ChatMessageType_values;
    private final Class<?> DataWatcher = this.getNMSClass("net.minecraft.network.syncher.DataWatcher", "DataWatcher");
    private final Class<?> DataWatcherItem = this.getNMSClass("net.minecraft.network.syncher.DataWatcher$Item", "DataWatcher$Item", "DataWatcher$WatchableObject", "WatchableObject");
    public Class<?> DataWatcherRegistry;
    public final Constructor<?> newDataWatcher = this.DataWatcher.getConstructors()[0];
    public Constructor<?> newDataWatcherObject;
    public Field DataWatcherItem_TYPE;
    public final Field DataWatcherItem_VALUE = this.getFields(this.DataWatcherItem, Object.class).get(0);
    public Field DataWatcherObject_SLOT;
    public Field DataWatcherObject_SERIALIZER;
    public Method DataWatcher_REGISTER;
    private DataWatcherRegistry registry;
    public final Class<?> PacketPlayOutSpawnEntityLiving = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving", "PacketPlayOutSpawnEntityLiving", "Packet24MobSpawn");
    public Constructor<?> newPacketPlayOutSpawnEntityLiving;
    public final Field PacketPlayOutSpawnEntityLiving_ENTITYID = this.getFields(this.PacketPlayOutSpawnEntityLiving, Integer.TYPE).get(0);
    public final Field PacketPlayOutSpawnEntityLiving_ENTITYTYPE = this.getFields(this.PacketPlayOutSpawnEntityLiving, Integer.TYPE).get(1);
    public final Field PacketPlayOutSpawnEntityLiving_YAW = this.getFields(this.PacketPlayOutSpawnEntityLiving, Byte.TYPE).get(0);
    public final Field PacketPlayOutSpawnEntityLiving_PITCH = this.getFields(this.PacketPlayOutSpawnEntityLiving, Byte.TYPE).get(0);
    public Field PacketPlayOutSpawnEntityLiving_UUID;
    public Field PacketPlayOutSpawnEntityLiving_X;
    public Field PacketPlayOutSpawnEntityLiving_Y;
    public Field PacketPlayOutSpawnEntityLiving_Z;
    public Field PacketPlayOutSpawnEntityLiving_DATAWATCHER;
    public final Class<?> PacketPlayOutEntityTeleport = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport", "PacketPlayOutEntityTeleport", "Packet34EntityTeleport");
    public Constructor<?> newPacketPlayOutEntityTeleport;
    public final Field PacketPlayOutEntityTeleport_ENTITYID = this.getFields(this.PacketPlayOutEntityTeleport, Integer.TYPE).get(0);
    public Field PacketPlayOutEntityTeleport_X;
    public Field PacketPlayOutEntityTeleport_Y;
    public Field PacketPlayOutEntityTeleport_Z;
    public final Field PacketPlayOutEntityTeleport_YAW = this.getFields(this.PacketPlayOutEntityTeleport, Byte.TYPE).get(0);
    public final Field PacketPlayOutEntityTeleport_PITCH = this.getFields(this.PacketPlayOutEntityTeleport, Byte.TYPE).get(1);
    public Constructor<?> newPacketPlayOutPlayerListHeaderFooter;
    public Field PacketPlayOutPlayerListHeaderFooter_HEADER;
    public Field PacketPlayOutPlayerListHeaderFooter_FOOTER;
    public final Class<?> PacketPlayInUseEntity = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayInUseEntity", "PacketPlayInUseEntity", "Packet7UseEntity");
    public Class<?> PacketPlayInUseEntity$d;
    public Field PacketPlayInUseEntity_ENTITY;
    public Field PacketPlayInUseEntity_ACTION;
    public final Class<?> PacketPlayOutEntity = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutEntity", "PacketPlayOutEntity", "Packet30Entity");
    public final Field PacketPlayOutEntity_ENTITYID = this.getFields(this.PacketPlayOutEntity, Integer.TYPE).get(0);
    public final Class<?> PacketPlayOutEntityDestroy = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy", "PacketPlayOutEntityDestroy", "Packet29DestroyEntity");
    public Constructor<?> newPacketPlayOutEntityDestroy;
    public final Field PacketPlayOutEntityDestroy_ENTITIES = this.setAccessible(this.PacketPlayOutEntityDestroy.getDeclaredFields()[0]);
    public final Class<?> PacketPlayOutEntityLook = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutEntity$PacketPlayOutEntityLook", "PacketPlayOutEntity$PacketPlayOutEntityLook", "PacketPlayOutEntityLook", "Packet32EntityLook");
    public final Class<?> PacketPlayOutEntityMetadata = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata", "PacketPlayOutEntityMetadata", "Packet40EntityMetadata");
    public final Constructor<?> newPacketPlayOutEntityMetadata = this.PacketPlayOutEntityMetadata.getConstructor(Integer.TYPE, this.DataWatcher, Boolean.TYPE);
    public final Field PacketPlayOutEntityMetadata_LIST = this.getFields(this.PacketPlayOutEntityMetadata, List.class).get(0);
    public final Class<?> PacketPlayOutNamedEntitySpawn = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn", "PacketPlayOutNamedEntitySpawn", "Packet20NamedEntitySpawn");
    public final Field PacketPlayOutNamedEntitySpawn_ENTITYID = this.getFields(this.PacketPlayOutNamedEntitySpawn, Integer.TYPE).get(0);
    public Class<?> PacketPlayOutPlayerInfo;
    public Constructor<?> newPacketPlayOutPlayerInfo;
    public Constructor<?> newPlayerInfoData;
    public Field PacketPlayOutPlayerInfo_ACTION;
    public Field PacketPlayOutPlayerInfo_PLAYERS;
    public Method PlayerInfoData_getProfile;
    public Method PlayerInfoData_getLatency;
    public Method PlayerInfoData_getGamemode;
    public Method PlayerInfoData_getDisplayName;
    public Enum[] EnumPlayerInfoAction_values;
    public Enum[] EnumGamemode_values;
    public final Class<?> PacketPlayOutScoreboardDisplayObjective = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective", "PacketPlayOutScoreboardDisplayObjective", "Packet208SetScoreboardDisplayObjective");
    public final Class<?> PacketPlayOutScoreboardObjective = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective", "PacketPlayOutScoreboardObjective", "Packet206SetScoreboardObjective");
    private final Class<?> Scoreboard = this.getNMSClass("net.minecraft.world.scores.Scoreboard", "Scoreboard");
    private final Class<?> PacketPlayOutScoreboardScore = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore", "PacketPlayOutScoreboardScore", "Packet207SetScoreboardScore");
    private final Class<?> ScoreboardObjective = this.getNMSClass("net.minecraft.world.scores.ScoreboardObjective", "ScoreboardObjective");
    private final Class<?> ScoreboardScore = this.getNMSClass("net.minecraft.world.scores.ScoreboardScore", "ScoreboardScore");
    private final Class<?> IScoreboardCriteria = this.getNMSClass("net.minecraft.world.scores.criteria.IScoreboardCriteria", "IScoreboardCriteria");
    public Class<?> EnumScoreboardHealthDisplay;
    public final Constructor<?> newScoreboardObjective = this.ScoreboardObjective.getConstructors()[0];
    public final Constructor<?> newScoreboard = this.Scoreboard.getConstructor(new Class[0]);
    public final Constructor<?> newScoreboardScore = this.ScoreboardScore.getConstructor(this.Scoreboard, this.ScoreboardObjective, String.class);
    public final Constructor<?> newPacketPlayOutScoreboardDisplayObjective = this.PacketPlayOutScoreboardDisplayObjective.getConstructor(Integer.TYPE, this.ScoreboardObjective);
    public Constructor<?> newPacketPlayOutScoreboardObjective;
    public Constructor<?> newPacketPlayOutScoreboardScore_1_13;
    public Constructor<?> newPacketPlayOutScoreboardScore_String;
    public Constructor<?> newPacketPlayOutScoreboardScore;
    public final Field PacketPlayOutScoreboardDisplayObjective_POSITION = this.getFields(this.PacketPlayOutScoreboardDisplayObjective, Integer.TYPE).get(0);
    public final Field PacketPlayOutScoreboardDisplayObjective_OBJECTIVENAME = this.getFields(this.PacketPlayOutScoreboardDisplayObjective, String.class).get(0);
    public final Field PacketPlayOutScoreboardObjective_OBJECTIVENAME = this.getFields(this.PacketPlayOutScoreboardObjective, String.class).get(0);
    public Field PacketPlayOutScoreboardObjective_METHOD;
    public final Field IScoreboardCriteria_self = this.getFields(this.IScoreboardCriteria, this.IScoreboardCriteria).get(0);
    public Field PacketPlayOutScoreboardObjective_RENDERTYPE;
    public Field PacketPlayOutScoreboardObjective_DISPLAYNAME;
    public final Method ScoreboardScore_setScore = this.getMethod(this.ScoreboardScore, new String[]{"setScore", "func_96647_c", "method_1128", "b"}, Integer.TYPE);
    public Enum[] EnumScoreboardHealthDisplay_values;
    public Enum[] EnumScoreboardAction_values;
    public Class<?> PacketPlayOutScoreboardTeam;
    public Constructor<?> newScoreboardTeam;
    public Constructor<?> newPacketPlayOutScoreboardTeam;
    public Field PacketPlayOutScoreboardTeam_NAME;
    public Field PacketPlayOutScoreboardTeam_PLAYERS;
    public Method ScoreboardTeam_getPlayerNameSet;
    public Method ScoreboardTeam_setNameTagVisibility;
    public Method ScoreboardTeam_setCollisionRule;
    public Method ScoreboardTeam_setPrefix;
    public Method ScoreboardTeam_setSuffix;
    public Method ScoreboardTeam_setColor;
    public Method ScoreboardTeam_setAllowFriendlyFire;
    public Method ScoreboardTeam_setCanSeeFriendlyInvisibles;
    public Method PacketPlayOutScoreboardTeam_of;
    public Method PacketPlayOutScoreboardTeam_ofBoolean;
    public Method PacketPlayOutScoreboardTeam_ofString;
    public Enum[] EnumNameTagVisibility_values;
    public Enum[] EnumTeamPush_values;
    public Enum[] PacketPlayOutScoreboardTeam_PlayerAction_values;

    public NMSStorage() throws ReflectiveOperationException {
        ProtocolVersion.UNKNOWN.setMinorVersion(this.minorVersion);
        Class<?> NetworkManager = this.getNMSClass("net.minecraft.network.NetworkManager", "NetworkManager");
        if (this.minorVersion >= 7) {
            this.NETWORK_MANAGER = this.getFields(this.PlayerConnection, NetworkManager).get(0);
        }
        if (this.minorVersion >= 8) {
            this.CHANNEL = this.getFields(NetworkManager, Channel.class).get(0);
            this.getProfile = this.getMethods(this.getNMSClass("net.minecraft.world.entity.player.EntityHuman", "EntityHuman"), GameProfile.class, new Class[0]).get(0);
            this.newEntityArmorStand = this.getNMSClass("net.minecraft.world.entity.decoration.EntityArmorStand", "EntityArmorStand").getConstructor(this.getNMSClass("net.minecraft.world.level.World", "World"), Double.TYPE, Double.TYPE, Double.TYPE);
        }
        this.initializeChatComponents();
        this.initializeChatPacket();
        this.initializeDataWatcher();
        this.initializeEntityPackets();
        this.initializeHeaderFooterPacket();
        this.initializePlayerInfoPacket();
        this.initializeScoreboardPackets();
        try {
            this.initializeTeamPackets();
        }
        catch (ClassNotFoundException e) {
            Bukkit.getConsoleSender().sendMessage(me.neznamy.tab.api.chat.EnumChatFormat.color("&c[TAB] Failed to load PacketPlayOutScoreboardTeam"));
        }
    }

    public static void setInstance(NMSStorage instance) {
        NMSStorage.instance = instance;
    }

    public static NMSStorage getInstance() {
        return instance;
    }

    private void initializeChatComponents() throws ReflectiveOperationException {
        if (this.minorVersion < 7) {
            return;
        }
        Class<?> ChatBaseComponent = this.getNMSClass("net.minecraft.network.chat.ChatBaseComponent", "ChatBaseComponent");
        Class<?> ChatClickable2 = this.getNMSClass("net.minecraft.network.chat.ChatClickable", "ChatClickable");
        this.ChatComponentText = this.getNMSClass("net.minecraft.network.chat.ChatComponentText", "ChatComponentText");
        this.ChatHoverable = this.getNMSClass("net.minecraft.network.chat.ChatHoverable", "ChatHoverable");
        Class<?> ChatModifier2 = this.getNMSClass("net.minecraft.network.chat.ChatModifier", "ChatModifier");
        this.EnumClickAction = this.getNMSClass("net.minecraft.network.chat.ChatClickable$EnumClickAction", "ChatClickable$EnumClickAction", "EnumClickAction");
        Class<?> EnumHoverAction2 = this.getNMSClass("net.minecraft.network.chat.ChatHoverable$EnumHoverAction", "ChatHoverable$EnumHoverAction", "EnumHoverAction");
        this.IChatBaseComponent = this.getNMSClass("net.minecraft.network.chat.IChatBaseComponent", "IChatBaseComponent");
        this.newChatComponentText = this.ChatComponentText.getConstructor(String.class);
        this.newChatClickable = ChatClickable2.getConstructor(this.EnumClickAction, String.class);
        this.ChatBaseComponent_extra = this.getFields(ChatBaseComponent, List.class).get(0);
        this.ChatBaseComponent_modifier = this.getFields(ChatBaseComponent, ChatModifier2).get(0);
        this.ChatComponentText_text = this.getFields(this.ChatComponentText, String.class).get(0);
        this.ChatClickable_action = this.getFields(ChatClickable2, this.EnumClickAction).get(0);
        this.ChatClickable_value = this.getFields(ChatClickable2, String.class).get(0);
        List<Field> booleans = this.getFields(ChatModifier2, Boolean.class);
        this.ChatModifier_bold = booleans.get(0);
        this.ChatModifier_italic = booleans.get(1);
        this.ChatModifier_underlined = booleans.get(2);
        this.ChatModifier_strikethrough = booleans.get(3);
        this.ChatModifier_obfuscated = booleans.get(4);
        this.ChatModifier_clickEvent = this.getFields(ChatModifier2, ChatClickable2).get(0);
        this.ChatModifier_hoverEvent = this.getFields(ChatModifier2, this.ChatHoverable).get(0);
        this.ChatComponentText_addSibling = this.getMethod(this.ChatComponentText, new String[]{"addSibling", "a", "func_150257_a", "method_10852"}, this.IChatBaseComponent);
        this.EnumHoverAction_a = this.getMethod(EnumHoverAction2, new String[]{"a", "func_150684_a", "method_27670"}, String.class);
        this.ChatHoverable_getAction = this.getMethods(this.ChatHoverable, EnumHoverAction2, new Class[0]).get(0);
        if (this.minorVersion >= 16) {
            Class<?> ChatHexColor = this.getNMSClass("net.minecraft.network.chat.ChatHexColor", "ChatHexColor");
            Class<?> MinecraftKey = this.getNMSClass("net.minecraft.resources.MinecraftKey", "MinecraftKey");
            this.newChatModifier = this.setAccessible(ChatModifier2.getDeclaredConstructor(ChatHexColor, Boolean.class, Boolean.class, Boolean.class, Boolean.class, Boolean.class, ChatClickable2, this.ChatHoverable, String.class, MinecraftKey));
            this.newChatHoverable = this.ChatHoverable.getConstructor(EnumHoverAction2, Object.class);
            List<Field> list = this.getFields(ChatHexColor, String.class);
            this.ChatHexColor_name = list.get(list.size() - 1);
            this.ChatHexColor_rgb = this.getFields(ChatHexColor, Integer.TYPE).get(0);
            this.ChatModifier_color = this.getFields(ChatModifier2, ChatHexColor).get(0);
            this.ChatHexColor_ofInt = this.getMethods(ChatHexColor, ChatHexColor, Integer.TYPE).get(0);
            this.ChatHexColor_ofString = this.getMethods(ChatHexColor, ChatHexColor, String.class).get(0);
            this.ChatHoverable_serialize = this.getMethods(this.ChatHoverable, JsonObject.class, new Class[0]).get(0);
            this.ChatHoverable_getValue = this.getMethods(this.ChatHoverable, Object.class, EnumHoverAction2).get(0);
            this.EnumHoverAction_fromJson = this.getMethods(EnumHoverAction2, this.ChatHoverable, JsonElement.class).get(0);
            this.EnumHoverAction_fromLegacyComponent = this.getMethods(EnumHoverAction2, this.ChatHoverable, this.IChatBaseComponent).get(0);
        } else {
            this.newChatModifier = ChatModifier2.getConstructor(new Class[0]);
            this.newChatHoverable = this.ChatHoverable.getConstructor(EnumHoverAction2, this.IChatBaseComponent);
            this.ChatModifier_color = this.getFields(ChatModifier2, this.EnumChatFormat).get(0);
            this.ChatHoverable_getValue = this.getMethods(this.ChatHoverable, this.IChatBaseComponent, new Class[0]).get(0);
        }
    }

    private void initializeChatPacket() throws ReflectiveOperationException {
        Class<?> PacketPlayOutChat2 = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutChat", "PacketPlayOutChat", "Packet3Chat");
        if (this.minorVersion >= 12) {
            this.ChatMessageType = this.getNMSClass("net.minecraft.network.chat.ChatMessageType", "ChatMessageType");
            this.ChatMessageType_values = this.getEnumValues(this.ChatMessageType);
        }
        if (this.minorVersion >= 16) {
            this.newPacketPlayOutChat = PacketPlayOutChat2.getConstructor(this.IChatBaseComponent, this.ChatMessageType, UUID.class);
        } else if (this.minorVersion >= 12) {
            this.newPacketPlayOutChat = PacketPlayOutChat2.getConstructor(this.IChatBaseComponent, this.ChatMessageType);
        } else if (this.minorVersion >= 8) {
            this.newPacketPlayOutChat = PacketPlayOutChat2.getConstructor(this.IChatBaseComponent, Byte.TYPE);
        } else if (this.minorVersion >= 7) {
            this.newPacketPlayOutChat = PacketPlayOutChat2.getConstructor(this.IChatBaseComponent);
        }
    }

    private void initializeDataWatcher() throws ReflectiveOperationException {
        if (this.minorVersion >= 9) {
            Class<?> DataWatcherObject2 = this.getNMSClass("net.minecraft.network.syncher.DataWatcherObject", "DataWatcherObject");
            this.DataWatcherRegistry = this.getNMSClass("net.minecraft.network.syncher.DataWatcherRegistry", "DataWatcherRegistry");
            Class<?> DataWatcherSerializer = this.getNMSClass("net.minecraft.network.syncher.DataWatcherSerializer", "DataWatcherSerializer");
            this.newDataWatcherObject = DataWatcherObject2.getConstructor(Integer.TYPE, DataWatcherSerializer);
            this.DataWatcherItem_TYPE = this.getFields(this.DataWatcherItem, DataWatcherObject2).get(0);
            this.DataWatcherObject_SLOT = this.getFields(DataWatcherObject2, Integer.TYPE).get(0);
            this.DataWatcherObject_SERIALIZER = this.getFields(DataWatcherObject2, DataWatcherSerializer).get(0);
            this.DataWatcher_REGISTER = this.getMethod(this.DataWatcher, new String[]{"register", "method_12784", "a"}, DataWatcherObject2, Object.class);
        } else {
            this.DataWatcherItem_TYPE = this.getFields(this.DataWatcherItem, Integer.TYPE).get(1);
            this.DataWatcher_REGISTER = this.getMethod(this.DataWatcher, new String[]{"a", "func_75682_a"}, Integer.TYPE, Object.class);
        }
        this.registry = new DataWatcherRegistry(this);
    }

    private void initializeEntityPackets() throws ReflectiveOperationException {
        if (this.minorVersion >= 17 || this.serverVersion.getMinorVersion() >= 17) {
            this.newPacketPlayOutSpawnEntityLiving = this.PacketPlayOutSpawnEntityLiving.getConstructor(this.EntityLiving);
            this.newPacketPlayOutEntityTeleport = this.PacketPlayOutEntityTeleport.getConstructor(this.Entity);
        } else {
            this.newPacketPlayOutSpawnEntityLiving = this.PacketPlayOutSpawnEntityLiving.getConstructor(new Class[0]);
            this.newPacketPlayOutEntityTeleport = this.PacketPlayOutEntityTeleport.getConstructor(new Class[0]);
        }
        if (this.minorVersion >= 17) {
            this.PacketPlayInUseEntity$d = Class.forName("net.minecraft.network.protocol.game.PacketPlayInUseEntity$d");
        }
        try {
            this.newPacketPlayOutEntityDestroy = this.PacketPlayOutEntityDestroy.getConstructor(int[].class);
        }
        catch (NoSuchMethodException e) {
            this.newPacketPlayOutEntityDestroy = this.PacketPlayOutEntityDestroy.getConstructor(Integer.TYPE);
        }
        if (this.minorVersion >= 7) {
            Class<?> EnumEntityUseAction = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayInUseEntity$EnumEntityUseAction", "PacketPlayInUseEntity$EnumEntityUseAction", "EnumEntityUseAction", "net.minecraft.class_2824$class_5906");
            this.PacketPlayInUseEntity_ENTITY = this.getFields(this.PacketPlayInUseEntity, Integer.TYPE).get(0);
            this.PacketPlayInUseEntity_ACTION = this.getFields(this.PacketPlayInUseEntity, EnumEntityUseAction).get(0);
        }
        if (this.minorVersion >= 9) {
            this.PacketPlayOutSpawnEntityLiving_UUID = this.getFields(this.PacketPlayOutSpawnEntityLiving, UUID.class).get(0);
            this.PacketPlayOutSpawnEntityLiving_X = this.getFields(this.PacketPlayOutSpawnEntityLiving, Double.TYPE).get(0);
            this.PacketPlayOutSpawnEntityLiving_Y = this.getFields(this.PacketPlayOutSpawnEntityLiving, Double.TYPE).get(1);
            this.PacketPlayOutSpawnEntityLiving_Z = this.getFields(this.PacketPlayOutSpawnEntityLiving, Double.TYPE).get(2);
            this.PacketPlayOutEntityTeleport_X = this.getFields(this.PacketPlayOutEntityTeleport, Double.TYPE).get(0);
            this.PacketPlayOutEntityTeleport_Y = this.getFields(this.PacketPlayOutEntityTeleport, Double.TYPE).get(1);
            this.PacketPlayOutEntityTeleport_Z = this.getFields(this.PacketPlayOutEntityTeleport, Double.TYPE).get(2);
        } else {
            this.PacketPlayOutSpawnEntityLiving_X = this.getFields(this.PacketPlayOutSpawnEntityLiving, Integer.TYPE).get(2);
            this.PacketPlayOutSpawnEntityLiving_Y = this.getFields(this.PacketPlayOutSpawnEntityLiving, Integer.TYPE).get(3);
            this.PacketPlayOutSpawnEntityLiving_Z = this.getFields(this.PacketPlayOutSpawnEntityLiving, Integer.TYPE).get(4);
            this.PacketPlayOutEntityTeleport_X = this.getFields(this.PacketPlayOutEntityTeleport, Integer.TYPE).get(1);
            this.PacketPlayOutEntityTeleport_Y = this.getFields(this.PacketPlayOutEntityTeleport, Integer.TYPE).get(2);
            this.PacketPlayOutEntityTeleport_Z = this.getFields(this.PacketPlayOutEntityTeleport, Integer.TYPE).get(3);
        }
        if (this.minorVersion <= 14) {
            this.PacketPlayOutSpawnEntityLiving_DATAWATCHER = this.getFields(this.PacketPlayOutSpawnEntityLiving, this.DataWatcher).get(0);
        }
    }

    private void initializeHeaderFooterPacket() throws ReflectiveOperationException {
        if (this.minorVersion < 8) {
            return;
        }
        Class<?> PacketPlayOutPlayerListHeaderFooter2 = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter", "PacketPlayOutPlayerListHeaderFooter");
        this.PacketPlayOutPlayerListHeaderFooter_HEADER = this.getFields(PacketPlayOutPlayerListHeaderFooter2, this.IChatBaseComponent).get(0);
        this.PacketPlayOutPlayerListHeaderFooter_FOOTER = this.getFields(PacketPlayOutPlayerListHeaderFooter2, this.IChatBaseComponent).get(1);
        this.newPacketPlayOutPlayerListHeaderFooter = this.minorVersion >= 17 || this.serverVersion.getMinorVersion() >= 17 ? PacketPlayOutPlayerListHeaderFooter2.getConstructor(this.IChatBaseComponent, this.IChatBaseComponent) : PacketPlayOutPlayerListHeaderFooter2.getConstructor(new Class[0]);
    }

    private void initializePlayerInfoPacket() throws ReflectiveOperationException {
        if (this.minorVersion < 8) {
            return;
        }
        this.PacketPlayOutPlayerInfo = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo", "PacketPlayOutPlayerInfo");
        Class<?> EnumPlayerInfoAction2 = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$EnumPlayerInfoAction", "PacketPlayOutPlayerInfo$EnumPlayerInfoAction", "EnumPlayerInfoAction", "net.minecraft.class_2703$class_5893");
        Class<?> PlayerInfoData2 = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutPlayerInfo$PlayerInfoData", "PacketPlayOutPlayerInfo$PlayerInfoData", "PlayerInfoData");
        Class<?> EnumGamemode2 = this.getNMSClass("net.minecraft.world.level.EnumGamemode", "EnumGamemode", "WorldSettings$EnumGamemode");
        this.newPacketPlayOutPlayerInfo = this.PacketPlayOutPlayerInfo.getConstructor(EnumPlayerInfoAction2, Array.newInstance(this.EntityPlayer, 0).getClass());
        this.newPlayerInfoData = PlayerInfoData2.getConstructors()[0];
        this.PacketPlayOutPlayerInfo_ACTION = this.getFields(this.PacketPlayOutPlayerInfo, EnumPlayerInfoAction2).get(0);
        this.PacketPlayOutPlayerInfo_PLAYERS = this.getFields(this.PacketPlayOutPlayerInfo, List.class).get(0);
        this.PlayerInfoData_getProfile = this.getMethods(PlayerInfoData2, GameProfile.class, new Class[0]).get(0);
        this.PlayerInfoData_getLatency = this.getMethods(PlayerInfoData2, Integer.TYPE, new Class[0]).get(0);
        this.PlayerInfoData_getGamemode = this.getMethods(PlayerInfoData2, EnumGamemode2, new Class[0]).get(0);
        this.PlayerInfoData_getDisplayName = this.getMethods(PlayerInfoData2, this.IChatBaseComponent, new Class[0]).get(0);
        this.EnumPlayerInfoAction_values = this.getEnumValues(EnumPlayerInfoAction2);
        this.EnumGamemode_values = this.getEnumValues(EnumGamemode2);
    }

    private void initializeScoreboardPackets() throws ReflectiveOperationException {
        List<Field> list = this.getFields(this.PacketPlayOutScoreboardObjective, Integer.TYPE);
        this.PacketPlayOutScoreboardObjective_METHOD = list.get(list.size() - 1);
        Class<?> EnumScoreboardAction = null;
        if (this.minorVersion >= 8) {
            this.EnumScoreboardHealthDisplay = this.getNMSClass("net.minecraft.world.scores.criteria.IScoreboardCriteria$EnumScoreboardHealthDisplay", "IScoreboardCriteria$EnumScoreboardHealthDisplay", "EnumScoreboardHealthDisplay");
            this.EnumScoreboardHealthDisplay_values = this.getEnumValues(this.EnumScoreboardHealthDisplay);
            EnumScoreboardAction = this.getNMSClass("net.minecraft.server.ScoreboardServer$Action", "ScoreboardServer$Action", "PacketPlayOutScoreboardScore$EnumScoreboardAction", "EnumScoreboardAction");
            this.EnumScoreboardAction_values = this.getEnumValues(EnumScoreboardAction);
            this.PacketPlayOutScoreboardObjective_RENDERTYPE = this.getFields(this.PacketPlayOutScoreboardObjective, this.EnumScoreboardHealthDisplay).get(0);
        }
        if (this.minorVersion >= 13) {
            this.newPacketPlayOutScoreboardObjective = this.PacketPlayOutScoreboardObjective.getConstructor(this.ScoreboardObjective, Integer.TYPE);
            this.newPacketPlayOutScoreboardScore_1_13 = this.PacketPlayOutScoreboardScore.getConstructor(EnumScoreboardAction, String.class, String.class, Integer.TYPE);
            this.PacketPlayOutScoreboardObjective_DISPLAYNAME = this.getFields(this.PacketPlayOutScoreboardObjective, this.IChatBaseComponent).get(0);
        } else {
            this.newPacketPlayOutScoreboardObjective = this.PacketPlayOutScoreboardObjective.getConstructor(new Class[0]);
            this.newPacketPlayOutScoreboardScore_String = this.PacketPlayOutScoreboardScore.getConstructor(String.class);
            this.PacketPlayOutScoreboardObjective_DISPLAYNAME = this.getFields(this.PacketPlayOutScoreboardObjective, String.class).get(1);
            this.newPacketPlayOutScoreboardScore = this.minorVersion >= 8 ? this.PacketPlayOutScoreboardScore.getConstructor(this.ScoreboardScore) : this.PacketPlayOutScoreboardScore.getConstructor(this.ScoreboardScore, Integer.TYPE);
        }
    }

    private void initializeTeamPackets() throws ReflectiveOperationException {
        this.PacketPlayOutScoreboardTeam = this.getNMSClass("net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam", "PacketPlayOutScoreboardTeam", "Packet209SetScoreboardTeam");
        Class<?> ScoreboardTeam = this.getNMSClass("net.minecraft.world.scores.ScoreboardTeam", "ScoreboardTeam");
        this.newScoreboardTeam = ScoreboardTeam.getConstructor(this.Scoreboard, String.class);
        this.PacketPlayOutScoreboardTeam_NAME = this.getFields(this.PacketPlayOutScoreboardTeam, String.class).get(0);
        this.PacketPlayOutScoreboardTeam_PLAYERS = this.getFields(this.PacketPlayOutScoreboardTeam, Collection.class).get(0);
        this.ScoreboardTeam_getPlayerNameSet = this.getMethods(ScoreboardTeam, Collection.class, new Class[0]).get(0);
        this.ScoreboardTeam_setAllowFriendlyFire = this.getMethod(ScoreboardTeam, new String[]{"setAllowFriendlyFire", "a", "func_96660_a"}, Boolean.TYPE);
        this.ScoreboardTeam_setCanSeeFriendlyInvisibles = this.getMethod(ScoreboardTeam, new String[]{"setCanSeeFriendlyInvisibles", "b", "func_98300_b"}, Boolean.TYPE);
        if (this.minorVersion >= 8) {
            Class<?> EnumNameTagVisibility = this.getNMSClass("net.minecraft.world.scores.ScoreboardTeamBase$EnumNameTagVisibility", "ScoreboardTeamBase$EnumNameTagVisibility", "EnumNameTagVisibility");
            this.EnumNameTagVisibility_values = this.getEnumValues(EnumNameTagVisibility);
            this.ScoreboardTeam_setNameTagVisibility = this.getMethod(ScoreboardTeam, new String[]{"setNameTagVisibility", "a", "method_1149"}, EnumNameTagVisibility);
        }
        if (this.minorVersion >= 9) {
            Class<?> EnumTeamPush = this.getNMSClass("net.minecraft.world.scores.ScoreboardTeamBase$EnumTeamPush", "ScoreboardTeamBase$EnumTeamPush");
            this.EnumTeamPush_values = this.getEnumValues(EnumTeamPush);
            this.ScoreboardTeam_setCollisionRule = this.getMethods(ScoreboardTeam, Void.TYPE, EnumTeamPush).get(0);
        }
        if (this.minorVersion >= 13) {
            this.ScoreboardTeam_setPrefix = this.getMethod(ScoreboardTeam, new String[]{"setPrefix", "method_1138", "b"}, this.IChatBaseComponent);
            this.ScoreboardTeam_setSuffix = this.getMethod(ScoreboardTeam, new String[]{"setSuffix", "method_1139", "c"}, this.IChatBaseComponent);
            this.ScoreboardTeam_setColor = this.getMethods(ScoreboardTeam, Void.TYPE, this.EnumChatFormat).get(0);
        } else {
            this.ScoreboardTeam_setPrefix = this.getMethod(ScoreboardTeam, new String[]{"setPrefix", "func_96666_b"}, String.class);
            this.ScoreboardTeam_setSuffix = this.getMethod(ScoreboardTeam, new String[]{"setSuffix", "func_96662_c"}, String.class);
        }
        if (this.minorVersion >= 17 || this.serverVersion.getMinorVersion() >= 17) {
            Class<?> PacketPlayOutScoreboardTeam_PlayerAction = Class.forName("net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam$a");
            this.PacketPlayOutScoreboardTeam_of = this.getMethods(this.PacketPlayOutScoreboardTeam, this.PacketPlayOutScoreboardTeam, ScoreboardTeam).get(0);
            this.PacketPlayOutScoreboardTeam_ofBoolean = this.getMethods(this.PacketPlayOutScoreboardTeam, this.PacketPlayOutScoreboardTeam, ScoreboardTeam, Boolean.TYPE).get(0);
            this.PacketPlayOutScoreboardTeam_ofString = this.getMethods(this.PacketPlayOutScoreboardTeam, this.PacketPlayOutScoreboardTeam, ScoreboardTeam, String.class, PacketPlayOutScoreboardTeam_PlayerAction).get(0);
            this.PacketPlayOutScoreboardTeam_PlayerAction_values = this.getEnumValues(PacketPlayOutScoreboardTeam_PlayerAction);
        } else {
            this.newPacketPlayOutScoreboardTeam = this.PacketPlayOutScoreboardTeam.getConstructor(ScoreboardTeam, Integer.TYPE);
        }
    }

    private Class<?> getNMSClass(String fullPath_1_17, String ... names) throws ClassNotFoundException {
        if (this.minorVersion >= 17) {
            return Class.forName(fullPath_1_17);
        }
        for (String name : names) {
            try {
                return this.getLegacyClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException("No class found with possible names {modern = " + fullPath_1_17 + ", legacy = " + Arrays.toString(names) + "}");
    }

    private Class<?> getLegacyClass(String name) throws ClassNotFoundException {
        try {
            return Class.forName("net.minecraft.server." + this.serverPackage + "." + name);
        }
        catch (ClassNotFoundException | NullPointerException e) {
            try {
                Class<?> clazz = Main.class.getClassLoader().loadClass("net.minecraft.server." + this.serverPackage + "." + name);
                if (clazz != null) {
                    return clazz;
                }
                throw new ClassNotFoundException(name);
            }
            catch (ClassNotFoundException | NullPointerException e1) {
                return Class.forName(name);
            }
        }
    }

    private Method getMethod(Class<?> clazz, String[] names, Class<?> ... parameterTypes) throws NoSuchMethodException {
        for (String name : names) {
            try {
                return this.getMethod(clazz, name, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Method m : clazz.getMethods()) {
            if (m.getParameterCount() != parameterTypes.length) continue;
            Class<?>[] types = m.getParameterTypes();
            boolean valid = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == parameterTypes[i]) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            list.add(m.getName());
        }
        throw new NoSuchMethodException("No method found with possible names " + Arrays.toString(names) + " with parameters " + Arrays.toString(parameterTypes) + " in class " + clazz.getName() + ". Methods with matching parameters: " + list);
    }

    private Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(name) || m.getParameterCount() != parameterTypes.length) continue;
            Class<?>[] types = m.getParameterTypes();
            boolean valid = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == parameterTypes[i]) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            list.add(m);
        }
        if (!list.isEmpty()) {
            return (Method)list.get(0);
        }
        throw new NoSuchMethodException("No method found with name " + name + " in class " + clazz.getName() + " with parameters " + Arrays.toString(parameterTypes));
    }

    private List<Method> getMethods(Class<?> clazz, Class<?> returnType, Class<?> ... parameterTypes) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Method m : clazz.getDeclaredMethods()) {
            if (m.getReturnType() != returnType || m.getParameterCount() != parameterTypes.length || !Modifier.isPublic(m.getModifiers())) continue;
            Class<?>[] types = m.getParameterTypes();
            boolean valid = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == parameterTypes[i]) continue;
                valid = false;
                break;
            }
            if (!valid) continue;
            list.add(m);
        }
        return list;
    }

    private List<Field> getFields(Class<?> clazz, Class<?> type) {
        if (clazz == null) {
            throw new IllegalArgumentException("Source class cannot be null");
        }
        ArrayList<Field> list = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getType() != type) continue;
            list.add(this.setAccessible(field));
        }
        return list;
    }

    private Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        for (Field f : clazz.getDeclaredFields()) {
            if (!f.getName().equals(name) && (f.getName().split("_").length != 3 || !f.getName().split("_")[2].equals(name))) continue;
            return this.setAccessible(f);
        }
        throw new NoSuchFieldException("Field \"" + name + "\" was not found in class " + clazz.getName());
    }

    private Field getField(Class<?> clazz, String ... potentialNames) throws NoSuchFieldException {
        for (String name : potentialNames) {
            try {
                return this.getField(clazz, name);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        throw new NoSuchFieldException("No field found in class " + clazz.getName() + " with potential names " + Arrays.toString(potentialNames));
    }

    private Enum[] getEnumValues(Class<?> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("Class cannot be null");
        }
        if (!enumClass.isEnum()) {
            throw new IllegalArgumentException(enumClass.getName() + " is not an enum class");
        }
        try {
            return (Enum[])enumClass.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().criticalError("Failed to load enum constants of " + enumClass.getName(), e);
            return new Enum[0];
        }
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setField(Object obj, Field field, Object value) throws IllegalAccessException {
        field.set(obj, value);
    }

    public DataWatcherRegistry getDataWatcherRegistry() {
        return this.registry;
    }

    public <T extends AccessibleObject> T setAccessible(T o) {
        o.setAccessible(true);
        return o;
    }
}

