/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.nms.datawatcher;

import java.util.Optional;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.platforms.bukkit.BukkitPacketBuilder;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcher;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcherObject;
import me.neznamy.tab.platforms.bukkit.nms.datawatcher.DataWatcherRegistry;
import me.neznamy.tab.shared.TAB;

public class DataWatcherHelper {
    private final int armorStandFlagsPosition = this.getArmorStandFlagsPosition();
    private final DataWatcher data;
    private final DataWatcherRegistry registry;

    public DataWatcherHelper(DataWatcher data) {
        this.data = data;
        this.registry = NMSStorage.getInstance().getDataWatcherRegistry();
    }

    private int getArmorStandFlagsPosition() {
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 17) {
            return 15;
        }
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 15) {
            return 14;
        }
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 14) {
            return 13;
        }
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 10) {
            return 11;
        }
        return 10;
    }

    public void setEntityFlags(byte flags) {
        this.data.setValue(new DataWatcherObject(0, this.registry.getByte()), flags);
    }

    public void setCustomName(String customName, ProtocolVersion clientVersion) {
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 13) {
            try {
                this.data.setValue(new DataWatcherObject(2, this.registry.getOptionalComponent()), Optional.ofNullable(((BukkitPacketBuilder)TAB.getInstance().getPlatform().getPacketBuilder()).toNMSComponent(IChatBaseComponent.optimizedComponent(customName), clientVersion)));
            }
            catch (ReflectiveOperationException e) {
                TAB.getInstance().getErrorManager().printError("Failed to create component", e);
            }
        } else if (TAB.getInstance().getServerVersion().getMinorVersion() >= 8) {
            this.data.setValue(new DataWatcherObject(2, this.registry.getString()), customName);
        } else {
            String cutName;
            String string = cutName = customName.length() > 64 ? customName.substring(0, 64) : customName;
            if (TAB.getInstance().getServerVersion().getMinorVersion() >= 6) {
                this.data.setValue(new DataWatcherObject(10, this.registry.getString()), cutName);
            } else {
                this.data.setValue(new DataWatcherObject(5, this.registry.getString()), cutName);
            }
        }
    }

    public void setCustomNameVisible(boolean visible) {
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 9) {
            this.data.setValue(new DataWatcherObject(3, this.registry.getBoolean()), visible);
        } else {
            this.data.setValue(new DataWatcherObject(3, this.registry.getByte()), (byte)(visible ? 1 : 0));
        }
    }

    public void setHealth(float health) {
        if (TAB.getInstance().getServerVersion().getMinorVersion() >= 6) {
            this.data.setValue(new DataWatcherObject(6, this.registry.getFloat()), Float.valueOf(health));
        } else {
            this.data.setValue(new DataWatcherObject(16, this.registry.getInteger()), (int)health);
        }
    }

    public void setArmorStandFlags(byte flags) {
        this.data.setValue(new DataWatcherObject(this.armorStandFlagsPosition, this.registry.getByte()), flags);
    }
}

