/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.nms.datawatcher;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import me.neznamy.tab.platforms.bukkit.nms.NMSStorage;

public class DataWatcherRegistry {
    private Object registryByte;
    private Object registryShort;
    private Object registryInteger;
    private Object registryFloat;
    private Object registryString;
    private Object registryIChatBaseComponent;
    private Object registryOptionalIChatBaseComponent;
    private Object registryOptionalItemStack;
    private Object registryItemStack;
    private Object registryOptionalIBlockData;
    private Object registryBoolean;
    private Object registryParticleParam;
    private Object registryVector3f;
    private Object registryBlockPosition;
    private Object registryOptionalBlockPosition;
    private Object registryEnumDirection;
    private Object registryOptionalUUID;
    private Object registryNBTTagCompound;
    private Object registryVillagerData;
    private Object registryOptionalInt;
    private Object registryEntityPose;

    public DataWatcherRegistry(NMSStorage nms) {
        if (nms.getMinorVersion() >= 9) {
            Map<String, Object> fields = this.getStaticFields(nms.DataWatcherRegistry, nms);
            this.registryByte = fields.get("a");
            this.registryInteger = fields.get("b");
            this.registryFloat = fields.get("c");
            this.registryString = fields.get("d");
            this.registryIChatBaseComponent = fields.get("e");
            if (nms.getMinorVersion() >= 13) {
                this.registryOptionalIChatBaseComponent = fields.get("f");
                this.registryItemStack = fields.get("g");
                this.registryOptionalIBlockData = fields.get("h");
                this.registryBoolean = fields.get("i");
                this.registryParticleParam = fields.get("j");
                this.registryVector3f = fields.get("k");
                this.registryBlockPosition = fields.get("l");
                this.registryOptionalBlockPosition = fields.get("m");
                this.registryEnumDirection = fields.get("n");
                this.registryOptionalUUID = fields.get("o");
                this.registryNBTTagCompound = fields.get("p");
                if (nms.getMinorVersion() >= 15) {
                    this.registryVillagerData = fields.get("q");
                    this.registryOptionalInt = fields.get("r");
                    this.registryEntityPose = fields.get("s");
                }
            } else {
                this.registryOptionalIBlockData = fields.get("g");
                this.registryBoolean = fields.get("h");
                this.registryVector3f = fields.get("i");
                this.registryBlockPosition = fields.get("j");
                this.registryOptionalBlockPosition = fields.get("k");
                this.registryEnumDirection = fields.get("l");
                this.registryOptionalUUID = fields.get("m");
                if (nms.getMinorVersion() >= 12) {
                    this.registryNBTTagCompound = fields.get("n");
                }
                if (nms.getMinorVersion() >= 11) {
                    this.registryItemStack = fields.get("f");
                } else {
                    this.registryOptionalItemStack = fields.get("f");
                }
            }
        }
    }

    private Map<String, Object> getStaticFields(Class<?> clazz, NMSStorage nms) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            nms.setAccessible(field);
            try {
                fields.put(field.getName(), field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return fields;
    }

    public Object getByte() {
        return this.registryByte;
    }

    public Object getShort() {
        return this.registryShort;
    }

    public Object getInteger() {
        return this.registryInteger;
    }

    public Object getFloat() {
        return this.registryFloat;
    }

    public Object getString() {
        return this.registryString;
    }

    public Object getComponent() {
        return this.registryIChatBaseComponent;
    }

    public Object getOptionalComponent() {
        return this.registryOptionalIChatBaseComponent;
    }

    public Object getOptionalItemStack() {
        return this.registryOptionalItemStack;
    }

    public Object getItemStack() {
        return this.registryItemStack;
    }

    public Object getOptionalIBlockData() {
        return this.registryOptionalIBlockData;
    }

    public Object getBoolean() {
        return this.registryBoolean;
    }

    public Object getParticleParam() {
        return this.registryParticleParam;
    }

    public Object getVector3f() {
        return this.registryVector3f;
    }

    public Object getBlockPosition() {
        return this.registryBlockPosition;
    }

    public Object getOptionalBlockPosition() {
        return this.registryOptionalBlockPosition;
    }

    public Object getEnumDirection() {
        return this.registryEnumDirection;
    }

    public Object getOptionalUUID() {
        return this.registryOptionalUUID;
    }

    public Object getNBTTagCompound() {
        return this.registryNBTTagCompound;
    }

    public Object getVillagerData() {
        return this.registryVillagerData;
    }

    public Object getOptionalInt() {
        return this.registryOptionalInt;
    }

    public Object getEntityPose() {
        return this.registryEntityPose;
    }
}

