/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.redisbungee.RedisBungeeSupport;
import me.neznamy.tab.platforms.bungeecord.redisbungee.RedisPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.NickCompatibility;
import me.neznamy.tab.shared.features.PipelineInjector;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.Team;

public class BungeePipelineInjector
extends PipelineInjector {
    private final Map<Class<? extends DefinedPacket>, Supplier<DefinedPacket>> extraPackets = new HashMap<Class<? extends DefinedPacket>, Supplier<DefinedPacket>>();

    public BungeePipelineInjector() {
        super("inbound-boss");
        this.channelFunction = x$0 -> new BungeeChannelDuplexHandler((TabPlayer)x$0);
        this.extraPackets.put(Team.class, Team::new);
        this.extraPackets.put(ScoreboardDisplay.class, ScoreboardDisplay::new);
        this.extraPackets.put(ScoreboardObjective.class, ScoreboardObjective::new);
    }

    public class BungeeChannelDuplexHandler
    extends ChannelDuplexHandler {
        private final TabPlayer player;

        public BungeeChannelDuplexHandler(TabPlayer player) {
            this.player = player;
        }

        public void write(ChannelHandlerContext context, Object packet, ChannelPromise channelPromise) {
            long time = System.nanoTime();
            Object modifiedPacket = packet instanceof ByteBuf && BungeePipelineInjector.this.byteBufDeserialization ? this.deserialize((ByteBuf)packet) : packet;
            TAB.getInstance().getCPUManager().addTime("Packet deserializing", "ByteBuf", System.nanoTime() - time);
            try {
                switch (modifiedPacket.getClass().getSimpleName()) {
                    case "PlayerListItem": {
                        super.write(context, TAB.getInstance().getFeatureManager().onPacketPlayOutPlayerInfo(this.player, modifiedPacket), channelPromise);
                        return;
                    }
                    case "Team": {
                        if (!BungeePipelineInjector.this.antiOverrideTeams) break;
                        this.modifyPlayers((Team)modifiedPacket);
                        break;
                    }
                    case "ScoreboardDisplay": {
                        TAB.getInstance().getFeatureManager().onDisplayObjective(this.player, modifiedPacket);
                        break;
                    }
                    case "ScoreboardObjective": {
                        TAB.getInstance().getFeatureManager().onObjective(this.player, modifiedPacket);
                        break;
                    }
                    case "Login": {
                        super.write(context, modifiedPacket, channelPromise);
                        TAB.getInstance().getFeatureManager().onLoginPacket(this.player);
                        return;
                    }
                }
            }
            catch (Exception e) {
                TAB.getInstance().getErrorManager().printError("An error occurred when analyzing packets for player " + this.player.getName() + " with client version " + this.player.getVersion().getFriendlyName(), e);
            }
            try {
                super.write(context, modifiedPacket, channelPromise);
            }
            catch (Exception e) {
                TAB.getInstance().getErrorManager().printError("Failed to forward packet " + modifiedPacket.getClass().getSimpleName() + " to " + this.player.getName(), e);
            }
        }

        private void modifyPlayers(Team packet) {
            long time = System.nanoTime();
            if (packet.getPlayers() == null) {
                return;
            }
            ArrayList col = Lists.newArrayList((Object[])packet.getPlayers());
            for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                if (!col.contains(this.getName(p)) || ((TabFeature)((Object)TAB.getInstance().getTeamManager())).isDisabledPlayer(p) || TAB.getInstance().getTeamManager().hasTeamHandlingPaused(p) || packet.getName().equals(p.getTeamName())) continue;
                BungeePipelineInjector.this.logTeamOverride(packet.getName(), p.getName(), p.getTeamName());
                col.remove(this.getName(p));
            }
            RedisBungeeSupport redis = (RedisBungeeSupport)TAB.getInstance().getFeatureManager().getFeature("RedisBungee");
            if (redis != null) {
                for (RedisPlayer p : redis.getRedisPlayers().values()) {
                    if (!col.contains(p.getName()) || packet.getName().equals(p.getTeamName())) continue;
                    BungeePipelineInjector.this.logTeamOverride(packet.getName(), p.getName(), p.getTeamName());
                    col.remove(p.getName());
                }
            }
            packet.setPlayers(col.toArray(new String[0]));
            TAB.getInstance().getCPUManager().addTime("NameTags", "Anti override", System.nanoTime() - time);
        }

        private String getName(TabPlayer p) {
            NickCompatibility nick = (NickCompatibility)TAB.getInstance().getFeatureManager().getFeature("nick");
            if (nick != null) {
                return nick.getNickname(p);
            }
            return p.getName();
        }

        private Object deserialize(ByteBuf buf) {
            int marker = buf.readerIndex();
            try {
                byte packetId = buf.readByte();
                for (Map.Entry e : BungeePipelineInjector.this.extraPackets.entrySet()) {
                    if (packetId != ((BungeeTabPlayer)this.player).getPacketId((Class)e.getKey())) continue;
                    DefinedPacket packet = (DefinedPacket)((Supplier)e.getValue()).get();
                    packet.read(buf, null, ((ProxiedPlayer)this.player.getPlayer()).getPendingConnection().getVersion());
                    buf.release();
                    return packet;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.readerIndex(marker);
            return buf;
        }
    }
}

