/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import java.io.File;
import java.util.List;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.protocol.PacketBuilder;
import me.neznamy.tab.platforms.bungeecord.BungeePacketBuilder;
import me.neznamy.tab.platforms.bungeecord.BungeePipelineInjector;
import me.neznamy.tab.platforms.bungeecord.BungeePlaceholderRegistry;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.platforms.bungeecord.event.TabLoadEvent;
import me.neznamy.tab.platforms.bungeecord.event.TabPlayerLoadEvent;
import me.neznamy.tab.platforms.bungeecord.redisbungee.RedisBungeeSupport;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PluginMessageHandler;
import me.neznamy.tab.shared.permission.LuckPerms;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import me.neznamy.tab.shared.permission.UltraPermissions;
import me.neznamy.tab.shared.permission.VaultBridge;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Plugin;

public class BungeePlatform
extends ProxyPlatform {
    private final Plugin plugin;
    private final BungeePacketBuilder packetBuilder = new BungeePacketBuilder();

    public BungeePlatform(Plugin plugin, PluginMessageHandler plm) {
        super(plm);
        this.plugin = plugin;
    }

    @Override
    public PermissionPlugin detectPermissionPlugin() {
        if (TAB.getInstance().getConfiguration().isBukkitPermissions()) {
            return new VaultBridge(this.plm);
        }
        if (ProxyServer.getInstance().getPluginManager().getPlugin("LuckPerms") != null) {
            return new LuckPerms(ProxyServer.getInstance().getPluginManager().getPlugin("LuckPerms").getDescription().getVersion());
        }
        if (ProxyServer.getInstance().getPluginManager().getPlugin("UltraPermissions") != null) {
            return new UltraPermissions(ProxyServer.getInstance().getPluginManager().getPlugin("UltraPermissions").getDescription().getVersion());
        }
        return new VaultBridge(this.plm);
    }

    @Override
    public void loadFeatures() {
        TAB tab = TAB.getInstance();
        if (tab.getConfiguration().isPipelineInjection()) {
            tab.getFeatureManager().registerFeature("injection", new BungeePipelineInjector());
        }
        new BungeePlaceholderRegistry().registerPlaceholders(tab.getPlaceholderManager());
        super.loadFeatures();
        if (ProxyServer.getInstance().getPluginManager().getPlugin("RedisBungee") != null) {
            if (RedisBungeeAPI.getRedisBungeeApi() != null) {
                tab.getFeatureManager().registerFeature("RedisBungee", new RedisBungeeSupport(this.plugin));
            } else {
                TAB.getInstance().getErrorManager().criticalError("RedisBungee plugin was detected, but it returned null API instance. Disabling hook.", null);
            }
        }
        for (ProxiedPlayer p : ProxyServer.getInstance().getPlayers()) {
            tab.addPlayer(new BungeeTabPlayer(p));
        }
    }

    @Override
    public void sendConsoleMessage(String message, boolean translateColors) {
        ProxyServer.getInstance().getConsole().sendMessage((BaseComponent)new TextComponent(translateColors ? EnumChatFormat.color(message) : message));
    }

    @Override
    public String getServerVersion() {
        return ProxyServer.getInstance().getVersion();
    }

    @Override
    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    @Override
    public void callLoadEvent() {
        ProxyServer.getInstance().getPluginManager().callEvent((Event)new TabLoadEvent());
    }

    @Override
    public void callLoadEvent(TabPlayer player) {
        ProxyServer.getInstance().getPluginManager().callEvent((Event)new TabPlayerLoadEvent(player));
    }

    @Override
    public int getMaxPlayers() {
        return ((ListenerInfo)ProxyServer.getInstance().getConfigurationAdapter().getListeners().iterator().next()).getMaxPlayers();
    }

    @Override
    public PacketBuilder getPacketBuilder() {
        return this.packetBuilder;
    }

    @Override
    public Object getSkin(List<String> properties) {
        String[][] array = new String[1][3];
        array[0][0] = "textures";
        array[0][1] = properties.get(0);
        array[0][2] = properties.get(1);
        return array;
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public boolean isPluginEnabled(String plugin) {
        return ProxyServer.getInstance().getPluginManager().getPlugin(plugin) != null;
    }
}

