/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord;

import com.google.common.io.ByteStreams;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.bungeecord.BungeeTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PluginMessageHandler;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class BungeePluginMessageHandler
extends PluginMessageHandler
implements Listener {
    public BungeePluginMessageHandler(Plugin plugin) {
        ProxyServer.getInstance().registerChannel("tab:placeholders");
        ProxyServer.getInstance().getPluginManager().registerListener(plugin, (Listener)this);
    }

    @EventHandler
    public void on(PluginMessageEvent event) {
        if (!event.getTag().equals("tab:placeholders")) {
            return;
        }
        if (event.getReceiver() instanceof ProxiedPlayer) {
            event.setCancelled(true);
            TAB.getInstance().getCPUManager().runMeasuredTask("processing PluginMessageEvent", "Plugin message handling", "PluginMessageEvent", () -> {
                BungeeTabPlayer receiver = (BungeeTabPlayer)TAB.getInstance().getPlayer(((ProxiedPlayer)event.getReceiver()).getUniqueId());
                if (receiver == null) {
                    return;
                }
                this.onPluginMessage(receiver, ByteStreams.newDataInput((byte[])event.getData()));
            });
        }
    }

    @Override
    public void sendPluginMessage(TabPlayer player, byte[] message) {
        if (((ProxiedPlayer)player.getPlayer()).getServer() == null) {
            return;
        }
        ((ProxiedPlayer)player.getPlayer()).getServer().sendData("tab:placeholders", message);
        TAB.getInstance().getCPUManager().packetSent("Plugin Message (" + new String(message) + ")");
    }
}

