/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bungeecord.redisbungee;

import com.imaginarycode.minecraft.redisbungee.RedisBungeeAPI;
import com.imaginarycode.minecraft.redisbungee.events.PubSubMessageEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutScoreboardTeam;
import me.neznamy.tab.api.protocol.TabPacket;
import me.neznamy.tab.libs.org.json.simple.JSONObject;
import me.neznamy.tab.libs.org.json.simple.parser.JSONParser;
import me.neznamy.tab.libs.org.json.simple.parser.ParseException;
import me.neznamy.tab.platforms.bungeecord.redisbungee.RedisPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.RedisSupport;
import me.neznamy.tab.shared.features.globalplayerlist.GlobalPlayerList;
import me.neznamy.tab.shared.features.nametags.NameTag;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.event.EventHandler;

public class RedisBungeeSupport
extends TabFeature
implements RedisSupport,
Listener {
    private static final String CHANNEL_NAME = "TAB";
    private final Map<String, RedisPlayer> redisPlayers = new ConcurrentHashMap<String, RedisPlayer>();
    private final GlobalPlayerList global = (GlobalPlayerList)TAB.getInstance().getFeatureManager().getFeature("GlobalPlayerList");
    private final PlayerList playerlist = (PlayerList)TAB.getInstance().getFeatureManager().getFeature("PlayerList");
    private final NameTag nametags = (NameTag)TAB.getInstance().getFeatureManager().getFeature("NameTag16");
    private final UUID proxy = UUID.randomUUID();

    public RedisBungeeSupport(Plugin plugin) {
        super("RedisBungee", null);
        ProxyServer.getInstance().getPluginManager().registerListener(plugin, (Listener)this);
        RedisBungeeAPI.getRedisBungeeApi().registerPubSubChannels(new String[]{CHANNEL_NAME});
        this.overridePlaceholders();
    }

    private void overridePlaceholders() {
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%online%", 2000, p -> {
            int count = 0;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (all.isVanished() && !p.hasPermission("tab.seevanished")) continue;
                ++count;
            }
            for (RedisPlayer all : this.redisPlayers.values()) {
                if (all.isVanished() && !p.hasPermission("tab.seevanished")) continue;
                ++count;
            }
            return count;
        });
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%staffonline%", 2000, p -> {
            int count = 0;
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                if (!all.hasPermission("tab.staff") || all.isVanished() && !p.hasPermission("tab.seevanished")) continue;
                ++count;
            }
            for (RedisPlayer all : this.redisPlayers.values()) {
                if (!all.isStaff() || all.isVanished() && !p.hasPermission("tab.seevanished")) continue;
                ++count;
            }
            return count;
        });
        for (Map.Entry server : ProxyServer.getInstance().getServers().entrySet()) {
            TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%online_" + (String)server.getKey() + "%", 1000, () -> {
                int count = 0;
                for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
                    if (!p.getServer().equals(((ServerInfo)server.getValue()).getName()) || p.isVanished()) continue;
                    ++count;
                }
                for (RedisPlayer p : this.redisPlayers.values()) {
                    if (!p.getServer().equals(((ServerInfo)server.getValue()).getName()) || p.isVanished()) continue;
                    ++count;
                }
                return count;
            });
        }
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, "{\"action\":\"loadrequest\",\"proxy\":\"" + this.proxy.toString() + "\"}");
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onQuit(p);
        }
        RedisBungeeAPI.getRedisBungeeApi().unregisterPubSubChannels(new String[]{CHANNEL_NAME});
        ProxyServer.getInstance().getPluginManager().unregisterListener((Listener)this);
    }

    @EventHandler
    public void onMessage(PubSubMessageEvent e) {
        if (!e.getChannel().equals(CHANNEL_NAME)) {
            return;
        }
        TAB.getInstance().getCPUManager().runMeasuredTask("processing PubSubMessageEvent", this, "PubSubMessageEvent", () -> {
            JSONObject message;
            try {
                message = (JSONObject)new JSONParser().parse(e.getMessage());
            }
            catch (ParseException ex) {
                TAB.getInstance().getErrorManager().printError("Failed to parse json message \"" + e.getMessage() + "\"", ex);
                return;
            }
            if (message.get("proxy").equals(this.proxy.toString())) {
                return;
            }
            String action = (String)message.get("action");
            UUID id = UUID.fromString(message.getOrDefault("UUID", this.proxy.toString()));
            switch (action) {
                case "loadrequest": {
                    JSONObject json = new JSONObject();
                    json.put("proxy", this.proxy.toString());
                    json.put("action", "load");
                    ArrayList<JSONObject> players = new ArrayList<JSONObject>();
                    for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                        players.add(RedisPlayer.toJson(this, all));
                    }
                    json.put("players", players);
                    RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, json.toString());
                    break;
                }
                case "load": {
                    List players1 = (List)message.get("players");
                    for (JSONObject obj : players1) {
                        RedisPlayer p = RedisPlayer.fromJson(this, obj);
                        if (this.redisPlayers.containsKey(p.getUniqueId().toString())) continue;
                        this.redisPlayers.put(p.getUniqueId().toString(), p);
                        this.join(p);
                    }
                    break;
                }
                case "join": {
                    RedisPlayer target = RedisPlayer.fromJson(this, message);
                    this.redisPlayers.put(id.toString(), target);
                    this.join(target);
                    break;
                }
                case "server": {
                    RedisPlayer target = this.redisPlayers.get(id.toString());
                    if (target == null) break;
                    String server = (String)message.get("server");
                    if (this.global == null) {
                        target.setServer(server);
                        return;
                    }
                    for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                        if (viewer.getVersion().getMinorVersion() < 8) continue;
                        boolean before = this.shouldSee(viewer, target.getServer(), target.isVanished());
                        boolean after = this.shouldSee(viewer, server, target.isVanished());
                        if (!before && after) {
                            viewer.sendCustomPacket((TabPacket)target.getAddPacket(), this);
                        }
                        if (!before || after) continue;
                        viewer.sendCustomPacket((TabPacket)target.getRemovePacket(), this);
                    }
                    target.setServer(server);
                    break;
                }
                case "tabformat": {
                    RedisPlayer target = this.redisPlayers.get(id.toString());
                    if (target == null) break;
                    target.setTabFormat((String)message.get("tabformat"));
                    for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                        if (viewer.getVersion().getMinorVersion() < 8) continue;
                        viewer.sendCustomPacket((TabPacket)target.getUpdatePacket(), this);
                    }
                    break;
                }
                case "nametag": {
                    RedisPlayer target = this.redisPlayers.get(id.toString());
                    if (target == null) break;
                    target.setTagPrefix((String)message.get("tagprefix"));
                    target.setTagSuffix((String)message.get("tagsuffix"));
                    for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                        viewer.sendCustomPacket((TabPacket)target.getUpdateTeamPacket(), this);
                    }
                    break;
                }
                case "belowname": {
                    RedisPlayer target = this.redisPlayers.get(id.toString());
                    if (target == null) break;
                    target.setBelowName((String)message.get("belowname"));
                    for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                        viewer.sendCustomPacket((TabPacket)target.getBelowNameUpdatePacket(), this);
                    }
                    break;
                }
                case "yellow-number": {
                    RedisPlayer target = this.redisPlayers.get(id.toString());
                    if (target == null) break;
                    target.setYellowNumber((String)message.get("yellow-number"));
                    for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                        viewer.sendCustomPacket((TabPacket)target.getYellowNumberUpdatePacket(), this);
                    }
                    break;
                }
                case "team": {
                    RedisPlayer target = this.redisPlayers.get(id.toString());
                    if (target == null) break;
                    PacketPlayOutScoreboardTeam unregister = target.getUnregisterTeamPacket();
                    target.setTeamName((String)message.get("to"));
                    PacketPlayOutScoreboardTeam register = target.getRegisterTeamPacket();
                    for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
                        viewer.sendCustomPacket((TabPacket)unregister, this);
                        viewer.sendCustomPacket((TabPacket)register, this);
                    }
                    break;
                }
                case "quit": {
                    RedisPlayer target = this.redisPlayers.get(id.toString());
                    if (target == null) break;
                    for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                        all.sendCustomPacket((TabPacket)target.getUnregisterTeamPacket(), this);
                        if (all.getVersion().getMinorVersion() < 8) continue;
                        all.sendCustomPacket((TabPacket)target.getRemovePacket(), this);
                    }
                    this.redisPlayers.remove(id.toString());
                    break;
                }
            }
        });
    }

    private void join(RedisPlayer target) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            all.sendCustomPacket((TabPacket)target.getRegisterTeamPacket(), this);
            all.sendCustomPacket((TabPacket)target.getBelowNameUpdatePacket(), this);
            all.sendCustomPacket((TabPacket)target.getYellowNumberUpdatePacket(), this);
            if (all.getVersion().getMinorVersion() < 8) continue;
            if (this.global == null) {
                if (!all.getServer().equals(target.getServer())) continue;
                all.sendCustomPacket((TabPacket)target.getUpdatePacket(), this);
                continue;
            }
            if (!this.shouldSee(all, target.getServer(), target.isVanished())) continue;
            if (!all.getServer().equals(target.getServer())) {
                all.sendCustomPacket((TabPacket)target.getAddPacket(), this);
                continue;
            }
            all.sendCustomPacket((TabPacket)target.getUpdatePacket(), this);
        }
    }

    private boolean shouldSee(TabPlayer viewer, String server, boolean targetVanished) {
        return this.shouldSee(viewer, viewer.getServer(), server, targetVanished);
    }

    private boolean shouldSee(TabPlayer viewer, String viewerServer, String server, boolean targetVanished) {
        if (targetVanished && !viewer.hasPermission("tab.seevanished")) {
            return false;
        }
        if (this.global.getSpyServers().contains(viewerServer)) {
            return true;
        }
        return this.global.getServerGroup(viewerServer).equals(this.global.getServerGroup(server));
    }

    @Override
    public void onJoin(TabPlayer p) {
        JSONObject obj = RedisPlayer.toJson(this, p);
        obj.put("proxy", this.proxy.toString());
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, obj.toString());
        for (RedisPlayer redis : this.redisPlayers.values()) {
            p.sendCustomPacket((TabPacket)redis.getRegisterTeamPacket(), this);
            p.sendCustomPacket((TabPacket)redis.getBelowNameUpdatePacket(), this);
            p.sendCustomPacket((TabPacket)redis.getYellowNumberUpdatePacket(), this);
            if (this.global == null || !this.shouldSee(p, redis.getServer(), redis.isVanished())) continue;
            if (!p.getServer().equals(redis.getServer())) {
                p.sendCustomPacket((TabPacket)redis.getAddPacket(), this);
                continue;
            }
            p.sendCustomPacket((TabPacket)redis.getUpdatePacket(), this);
        }
    }

    @Override
    public void onServerChange(TabPlayer p, String from, String to) {
        JSONObject json = new JSONObject();
        json.put("proxy", this.proxy.toString());
        json.put("action", "server");
        json.put("UUID", p.getTablistUUID().toString());
        json.put("server", to);
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, json.toString());
        if (p.getVersion().getMinorVersion() < 8 || this.global == null) {
            return;
        }
        for (RedisPlayer redis : this.redisPlayers.values()) {
            boolean before = this.shouldSee(p, from, redis.getServer(), redis.isVanished());
            boolean after = this.shouldSee(p, to, redis.getServer(), redis.isVanished());
            if (!before && after) {
                p.sendCustomPacket((TabPacket)redis.getAddPacket(), this);
            }
            if (!before || after) continue;
            p.sendCustomPacket((TabPacket)redis.getRemovePacket(), this);
        }
    }

    @Override
    public void onQuit(TabPlayer p) {
        JSONObject json = new JSONObject();
        json.put("proxy", this.proxy.toString());
        json.put("action", "quit");
        json.put("UUID", p.getTablistUUID().toString());
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, json.toString());
    }

    @Override
    public void updateTabFormat(TabPlayer p, String format) {
        JSONObject json = new JSONObject();
        json.put("proxy", this.proxy.toString());
        json.put("action", "tabformat");
        json.put("UUID", p.getTablistUUID().toString());
        json.put("tabformat", format);
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, json.toString());
    }

    @Override
    public void updateNameTag(TabPlayer p, String tagprefix, String tagsuffix) {
        JSONObject json = new JSONObject();
        json.put("proxy", this.proxy.toString());
        json.put("action", "nametag");
        json.put("UUID", p.getTablistUUID().toString());
        json.put("tagprefix", tagprefix);
        json.put("tagsuffix", tagsuffix);
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, json.toString());
    }

    @Override
    public void updateBelowName(TabPlayer p, String value) {
        JSONObject json = new JSONObject();
        json.put("proxy", this.proxy.toString());
        json.put("action", "belowname");
        json.put("UUID", p.getTablistUUID().toString());
        json.put("belowname", value);
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, json.toString());
    }

    @Override
    public void updateYellowNumber(TabPlayer p, String value) {
        JSONObject json = new JSONObject();
        json.put("proxy", this.proxy.toString());
        json.put("action", "yellow-number");
        json.put("UUID", p.getTablistUUID().toString());
        json.put("yellow-number", value);
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, json.toString());
    }

    @Override
    public void updateTeamName(TabPlayer p, String to) {
        JSONObject json = new JSONObject();
        json.put("proxy", this.proxy.toString());
        json.put("action", "team");
        json.put("UUID", p.getTablistUUID().toString());
        json.put("to", to);
        RedisBungeeAPI.getRedisBungeeApi().sendChannelMessage(CHANNEL_NAME, json.toString());
    }

    @Override
    public void onPlayerInfo(TabPlayer receiver, PacketPlayOutPlayerInfo info) {
        RedisPlayer packetPlayer;
        if (info.getAction() == PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER && this.global != null) {
            for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData : info.getEntries()) {
                packetPlayer = this.redisPlayers.get(playerInfoData.getUniqueId().toString());
                if (packetPlayer == null || playerInfoData.getName() != null && playerInfoData.getName().length() != 0 || packetPlayer.isVanished()) continue;
                playerInfoData.setUniqueId(UUID.randomUUID());
            }
        }
        if (info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.UPDATE_DISPLAY_NAME && info.getAction() != PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER) {
            return;
        }
        for (PacketPlayOutPlayerInfo.PlayerInfoData playerInfoData : info.getEntries()) {
            packetPlayer = this.redisPlayers.get(playerInfoData.getUniqueId().toString());
            if (packetPlayer == null || packetPlayer.hasDisabledPlayerlist()) continue;
            playerInfoData.setDisplayName(IChatBaseComponent.optimizedComponent(packetPlayer.getTabFormat()));
        }
    }

    @Override
    public void onLoginPacket(TabPlayer packetReceiver) {
        for (RedisPlayer p : this.redisPlayers.values()) {
            for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
                all.sendCustomPacket(p.getRegisterTeamPacket());
            }
        }
    }

    public Map<String, RedisPlayer> getRedisPlayers() {
        return this.redisPlayers;
    }

    public PlayerList getPlayerlist() {
        return this.playerlist;
    }

    public NameTag getNametags() {
        return this.nametags;
    }
}

