/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.krypton;

import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.protocol.PacketBuilder;
import me.neznamy.tab.platforms.krypton.KryptonPacketBuilder;
import me.neznamy.tab.platforms.krypton.KryptonPipelineInjector;
import me.neznamy.tab.platforms.krypton.KryptonPlaceholderRegistry;
import me.neznamy.tab.platforms.krypton.KryptonTabPlayer;
import me.neznamy.tab.platforms.krypton.Main;
import me.neznamy.tab.platforms.krypton.features.PerWorldPlayerList;
import me.neznamy.tab.platforms.krypton.features.unlimitedtags.NameTagX;
import me.neznamy.tab.shared.Platform;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.permission.LuckPerms;
import me.neznamy.tab.shared.permission.None;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import me.neznamy.tab.shared.placeholders.UniversalPlaceholderRegistry;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.kryptonmc.api.Server;
import org.kryptonmc.api.auth.ProfileProperty;
import org.kryptonmc.api.entity.player.Player;
import org.kryptonmc.api.plugin.PluginContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J\b\u0010\u001f\u001a\u00020\nH\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lme/neznamy/tab/platforms/krypton/KryptonPlatform;", "Lme/neznamy/tab/shared/Platform;", "plugin", "Lme/neznamy/tab/platforms/krypton/Main;", "folder", "Ljava/io/File;", "(Lme/neznamy/tab/platforms/krypton/Main;Ljava/io/File;)V", "server", "Lorg/kryptonmc/api/Server;", "callLoadEvent", "", "player", "Lme/neznamy/tab/api/TabPlayer;", "detectPermissionPlugin", "Lme/neznamy/tab/shared/permission/PermissionPlugin;", "getConfigName", "", "getDataFolder", "getMaxPlayers", "", "getPacketBuilder", "Lme/neznamy/tab/api/protocol/PacketBuilder;", "getServerVersion", "getSkin", "", "properties", "", "isPluginEnabled", "", "isProxy", "loadFeatures", "loadNametagFeature", "registerUnknownPlaceholder", "identifier", "sendConsoleMessage", "message", "translateColors", "krypton"})
public final class KryptonPlatform
implements Platform {
    @NotNull
    private final Main plugin;
    @NotNull
    private final File folder;
    @NotNull
    private final Server server;

    public KryptonPlatform(@NotNull Main plugin, @NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.plugin = plugin;
        this.folder = folder;
        this.server = this.plugin.getServer();
    }

    @Override
    @NotNull
    public PermissionPlugin detectPermissionPlugin() {
        if (this.isPluginEnabled("luckperms")) {
            PluginContainer pluginContainer = this.server.pluginManager().plugin("luckperms");
            Intrinsics.checkNotNull((Object)pluginContainer);
            return new LuckPerms(pluginContainer.description().version());
        }
        return new None();
    }

    @Override
    public void loadFeatures() {
        if (TAB.getInstance().getConfiguration().isPipelineInjection()) {
            TAB.getInstance().getFeatureManager().registerFeature("injection", new KryptonPipelineInjector());
        }
        KryptonPlaceholderRegistry kryptonPlaceholderRegistry = new KryptonPlaceholderRegistry(this.plugin);
        PlaceholderManagerImpl placeholderManagerImpl = TAB.getInstance().getPlaceholderManager();
        Intrinsics.checkNotNullExpressionValue((Object)placeholderManagerImpl, (String)"getInstance().placeholderManager");
        kryptonPlaceholderRegistry.registerPlaceholders(placeholderManagerImpl);
        new UniversalPlaceholderRegistry().registerPlaceholders(TAB.getInstance().getPlaceholderManager());
        this.loadNametagFeature();
        TAB.getInstance().loadUniversalFeatures();
        if (TAB.getInstance().getConfig().getBoolean("bossbar.enabled", false)) {
            TAB.getInstance().getFeatureManager().registerFeature("BossBar", new BossBarManagerImpl());
        }
        if (TAB.getInstance().getConfig().getBoolean("per-world-playerlist.enabled", false)) {
            TAB.getInstance().getFeatureManager().registerFeature("PerWorldPlayerList", new PerWorldPlayerList(this.plugin));
        }
        Iterable $this$forEach$iv = this.server.players();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            TAB.getInstance().addPlayer(new KryptonTabPlayer(it, this.plugin.protocolVersion(it)));
        }
    }

    @Override
    public void sendConsoleMessage(@NotNull String message, boolean translateColors) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        TextComponent textComponent = translateColors ? LegacyComponentSerializer.legacyAmpersand().deserialize(message) : Component.text((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)textComponent, (String)"if (translateColors) Leg\u2026e Component.text(message)");
        TextComponent component = textComponent;
        this.server.console().sendMessage((Component)component);
    }

    @Override
    public void registerUnknownPlaceholder(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        PlaceholderManagerImpl manager = TAB.getInstance().getPlaceholderManager();
        if (StringsKt.startsWith$default((String)identifier, (String)"%rel_", (boolean)false, (int)2, null)) {
            manager.registerRelationalPlaceholder(identifier, manager.getRelationalRefresh(identifier), KryptonPlatform::registerUnknownPlaceholder$lambda-1);
            return;
        }
        Map<String, Integer> serverIntervals = manager.getServerPlaceholderRefreshIntervals();
        Map<String, Integer> playerIntervals = manager.getPlayerPlaceholderRefreshIntervals();
        if (serverIntervals.containsKey(identifier)) {
            Integer n = serverIntervals.get(identifier);
            Intrinsics.checkNotNull((Object)n);
            manager.registerServerPlaceholder(identifier, ((Number)n).intValue(), () -> KryptonPlatform.registerUnknownPlaceholder$lambda-2(identifier));
            return;
        }
        if (playerIntervals.containsKey(identifier)) {
            Integer n = playerIntervals.get(identifier);
            Intrinsics.checkNotNull((Object)n);
            manager.registerPlayerPlaceholder(identifier, ((Number)n).intValue(), arg_0 -> KryptonPlatform.registerUnknownPlaceholder$lambda-3(identifier, arg_0));
            return;
        }
        manager.registerPlayerPlaceholder(identifier, manager.getDefaultRefresh(), arg_0 -> KryptonPlatform.registerUnknownPlaceholder$lambda-4(identifier, arg_0));
    }

    @Override
    @NotNull
    public String getServerVersion() {
        return this.server.platform().name() + " " + this.server.platform().version();
    }

    @Override
    @NotNull
    public File getDataFolder() {
        return this.folder;
    }

    @Override
    public void callLoadEvent() {
    }

    @Override
    public void callLoadEvent(@NotNull TabPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    @Override
    public int getMaxPlayers() {
        return this.server.maxPlayers();
    }

    @Override
    @NotNull
    public PacketBuilder getPacketBuilder() {
        return KryptonPacketBuilder.INSTANCE;
    }

    @Override
    @NotNull
    public Object getSkin(@NotNull List<String> properties) {
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        return CollectionsKt.listOf((Object)ProfileProperty.Companion.of("textures", properties.get(0), properties.get(1)));
    }

    @Override
    public boolean isProxy() {
        return false;
    }

    @Override
    public boolean isPluginEnabled(@NotNull String plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        return this.server.pluginManager().isLoaded(plugin);
    }

    @Override
    @NotNull
    public String getConfigName() {
        return "kryptonconfig.yml";
    }

    private final void loadNametagFeature() {
        if (!TAB.getInstance().getConfig().getBoolean("scoreboard-teams.enabled", true)) {
            return;
        }
        if (TAB.getInstance().getConfig().getBoolean("scoreboard-teams.unlimited-nametag-mode.enabled", false)) {
            TAB.getInstance().getFeatureManager().registerFeature("NameTagX", new NameTagX(this.plugin));
        } else {
            TAB.getInstance().getFeatureManager().registerFeature("NameTag16", new NameTag());
        }
    }

    private static final Object registerUnknownPlaceholder$lambda-1(TabPlayer $noName_0, TabPlayer $noName_1) {
        return "";
    }

    private static final Object registerUnknownPlaceholder$lambda-2(String $identifier) {
        Intrinsics.checkNotNullParameter((Object)$identifier, (String)"$identifier");
        return $identifier;
    }

    private static final Object registerUnknownPlaceholder$lambda-3(String $identifier, TabPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$identifier, (String)"$identifier");
        return $identifier;
    }

    private static final Object registerUnknownPlaceholder$lambda-4(String $identifier, TabPlayer it) {
        Intrinsics.checkNotNullParameter((Object)$identifier, (String)"$identifier");
        return $identifier;
    }
}

