/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.krypton;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.PacketPlayOutChat;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerListHeaderFooter;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kryptonmc.api.entity.player.Player;
import org.kryptonmc.krypton.entity.player.KryptonPlayer;
import org.kryptonmc.krypton.packet.Packet;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0016J \u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010$\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lme/neznamy/tab/platforms/krypton/KryptonTabPlayer;", "Lme/neznamy/tab/shared/ITabPlayer;", "delegate", "Lorg/kryptonmc/api/entity/player/Player;", "protocolVersion", "", "(Lorg/kryptonmc/api/entity/player/Player;I)V", "bossBars", "", "Ljava/util/UUID;", "Lnet/kyori/adventure/bossbar/BossBar;", "Lorg/kryptonmc/krypton/entity/player/KryptonPlayer;", "getGamemode", "getPing", "getPlayer", "getSkin", "", "handle", "", "packet", "Lme/neznamy/tab/api/protocol/PacketPlayOutBoss;", "Lme/neznamy/tab/api/protocol/PacketPlayOutChat;", "Lme/neznamy/tab/api/protocol/PacketPlayOutPlayerListHeaderFooter;", "hasInvisibilityPotion", "", "hasPermission", "permission", "", "isDisguised", "isOnline", "isVanished", "processFlag", "bar", "targetValue", "flag", "Lnet/kyori/adventure/bossbar/BossBar$Flag;", "sendPacket", "krypton"})
public final class KryptonTabPlayer
extends ITabPlayer {
    @NotNull
    private final KryptonPlayer delegate;
    @NotNull
    private final Map<UUID, BossBar> bossBars;

    public KryptonTabPlayer(@NotNull Player delegate, int protocolVersion) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        super(delegate, delegate.uuid(), delegate.profile().name(), "N/A", delegate.world().name());
        this.delegate = (KryptonPlayer)delegate;
        this.bossBars = new LinkedHashMap();
        this.channel = this.delegate.getSession().getChannel();
        this.version = ProtocolVersion.fromNetworkId(protocolVersion);
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return this.delegate.hasPermission(permission);
    }

    @Override
    public int getPing() {
        int latency = this.delegate.getSession().getLatency();
        if (latency > 10000 || latency < 0) {
            return -1;
        }
        return latency;
    }

    @Override
    public void sendPacket(@Nullable Object packet) {
        if (packet == null) {
            return;
        }
        try {
            if (packet instanceof Packet) {
                this.delegate.getSession().send((Packet)packet);
                return;
            }
            Object object = packet;
            if (object instanceof PacketPlayOutBoss) {
                this.handle((PacketPlayOutBoss)packet);
            } else if (object instanceof PacketPlayOutChat) {
                this.handle((PacketPlayOutChat)packet);
            } else if (object instanceof PacketPlayOutPlayerListHeaderFooter) {
                this.handle((PacketPlayOutPlayerListHeaderFooter)packet);
            }
        }
        catch (Exception exception) {
            TAB.getInstance().getErrorManager().printError("An error occurred when sending " + packet.getClass().getSimpleName(), exception);
        }
    }

    @Override
    public boolean hasInvisibilityPotion() {
        return false;
    }

    @Override
    public boolean isDisguised() {
        return false;
    }

    @Override
    @NotNull
    public Object getSkin() {
        return this.delegate.getProfile().properties();
    }

    @NotNull
    public Player getPlayer() {
        return (Player)this.delegate;
    }

    @Override
    public boolean isOnline() {
        return this.delegate.isOnline();
    }

    @Override
    public boolean isVanished() {
        return this.delegate.isVanished();
    }

    @Override
    public int getGamemode() {
        return this.delegate.getGameMode().ordinal();
    }

    private final void handle(PacketPlayOutBoss packet) {
        PacketPlayOutBoss.Action action = packet.getOperation();
        switch (action == null ? -1 : WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                if (this.bossBars.containsKey(packet.getId())) {
                    return;
                }
                Object object = BossBar.bossBar((Component)GsonComponentSerializer.gson().deserialize((Object)IChatBaseComponent.optimizedComponent(packet.getName()).toString(this.getVersion())), (float)packet.getPct(), (BossBar.Color)BossBar.Color.valueOf((String)packet.getColor().toString()), (BossBar.Overlay)BossBar.Overlay.valueOf((String)packet.getOverlay().toString()));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bossBar(\n               \u2026ring())\n                )");
                BossBar bar = object;
                if (packet.isCreateWorldFog()) {
                    bar.addFlag(BossBar.Flag.CREATE_WORLD_FOG);
                }
                if (packet.isDarkenScreen()) {
                    bar.addFlag(BossBar.Flag.DARKEN_SCREEN);
                }
                if (packet.isPlayMusic()) {
                    bar.addFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
                }
                object = this.bossBars;
                UUID uUID = packet.getId();
                Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"packet.id");
                object.put(uUID, bar);
                this.delegate.showBossBar(bar);
                break;
            }
            case 2: {
                BossBar bossBar = this.bossBars.get(packet.getId());
                if (bossBar == null) {
                    return;
                }
                this.delegate.hideBossBar(bossBar);
                this.bossBars.remove(packet.getId());
                break;
            }
            case 3: {
                BossBar bossBar = this.bossBars.get(packet.getId());
                if (bossBar == null) break;
                bossBar.progress(packet.getPct());
                break;
            }
            case 4: {
                BossBar bossBar = this.bossBars.get(packet.getId());
                if (bossBar == null) break;
                bossBar.name((Component)LegacyComponentSerializer.legacySection().deserialize(packet.getName()));
                break;
            }
            case 5: {
                BossBar bossBar = this.bossBars.get(packet.getId());
                if (bossBar == null) {
                    return;
                }
                BossBar bar = bossBar;
                bar.overlay(BossBar.Overlay.valueOf((String)packet.getOverlay().toString()));
                bar.color(BossBar.Color.valueOf((String)packet.getColor().toString()));
                break;
            }
            case 6: {
                BossBar bossBar = this.bossBars.get(packet.getId());
                if (bossBar == null) {
                    return;
                }
                BossBar bar = bossBar;
                this.processFlag(bar, packet.isCreateWorldFog(), BossBar.Flag.CREATE_WORLD_FOG);
                this.processFlag(bar, packet.isDarkenScreen(), BossBar.Flag.DARKEN_SCREEN);
                this.processFlag(bar, packet.isPlayMusic(), BossBar.Flag.PLAY_BOSS_MUSIC);
                break;
            }
        }
    }

    private final void handle(PacketPlayOutChat packet) {
        Component component = GsonComponentSerializer.gson().deserialize((Object)packet.getMessage().toString(this.version));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"gson().deserialize(packe\u2026essage.toString(version))");
        Component message = component;
        if (packet.getType() == PacketPlayOutChat.ChatMessageType.GAME_INFO) {
            this.delegate.sendActionBar(message);
            return;
        }
        this.delegate.sendMessage(message, MessageType.valueOf((String)packet.getType().name()));
    }

    private final void handle(PacketPlayOutPlayerListHeaderFooter packet) {
        Component component = GsonComponentSerializer.gson().deserialize((Object)packet.getHeader().toString(this.version));
        Intrinsics.checkNotNullExpressionValue((Object)component, (String)"gson().deserialize(packe\u2026header.toString(version))");
        Component header = component;
        Component component2 = GsonComponentSerializer.gson().deserialize((Object)packet.getFooter().toString(this.version));
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"gson().deserialize(packe\u2026footer.toString(version))");
        Component footer = component2;
        this.delegate.sendPlayerListHeaderAndFooter(header, footer);
    }

    private final void processFlag(BossBar bar, boolean targetValue, BossBar.Flag flag) {
        if (targetValue) {
            if (!bar.hasFlag(flag)) {
                bar.addFlag(flag);
            }
        } else if (bar.hasFlag(flag)) {
            bar.removeFlag(flag);
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PacketPlayOutBoss.Action.values().length];
            nArray[PacketPlayOutBoss.Action.ADD.ordinal()] = 1;
            nArray[PacketPlayOutBoss.Action.REMOVE.ordinal()] = 2;
            nArray[PacketPlayOutBoss.Action.UPDATE_PCT.ordinal()] = 3;
            nArray[PacketPlayOutBoss.Action.UPDATE_NAME.ordinal()] = 4;
            nArray[PacketPlayOutBoss.Action.UPDATE_STYLE.ordinal()] = 5;
            nArray[PacketPlayOutBoss.Action.UPDATE_PROPERTIES.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

