/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.krypton;

import com.google.inject.Inject;
import com.viaversion.viaversion.api.Via;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.krypton.KryptonEventListener;
import me.neznamy.tab.platforms.krypton.KryptonPlatform;
import me.neznamy.tab.shared.ErrorManager;
import me.neznamy.tab.shared.TAB;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.jetbrains.annotations.NotNull;
import org.kryptonmc.api.Server;
import org.kryptonmc.api.command.Sender;
import org.kryptonmc.api.command.SimpleCommand;
import org.kryptonmc.api.command.meta.SimpleCommandMeta;
import org.kryptonmc.api.entity.player.Player;
import org.kryptonmc.api.event.Listener;
import org.kryptonmc.api.event.server.ServerStartEvent;
import org.kryptonmc.api.event.server.ServerStopEvent;
import org.kryptonmc.api.plugin.PluginContainer;
import org.kryptonmc.api.plugin.PluginDescription;
import org.kryptonmc.api.plugin.annotation.DataFolder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010H\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lme/neznamy/tab/platforms/krypton/Main;", "", "server", "Lorg/kryptonmc/api/Server;", "folder", "Ljava/nio/file/Path;", "(Lorg/kryptonmc/api/Server;Ljava/nio/file/Path;)V", "getFolder", "()Ljava/nio/file/Path;", "getServer", "()Lorg/kryptonmc/api/Server;", "onStart", "", "event", "Lorg/kryptonmc/api/event/server/ServerStartEvent;", "onStop", "Lorg/kryptonmc/api/event/server/ServerStopEvent;", "protocolVersion", "", "player", "Lorg/kryptonmc/api/entity/player/Player;", "viaProtocolVersion", "retryLevel", "KryptonTABCommand", "krypton"})
public final class Main {
    @NotNull
    private final Server server;
    @NotNull
    private final Path folder;

    @Inject
    public Main(@NotNull Server server, @DataFolder @NotNull Path folder) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        this.server = server;
        this.folder = folder;
    }

    @NotNull
    public final Server getServer() {
        return this.server;
    }

    @NotNull
    public final Path getFolder() {
        return this.folder;
    }

    @Listener
    public final void onStart(@NotNull ServerStartEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        File file = this.folder.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"folder.toFile()");
        TAB.setInstance(new TAB(new KryptonPlatform(this, file), ProtocolVersion.fromNetworkId(this.server.platform().protocolVersion())));
        if (TAB.getInstance().getServerVersion() == ProtocolVersion.UNKNOWN) {
            this.server.console().sendMessage((Component)Component.text((String)("[TAB] Unknown server version: " + this.server.platform().version() + "! Plugin may not work correctly"), (TextColor)((TextColor)NamedTextColor.RED)));
        }
        this.server.eventManager().register((Object)this, (Object)new KryptonEventListener(this));
        this.server.commandManager().register((SimpleCommand)new KryptonTABCommand(), SimpleCommandMeta.Companion.builder("tab").build());
        TAB.getInstance().load();
    }

    @Listener
    public final void onStop(@NotNull ServerStopEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TAB tAB = TAB.getInstance();
        if (tAB != null) {
            tAB.unload();
        }
    }

    public final int protocolVersion(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.server.pluginManager().isLoaded("viaversion")) {
            return Main.viaProtocolVersion$default(this, player, 0, 2, null);
        }
        return TAB.getInstance().getServerVersion().getNetworkId();
    }

    private final int viaProtocolVersion(Player player, int retryLevel) {
        try {
            if (retryLevel == 10) {
                TAB.getInstance().debug("Failed to get protocol version of " + player.profile().name() + " after 10 retries");
                return TAB.getInstance().getServerVersion().getNetworkId();
            }
            int version = Via.getAPI().getPlayerVersion((Object)player);
            if (version == -1) {
                Thread.sleep(5L);
                return this.viaProtocolVersion(player, retryLevel + 1);
            }
            TAB.getInstance().debug("ViaVersion returned protocol version " + version + " for " + player.profile().name());
            return version;
        }
        catch (InterruptedException exception) {
            Thread.currentThread().interrupt();
            return -1;
        }
        catch (Throwable exception) {
            String string;
            ErrorManager errorManager = TAB.getInstance().getErrorManager();
            String string2 = player.profile().name();
            PluginContainer pluginContainer = this.server.pluginManager().plugin("viaversion");
            if (pluginContainer == null) {
                string = null;
            } else {
                PluginDescription pluginDescription = pluginContainer.description();
                string = pluginDescription == null ? null : pluginDescription.version();
            }
            errorManager.printError("Failed to get protocol version of " + string2 + " using ViaVersion v" + string);
            return TAB.getInstance().getServerVersion().getNetworkId();
        }
    }

    static /* synthetic */ int viaProtocolVersion$default(Main main, Player player, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return main.viaProtocolVersion(player, n);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lme/neznamy/tab/platforms/krypton/Main$KryptonTABCommand;", "Lorg/kryptonmc/api/command/SimpleCommand;", "()V", "execute", "", "sender", "Lorg/kryptonmc/api/command/Sender;", "args", "", "", "(Lorg/kryptonmc/api/command/Sender;[Ljava/lang/String;)V", "suggest", "", "(Lorg/kryptonmc/api/command/Sender;[Ljava/lang/String;)Ljava/util/List;", "krypton"})
    public static final class KryptonTABCommand
    implements SimpleCommand {
        public void execute(@NotNull Sender sender, @NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (TAB.getInstance().isDisabled()) {
                boolean canReload = sender.hasPermission("tab.reload");
                boolean isAdmin = sender.hasPermission("tab.admin");
                List<String> list = TAB.getInstance().getDisabledCommand().execute(args, canReload, isAdmin);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getInstance().disabledCo\u2026args, canReload, isAdmin)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    sender.sendMessage((Component)Component.text((String)it));
                }
                return;
            }
            TabPlayer player = null;
            if (sender instanceof Player && (player = TAB.getInstance().getPlayer(sender.uuid())) == null) {
                return;
            }
            TAB.getInstance().getCommand().execute(player, args);
        }

        @NotNull
        public List<String> suggest(@NotNull Sender sender, @NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            TabPlayer player = null;
            if (sender instanceof Player && (player = TAB.getInstance().getPlayer(sender.uuid())) == null) {
                return CollectionsKt.emptyList();
            }
            List<String> list = TAB.getInstance().getCommand().complete(player, args);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getInstance().command.complete(player, args)");
            return list;
        }
    }
}

