/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.krypton.features.unlimitedtags;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import me.neznamy.tab.api.ArmorStand;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.platforms.krypton.KryptonPacketBuilder;
import me.neznamy.tab.platforms.krypton.features.unlimitedtags.NameTagX;
import me.neznamy.tab.shared.TAB;
import org.jetbrains.annotations.NotNull;
import org.kryptonmc.api.entity.Entity;
import org.kryptonmc.api.entity.EntityTypes;
import org.kryptonmc.api.entity.player.Player;
import org.kryptonmc.api.registry.Registries;
import org.kryptonmc.krypton.entity.KryptonEntity;
import org.kryptonmc.krypton.entity.metadata.MetadataHolder;
import org.kryptonmc.krypton.entity.metadata.MetadataKey;
import org.kryptonmc.krypton.entity.metadata.MetadataKeys;
import org.kryptonmc.krypton.entity.player.KryptonPlayer;
import org.kryptonmc.krypton.packet.Packet;
import org.kryptonmc.krypton.packet.out.play.PacketOutDestroyEntities;
import org.kryptonmc.krypton.packet.out.play.PacketOutEntityTeleport;
import org.kryptonmc.krypton.packet.out.play.PacketOutMetadata;
import org.kryptonmc.krypton.packet.out.play.PacketOutSpawnLivingEntity;
import org.spongepowered.math.vector.Vector2f;
import org.spongepowered.math.vector.Vector3d;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 :2\u00020\u0001:\u0001:B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\u0007H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\b\u0010'\u001a\u00020\u0007H\u0016J\b\u0010(\u001a\u00020\u0005H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\b\u0010.\u001a\u00020\tH\u0016J\u0010\u0010/\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u00100\u001a\u00020%H\u0016J\u0010\u00101\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u00020%2\u0006\u00103\u001a\u00020\u0007H\u0016J\u0010\u00104\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u00105\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u00106\u001a\u00020%H\u0016J\u0010\u00106\u001a\u00020%2\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\b\u00107\u001a\u00020%H\u0002J\u0010\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020\tH\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lme/neznamy/tab/platforms/krypton/features/unlimitedtags/KryptonArmorStand;", "Lme/neznamy/tab/api/ArmorStand;", "owner", "Lme/neznamy/tab/api/TabPlayer;", "property", "Lme/neznamy/tab/api/Property;", "yOffset", "", "staticOffset", "", "(Lme/neznamy/tab/api/TabPlayer;Lme/neznamy/tab/api/Property;DZ)V", "destroyPacket", "Lorg/kryptonmc/krypton/packet/out/play/PacketOutDestroyEntities;", "entityId", "", "location", "Lorg/spongepowered/math/vector/Vector3d;", "getLocation", "()Lorg/spongepowered/math/vector/Vector3d;", "manager", "Lme/neznamy/tab/platforms/krypton/features/unlimitedtags/NameTagX;", "player", "Lorg/kryptonmc/api/entity/player/Player;", "sneaking", "uuid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "visible", "armorStandLocationFor", "viewer", "calculateVisibility", "calculateY", "createMetadata", "Lorg/kryptonmc/krypton/entity/metadata/MetadataHolder;", "displayName", "", "destroy", "", "getEntityId", "getOffset", "getProperty", "getSpawnPackets", "Lkotlin/sequences/Sequence;", "Lorg/kryptonmc/krypton/packet/Packet;", "getTeleportPacket", "Lorg/kryptonmc/krypton/packet/out/play/PacketOutEntityTeleport;", "hasStaticOffset", "isNameVisibilityEmpty", "refresh", "respawn", "setOffset", "offset", "sneak", "spawn", "teleport", "updateMetadata", "updateVisibility", "force", "Companion", "krypton"})
public final class KryptonArmorStand
implements ArmorStand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TabPlayer owner;
    @NotNull
    private final Property property;
    private double yOffset;
    private final boolean staticOffset;
    @NotNull
    private final NameTagX manager;
    @NotNull
    private final Player player;
    private final int entityId;
    private final UUID uuid;
    private boolean sneaking;
    private boolean visible;
    @NotNull
    private final PacketOutDestroyEntities destroyPacket;
    private static final boolean ALWAYS_VISIBLE = TAB.getInstance().getConfiguration().isArmorStandsAlwaysVisible();
    @NotNull
    private static final AtomicInteger ID_COUNTER = new AtomicInteger(2000000000);
    private static final int TYPE = Registries.ENTITY_TYPE.idOf((Object)EntityTypes.ARMOR_STAND);

    public KryptonArmorStand(@NotNull TabPlayer owner, @NotNull Property property, double yOffset, boolean staticOffset) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        this.owner = owner;
        this.property = property;
        this.yOffset = yOffset;
        this.staticOffset = staticOffset;
        TabFeature tabFeature = TAB.getInstance().getFeatureManager().getFeature("NameTagX");
        if (tabFeature == null) {
            throw new NullPointerException("null cannot be cast to non-null type me.neznamy.tab.platforms.krypton.features.unlimitedtags.NameTagX");
        }
        this.manager = (NameTagX)tabFeature;
        Object object = this.owner.getPlayer();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kryptonmc.api.entity.player.Player");
        }
        this.player = (Player)object;
        this.entityId = ID_COUNTER.incrementAndGet();
        this.uuid = UUID.randomUUID();
        this.visible = this.calculateVisibility();
        this.destroyPacket = new PacketOutDestroyEntities(this.entityId);
    }

    private final Vector3d getLocation() {
        double x = this.player.location().x();
        double y = this.calculateY() + this.yOffset + (double)2;
        double z = this.player.location().z();
        return new Vector3d(x, y -= this.player.sleepingPosition() != null ? 1.76 : (this.sneaking ? 0.45 : 0.18), z);
    }

    @Override
    public void refresh() {
        this.visible = this.calculateVisibility();
        this.updateMetadata();
    }

    @Override
    @NotNull
    public Property getProperty() {
        return this.property;
    }

    @Override
    public boolean hasStaticOffset() {
        return this.staticOffset;
    }

    @Override
    public double getOffset() {
        return this.yOffset;
    }

    @Override
    public void setOffset(double offset) {
        if (this.yOffset == offset) {
            return;
        }
        this.yOffset = offset;
        TabPlayer[] tabPlayerArray = this.owner.getArmorStandManager().getNearbyPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)tabPlayerArray, (String)"owner.armorStandManager.nearbyPlayers");
        Object[] $this$forEach$iv = tabPlayerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TabPlayer it = (TabPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            it.sendPacket((Object)this.getTeleportPacket(it), "Unlimited NameTags (Changing offset)");
        }
    }

    @Override
    public void spawn(@NotNull TabPlayer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Sequence<Packet> $this$forEach$iv = this.getSpawnPackets(viewer);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Packet it = (Packet)element$iv;
            boolean bl = false;
            viewer.sendPacket((Object)it, "Unlimited NameTags (Spawning)");
        }
    }

    @Override
    public void destroy() {
        TabPlayer[] tabPlayerArray = TAB.getInstance().getOnlinePlayers();
        Intrinsics.checkNotNullExpressionValue((Object)tabPlayerArray, (String)"getInstance().onlinePlayers");
        Object[] $this$forEach$iv = tabPlayerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TabPlayer it = (TabPlayer)element$iv;
            boolean bl = false;
            it.sendPacket((Object)this.destroyPacket, "Unlimited NameTags (Despawning)");
        }
    }

    @Override
    public void destroy(@NotNull TabPlayer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        viewer.sendPacket((Object)this.destroyPacket, "Unlimited NameTags (Despawning)");
    }

    @Override
    public void teleport() {
        TabPlayer[] tabPlayerArray = this.owner.getArmorStandManager().getNearbyPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)tabPlayerArray, (String)"owner.armorStandManager.nearbyPlayers");
        Object[] $this$forEach$iv = tabPlayerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TabPlayer it = (TabPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            it.sendPacket((Object)this.getTeleportPacket(it), "Unlimited NameTags (Teleporting)");
        }
    }

    @Override
    public void teleport(@NotNull TabPlayer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        if (!this.owner.getArmorStandManager().isNearby(viewer) && viewer != this.owner) {
            this.owner.getArmorStandManager().spawn(viewer);
            return;
        }
        viewer.sendPacket((Object)this.getTeleportPacket(viewer), "Unlimited NameTags (Teleporting)");
    }

    @Override
    public void sneak(boolean sneaking) {
        if (this.sneaking == sneaking) {
            return;
        }
        this.sneaking = sneaking;
        TabPlayer[] tabPlayerArray = this.owner.getArmorStandManager().getNearbyPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)tabPlayerArray, (String)"owner.armorStandManager.nearbyPlayers");
        Object[] $this$forEach$iv = tabPlayerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TabPlayer it = (TabPlayer)element$iv;
            boolean bl = false;
            if (it.getVersion().getMinorVersion() == 14 && !ALWAYS_VISIBLE) {
                if (sneaking) {
                    it.sendPacket((Object)this.destroyPacket, "Unlimited NameTags (Sneaking)");
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                this.spawn(it);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.respawn(it);
        }
    }

    @Override
    public void updateVisibility(boolean force) {
        boolean visibility = this.calculateVisibility();
        if (this.visible != visibility || force) {
            this.visible = visibility;
            this.updateMetadata();
        }
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    private final void updateMetadata() {
        TabPlayer[] tabPlayerArray = this.owner.getArmorStandManager().getNearbyPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)tabPlayerArray, (String)"owner.armorStandManager.nearbyPlayers");
        Object[] $this$forEach$iv = tabPlayerArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TabPlayer it = (TabPlayer)element$iv;
            boolean bl = false;
            String string = this.property.getFormat(it);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.getFormat(it)");
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            PacketOutMetadata packet = new PacketOutMetadata(this.entityId, this.createMetadata(string, it).getAll());
            it.sendPacket((Object)packet, "Unlimited NameTags (Metadata)");
        }
    }

    private final PacketOutEntityTeleport getTeleportPacket(TabPlayer viewer) {
        Vector3d vector3d = this.armorStandLocationFor(viewer);
        Vector2f vector2f = Vector2f.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vector2f, (String)"ZERO");
        return new PacketOutEntityTeleport(this.entityId, vector3d, vector2f, false);
    }

    private final Sequence<Packet> getSpawnPackets(TabPlayer viewer) {
        this.visible = this.calculateVisibility();
        String string = this.property.getFormat(viewer);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.getFormat(viewer)");
        MetadataHolder data = this.createMetadata(string, viewer);
        Vector3d location = this.armorStandLocationFor(viewer);
        Object[] objectArray = new Packet[2];
        UUID uUID = this.uuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
        objectArray[0] = (Packet)new PacketOutSpawnLivingEntity(this.entityId, uUID, TYPE, location.x(), location.y(), location.z(), 0.0f, 0.0f, 0.0f, 0, 0, 0);
        objectArray[1] = (Packet)new PacketOutMetadata(this.entityId, data.getAll());
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    private final MetadataHolder createMetadata(String displayName, TabPlayer viewer) {
        MetadataHolder metadataHolder;
        Object object = viewer.getPlayer();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kryptonmc.krypton.entity.player.KryptonPlayer");
        }
        KryptonPlayer viewerPlayer = (KryptonPlayer)object;
        MetadataHolder $this$createMetadata_u24lambda_u2d6 = metadataHolder = new MetadataHolder((KryptonEntity)viewerPlayer);
        boolean bl = false;
        MetadataHolder.add$default((MetadataHolder)$this$createMetadata_u24lambda_u2d6, (MetadataKey)MetadataKeys.FLAGS, null, (int)2, null);
        MetadataHolder.add$default((MetadataHolder)$this$createMetadata_u24lambda_u2d6, (MetadataKey)MetadataKeys.CUSTOM_NAME, null, (int)2, null);
        MetadataHolder.add$default((MetadataHolder)$this$createMetadata_u24lambda_u2d6, (MetadataKey)MetadataKeys.CUSTOM_NAME_VISIBILITY, null, (int)2, null);
        MetadataHolder holder = metadataHolder;
        int flags = 32;
        if (this.sneaking) {
            flags += 2;
        }
        holder.set(MetadataKeys.FLAGS, (Object)((byte)flags));
        ProtocolVersion protocolVersion = viewer.getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)protocolVersion), (String)"viewer.version");
        holder.set(MetadataKeys.CUSTOM_NAME, (Object)KryptonPacketBuilder.toComponent(displayName, protocolVersion));
        if (this.isNameVisibilityEmpty(displayName) || !viewerPlayer.canSee(this.player) || this.manager.hasHiddenNametag(this.owner, viewer)) {
            holder.set(MetadataKeys.CUSTOM_NAME_VISIBILITY, (Object)false);
        } else {
            holder.set(MetadataKeys.CUSTOM_NAME_VISIBILITY, (Object)this.visible);
        }
        if (viewer.getVersion().getMinorVersion() > 8 || this.manager.getMarkerFor18x()) {
            MetadataHolder.add$default((MetadataHolder)holder, (MetadataKey)MetadataKeys.ArmorStandKeys.FLAGS, null, (int)2, null);
            holder.set(MetadataKeys.ArmorStandKeys.FLAGS, (Object)16);
        }
        return holder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean calculateVisibility() {
        if (this.owner.isDisguised()) return false;
        if (this.manager.getVehicleManager().isOnBoat(this.owner)) {
            return false;
        }
        if (ALWAYS_VISIBLE) {
            return true;
        }
        if (this.owner.hasInvisibilityPotion()) return false;
        if (this.owner.getGamemode() == 3) return false;
        if (this.manager.hasHiddenNametag(this.owner)) return false;
        String string = this.property.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"property.get()");
        if (((CharSequence)string).length() <= 0) return false;
        return true;
    }

    private final double calculateY() {
        Entity vehicle = this.player.vehicle();
        if (vehicle != null) {
            String string = vehicle.type().key().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"vehicle.type.key().asString()");
            String key = string;
            if (StringsKt.contains$default((CharSequence)key, (CharSequence)"horse", (boolean)false, (int)2, null)) {
                return vehicle.location().y() + 0.85;
            }
            if (StringsKt.contains$default((CharSequence)key, (CharSequence)"donkey", (boolean)false, (int)2, null)) {
                return vehicle.location().y() + 0.525;
            }
            if (vehicle.type() == EntityTypes.PIG) {
                return vehicle.location().y() + 0.325;
            }
            if (StringsKt.contains$default((CharSequence)key, (CharSequence)"strider", (boolean)false, (int)2, null)) {
                double cfr_ignored_0 = vehicle.location().y() + 1.15;
            }
        }
        if (this.player.isSwimming() || this.player.isGliding()) {
            return this.player.location().y() - 1.22;
        }
        return this.player.location().y();
    }

    private final Vector3d armorStandLocationFor(TabPlayer viewer) {
        if (viewer.getVersion().getMinorVersion() == 8 && !this.manager.getMarkerFor18x()) {
            Vector3d vector3d = this.getLocation().add(0.0, -2.0, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)vector3d, (String)"location.add(0.0, -2.0, 0.0)");
            return vector3d;
        }
        return this.getLocation();
    }

    private final boolean isNameVisibilityEmpty(String displayName) {
        String text;
        if (((CharSequence)displayName).length() == 0) {
            return true;
        }
        if (!(StringsKt.startsWith$default((CharSequence)displayName, (char)'\u00a7', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)displayName, (char)'&', (boolean)false, (int)2, null) || StringsKt.startsWith$default((CharSequence)displayName, (char)'#', (boolean)false, (int)2, null))) {
            return false;
        }
        String string = text = IChatBaseComponent.fromColoredText(displayName).toRawText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        if (StringsKt.contains$default((CharSequence)string, (char)' ', (boolean)false, (int)2, null)) {
            string = text;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
            text = StringsKt.replace$default((String)string, (String)" ", (String)"", (boolean)false, (int)4, null);
        }
        string = text;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        return ((CharSequence)string).length() == 0;
    }

    @Override
    public void respawn(@NotNull TabPlayer viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        viewer.sendPacket((Object)this.destroyPacket, "Unlimited NameTags (Despawning)");
        Runnable spawn = () -> KryptonArmorStand.respawn$lambda-7(this, viewer);
        if (viewer.getVersion().getMinorVersion() == 8) {
            TAB.getInstance().getCPUManager().runTaskLater(50, "compensating for 1.8.0 bugs", this.manager, "Compensating for 1.8.0 bugs", spawn);
        } else {
            spawn.run();
        }
    }

    private static final void respawn$lambda-7(KryptonArmorStand this$0, TabPlayer $viewer) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$viewer, (String)"$viewer");
        this$0.spawn($viewer);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lme/neznamy/tab/platforms/krypton/features/unlimitedtags/KryptonArmorStand$Companion;", "", "()V", "ALWAYS_VISIBLE", "", "ID_COUNTER", "Ljava/util/concurrent/atomic/AtomicInteger;", "TYPE", "", "krypton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

