/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.krypton.features.unlimitedtags;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.krypton.features.unlimitedtags.NameTagX;
import me.neznamy.tab.shared.TAB;
import org.jetbrains.annotations.NotNull;
import org.kryptonmc.api.entity.Entity;
import org.kryptonmc.api.entity.EntityTypes;
import org.kryptonmc.api.entity.player.Player;
import org.kryptonmc.krypton.entity.KryptonEntity;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000eJ\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u0010H\u0016J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lme/neznamy/tab/platforms/krypton/features/unlimitedtags/VehicleRefresher;", "Lme/neznamy/tab/api/TabFeature;", "feature", "Lme/neznamy/tab/platforms/krypton/features/unlimitedtags/NameTagX;", "(Lme/neznamy/tab/platforms/krypton/features/unlimitedtags/NameTagX;)V", "playersInVehicle", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/neznamy/tab/api/TabPlayer;", "Lorg/kryptonmc/krypton/entity/KryptonEntity;", "playersOnBoats", "", "vehicles", "", "", "Lorg/kryptonmc/api/entity/Entity;", "isInVehicle", "", "player", "isOnBoat", "loadPassengers", "", "onQuit", "disconnectedPlayer", "processPassengers", "vehicle", "refresh", "refreshed", "force", "id", "krypton"})
public final class VehicleRefresher
extends TabFeature {
    @NotNull
    private final NameTagX feature;
    @NotNull
    private final ConcurrentHashMap<TabPlayer, KryptonEntity> playersInVehicle;
    @NotNull
    private final ConcurrentHashMap<Integer, List<Entity>> vehicles;
    @NotNull
    private final List<TabPlayer> playersOnBoats;

    public VehicleRefresher(@NotNull NameTagX feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        super(feature.getFeatureName(), "Refreshing vehicles");
        this.feature = feature;
        this.playersInVehicle = new ConcurrentHashMap();
        this.vehicles = new ConcurrentHashMap();
        this.playersOnBoats = new ArrayList();
        this.addUsedPlaceholders(CollectionsKt.listOf((Object)"%vehicle%"));
        TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%vehicle%", 100, VehicleRefresher::_init_$lambda-0);
    }

    public final boolean isInVehicle(@NotNull TabPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.playersInVehicle.containsKey(player);
    }

    public final boolean isOnBoat(@NotNull TabPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.playersOnBoats.contains(player);
    }

    @NotNull
    public final List<Entity> vehicles(int id) {
        List list = this.vehicles.get(id);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void loadPassengers(@NotNull TabPlayer player) {
        Entity vehicle;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object object = player.getPlayer();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kryptonmc.api.entity.player.Player");
        }
        if (((Player)object).vehicle() == null) {
            return;
        }
        Object object2 = player.getPlayer();
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kryptonmc.api.entity.player.Player");
        }
        Entity entity = vehicle = ((Player)object2).vehicle();
        if (entity == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kryptonmc.krypton.entity.KryptonEntity");
        }
        ((Map)this.vehicles).put(((KryptonEntity)entity).getId(), ((KryptonEntity)vehicle).getPassengers());
    }

    public final void processPassengers(@NotNull Entity vehicle) {
        Intrinsics.checkNotNullParameter((Object)vehicle, (String)"vehicle");
        Iterable $this$forEach$iv = vehicle.passengers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            if (it instanceof Player) {
                TAB.getInstance().getPlayer(it.uuid()).getArmorStandManager().teleport();
            }
            this.processPassengers(it);
        }
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        Intrinsics.checkNotNullParameter((Object)refreshed, (String)"refreshed");
        if (this.feature.isPlayerDisabled(refreshed)) {
            return;
        }
        Object object = refreshed.getPlayer();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kryptonmc.api.entity.player.Player");
        }
        Entity vehicle = ((Player)object).vehicle();
        if (this.playersInVehicle.containsKey(refreshed) && vehicle == null) {
            KryptonEntity kryptonEntity = this.playersInVehicle.get(refreshed);
            if (kryptonEntity == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.kryptonmc.krypton.entity.KryptonEntity");
            }
            this.vehicles.remove(kryptonEntity.getId());
            refreshed.getArmorStandManager().teleport();
            this.playersInVehicle.remove(refreshed);
            if (this.feature.getDisableOnBoats() && this.playersOnBoats.contains(refreshed)) {
                this.playersOnBoats.remove(refreshed);
                this.feature.updateTeamData(refreshed);
            }
        }
        if (!this.playersInVehicle.containsKey(refreshed) && vehicle != null) {
            Map map = this.vehicles;
            Integer n = ((KryptonEntity)vehicle).getId();
            List list = ((KryptonEntity)vehicle).getPassengers();
            map.put(n, list);
            refreshed.getArmorStandManager().respawn();
            map = this.playersInVehicle;
            n = vehicle;
            map.put(refreshed, n);
            if (this.feature.getDisableOnBoats() && ((KryptonEntity)vehicle).type() == EntityTypes.BOAT) {
                this.playersOnBoats.add(refreshed);
                this.feature.updateTeamData(refreshed);
            }
        }
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        Intrinsics.checkNotNullParameter((Object)disconnectedPlayer, (String)"disconnectedPlayer");
        if (this.playersInVehicle.containsKey(disconnectedPlayer)) {
            KryptonEntity kryptonEntity = this.playersInVehicle.get(disconnectedPlayer);
            Intrinsics.checkNotNull((Object)kryptonEntity);
            this.vehicles.remove(kryptonEntity.getId());
        }
        this.playersInVehicle.remove(disconnectedPlayer);
        this.playersOnBoats.remove(disconnectedPlayer);
    }

    private static final Object _init_$lambda-0(TabPlayer it) {
        Object object = it.getPlayer();
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.kryptonmc.api.entity.player.Player");
        }
        return String.valueOf(((Player)object).vehicle());
    }
}

