/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.libs.org.bstats.charts.SimplePie;
import me.neznamy.tab.libs.org.bstats.velocity.Metrics;
import me.neznamy.tab.platforms.velocity.VelocityEventListener;
import me.neznamy.tab.platforms.velocity.VelocityPlatform;
import me.neznamy.tab.platforms.velocity.VelocityPluginMessageHandler;
import me.neznamy.tab.shared.TAB;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

@Plugin(id="tab", name="TAB", version="3.0.2", description="An all-in-one solution that works", authors={"NEZNAMY"})
public class Main {
    private final ProxyServer server;
    private final Metrics.Factory metricsFactory;
    private static final Map<IChatBaseComponent, Component> componentCacheModern = new HashMap<IChatBaseComponent, Component>();
    private static final Map<IChatBaseComponent, Component> componentCacheLegacy = new HashMap<IChatBaseComponent, Component>();

    @Inject
    public Main(ProxyServer server, Metrics.Factory metricsFactory) {
        this.server = server;
        this.metricsFactory = metricsFactory;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        if (!this.isVersionSupported()) {
            this.server.getConsoleCommandSource().sendMessage(Identity.nil(), (Component)Component.text((String)EnumChatFormat.color("&c[TAB] The plugin requires Velocity 1.1.0 and up to work. Get it at https://velocitypowered.com/downloads")));
            return;
        }
        if (this.server.getConfiguration().isOnlineMode()) {
            this.server.getConsoleCommandSource().sendMessage(Identity.nil(), (Component)Component.text((String)EnumChatFormat.color("&6[TAB] If you experience tablist prefix/suffix not working and global playerlist duplicating players, toggle \"use-online-uuid-in-tablist\" option in config.yml (set it to opposite value).")));
        }
        VelocityPluginMessageHandler plm = new VelocityPluginMessageHandler(this);
        TAB.setInstance(new TAB(new VelocityPlatform(this.server, plm), ProtocolVersion.PROXY));
        this.server.getEventManager().register((Object)this, (Object)new VelocityEventListener());
        VelocityTABCommand cmd = new VelocityTABCommand();
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("btab").build(), (Command)cmd);
        this.server.getCommandManager().register(this.server.getCommandManager().metaBuilder("vtab").build(), (Command)cmd);
        TAB.getInstance().load();
        Metrics metrics = this.metricsFactory.make(this, 10533);
        metrics.addCustomChart(new SimplePie("global_playerlist_enabled", () -> TAB.getInstance().getFeatureManager().isFeatureEnabled("GlobalPlayerList") ? "Yes" : "No"));
    }

    private boolean isVersionSupported() {
        try {
            Class.forName("org.yaml.snakeyaml.Yaml");
            Class.forName("net.kyori.adventure.identity.Identity");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        if (TAB.getInstance() != null) {
            TAB.getInstance().unload();
        }
    }

    public static Component convertComponent(IChatBaseComponent component, ProtocolVersion clientVersion) {
        if (component == null) {
            return null;
        }
        return clientVersion.getMinorVersion() >= 16 ? Main.fromCache(componentCacheModern, component, clientVersion) : Main.fromCache(componentCacheLegacy, component, clientVersion);
    }

    private static Component fromCache(Map<IChatBaseComponent, Component> map, IChatBaseComponent component, ProtocolVersion clientVersion) {
        if (map.containsKey(component)) {
            return map.get(component);
        }
        Component obj = GsonComponentSerializer.gson().deserialize((Object)component.toString(clientVersion));
        if (map.size() > 10000) {
            map.clear();
        }
        map.put(component, obj);
        return obj;
    }

    public ProxyServer getServer() {
        return this.server;
    }

    public static class VelocityTABCommand
    implements SimpleCommand {
        public void execute(SimpleCommand.Invocation invocation) {
            CommandSource sender = invocation.source();
            if (TAB.getInstance().isDisabled()) {
                for (String message : TAB.getInstance().getDisabledCommand().execute((String[])invocation.arguments(), sender.hasPermission("tab.reload"), sender.hasPermission("tab.admin"))) {
                    sender.sendMessage(Identity.nil(), (Component)Component.text((String)EnumChatFormat.color(message)));
                }
            } else {
                TabPlayer p = null;
                if (sender instanceof Player && (p = TAB.getInstance().getPlayer(((Player)sender).getUniqueId())) == null) {
                    return;
                }
                TAB.getInstance().getCommand().execute(p, (String[])invocation.arguments());
            }
        }

        public List<String> suggest(SimpleCommand.Invocation invocation) {
            TabPlayer p = null;
            if (invocation.source() instanceof Player && (p = TAB.getInstance().getPlayer(((Player)invocation.source()).getUniqueId())) == null) {
                return new ArrayList<String>();
            }
            return TAB.getInstance().getCommand().complete(p, (String[])invocation.arguments());
        }
    }
}

