/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.util.GameProfile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.protocol.PacketBuilder;
import me.neznamy.tab.platforms.velocity.VelocityPacketBuilder;
import me.neznamy.tab.platforms.velocity.VelocityPlaceholderRegistry;
import me.neznamy.tab.platforms.velocity.VelocityTabPlayer;
import me.neznamy.tab.platforms.velocity.event.TabLoadEvent;
import me.neznamy.tab.platforms.velocity.event.TabPlayerLoadEvent;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PluginMessageHandler;
import me.neznamy.tab.shared.permission.LuckPerms;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import me.neznamy.tab.shared.permission.VaultBridge;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;

public class VelocityPlatform
extends ProxyPlatform {
    private final ProxyServer server;
    private VelocityPacketBuilder packetBuilder = new VelocityPacketBuilder();

    public VelocityPlatform(ProxyServer server, PluginMessageHandler plm) {
        super(plm);
        this.server = server;
    }

    @Override
    public PermissionPlugin detectPermissionPlugin() {
        Optional luckperms = this.server.getPluginManager().getPlugin("luckperms");
        if (TAB.getInstance().getConfiguration().isBukkitPermissions()) {
            return new VaultBridge(this.plm);
        }
        if (luckperms.isPresent()) {
            return new LuckPerms(((PluginContainer)luckperms.get()).getDescription().getVersion().orElse("null"));
        }
        return new VaultBridge(this.plm);
    }

    @Override
    public void loadFeatures() {
        TAB tab = TAB.getInstance();
        new VelocityPlaceholderRegistry(this.server).registerPlaceholders(tab.getPlaceholderManager());
        super.loadFeatures();
        for (Player p : this.server.getAllPlayers()) {
            tab.addPlayer(new VelocityTabPlayer(p));
        }
    }

    @Override
    public void sendConsoleMessage(String message, boolean translateColors) {
        this.server.getConsoleCommandSource().sendMessage(Identity.nil(), (Component)Component.text((String)(translateColors ? EnumChatFormat.color(message) : message)));
    }

    @Override
    public String getServerVersion() {
        return this.server.getVersion().getName() + " v" + this.server.getVersion().getVersion();
    }

    @Override
    public File getDataFolder() {
        return new File("plugins" + File.separatorChar + "TAB");
    }

    @Override
    public void callLoadEvent() {
        this.server.getEventManager().fireAndForget((Object)new TabLoadEvent());
    }

    @Override
    public void callLoadEvent(TabPlayer player) {
        this.server.getEventManager().fireAndForget((Object)new TabPlayerLoadEvent(player));
    }

    @Override
    public int getMaxPlayers() {
        return this.server.getConfiguration().getShowMaxPlayers();
    }

    @Override
    public PacketBuilder getPacketBuilder() {
        return this.packetBuilder;
    }

    public void setPacketBuilder(VelocityPacketBuilder builder) {
        this.packetBuilder = builder;
    }

    @Override
    public Object getSkin(List<String> properties) {
        return Collections.singletonList(new GameProfile.Property("textures", properties.get(0), properties.get(1)));
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public boolean isPluginEnabled(String plugin) {
        return this.server.getPluginManager().getPlugin(plugin).isPresent();
    }
}

