/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.google.common.io.ByteStreams;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.util.Optional;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.platforms.velocity.Main;
import me.neznamy.tab.platforms.velocity.VelocityTabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.PluginMessageHandler;

public class VelocityPluginMessageHandler
extends PluginMessageHandler {
    private final MinecraftChannelIdentifier mc = MinecraftChannelIdentifier.create((String)"tab", (String)"placeholders");

    public VelocityPluginMessageHandler(Main plugin) {
        plugin.getServer().getChannelRegistrar().register(new ChannelIdentifier[]{this.mc});
        plugin.getServer().getEventManager().register((Object)plugin, (Object)this);
    }

    @Subscribe
    public void on(PluginMessageEvent event) {
        if (!event.getIdentifier().getId().equalsIgnoreCase("tab:placeholders")) {
            return;
        }
        if (event.getTarget() instanceof Player) {
            event.setResult(PluginMessageEvent.ForwardResult.handled());
            TAB.getInstance().getCPUManager().runMeasuredTask("processing PluginMessageEvent", "Plugin message handling", "PluginMessageEvent", () -> {
                VelocityTabPlayer receiver = (VelocityTabPlayer)TAB.getInstance().getPlayer(((Player)event.getTarget()).getUniqueId());
                if (receiver == null) {
                    return;
                }
                this.onPluginMessage(receiver, ByteStreams.newDataInput((byte[])event.getData()));
            });
        }
    }

    @Override
    public void sendPluginMessage(TabPlayer player, byte[] message) {
        try {
            Player sender = (Player)player.getPlayer();
            Optional server = sender.getCurrentServer();
            if (server.isPresent()) {
                ((ServerConnection)server.get()).sendPluginMessage((ChannelIdentifier)this.mc, message);
                TAB.getInstance().getCPUManager().packetSent("Plugin Message (" + new String(message) + ")");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

