/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.velocity;

import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.player.TabListEntry;
import com.velocitypowered.api.util.GameProfile;
import io.netty.channel.Channel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.api.protocol.PacketPlayOutBoss;
import me.neznamy.tab.api.protocol.PacketPlayOutChat;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerInfo;
import me.neznamy.tab.api.protocol.PacketPlayOutPlayerListHeaderFooter;
import me.neznamy.tab.platforms.velocity.Main;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.proxy.ProxyTabPlayer;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;

public class VelocityTabPlayer
extends ProxyTabPlayer {
    private final UUID tabListId;
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();

    public VelocityTabPlayer(Player p) {
        super(p, p.getUniqueId(), p.getUsername(), p.getCurrentServer().isPresent() ? ((ServerConnection)p.getCurrentServer().get()).getServerInfo().getName() : "-");
        UUID offlineId = UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.getName()).getBytes(StandardCharsets.UTF_8));
        this.tabListId = TAB.getInstance().getConfiguration().getConfig().getBoolean("use-online-uuid-in-tablist", true) ? this.getUniqueId() : offlineId;
        this.version = ProtocolVersion.fromNetworkId(this.getPlayer().getProtocolVersion().getProtocol());
        try {
            Object minecraftConnection = this.player.getClass().getMethod("getConnection", new Class[0]).invoke(this.player, new Object[0]);
            this.channel = (Channel)minecraftConnection.getClass().getMethod("getChannel", new Class[0]).invoke(minecraftConnection, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            TAB.getInstance().getErrorManager().printError("Failed to get channel of " + p.getUsername(), e);
        }
    }

    @Override
    public boolean hasPermission0(String permission) {
        long time = System.nanoTime();
        boolean value = this.getPlayer().hasPermission(permission);
        TAB.getInstance().getCPUManager().addMethodTime("hasPermission", System.nanoTime() - time);
        return value;
    }

    @Override
    public int getPing() {
        return (int)this.getPlayer().getPing();
    }

    @Override
    public void sendPacket(Object packet) {
        long time = System.nanoTime();
        if (packet == null || !this.getPlayer().isActive()) {
            return;
        }
        if (packet instanceof PacketPlayOutChat) {
            this.handle((PacketPlayOutChat)packet);
        } else if (packet instanceof PacketPlayOutPlayerListHeaderFooter) {
            this.handle((PacketPlayOutPlayerListHeaderFooter)packet);
        } else if (packet instanceof PacketPlayOutBoss) {
            this.handle((PacketPlayOutBoss)packet);
        } else if (packet instanceof PacketPlayOutPlayerInfo) {
            this.handle((PacketPlayOutPlayerInfo)packet);
        } else if (this.channel != null) {
            this.channel.writeAndFlush(packet, this.channel.voidPromise());
        }
        TAB.getInstance().getCPUManager().addMethodTime("sendPacket", System.nanoTime() - time);
    }

    private void handle(PacketPlayOutChat packet) {
        if (packet.getType() == PacketPlayOutChat.ChatMessageType.GAME_INFO) {
            this.getPlayer().sendActionBar(Main.convertComponent(packet.getMessage(), this.getVersion()));
        } else {
            this.getPlayer().sendMessage(Identity.nil(), Main.convertComponent(packet.getMessage(), this.getVersion()), MessageType.valueOf((String)packet.getType().name()));
        }
    }

    private void handle(PacketPlayOutPlayerListHeaderFooter packet) {
        this.getPlayer().getTabList().setHeaderAndFooter(Main.convertComponent(packet.getHeader(), this.getVersion()), Main.convertComponent(packet.getFooter(), this.getVersion()));
    }

    private void handle(PacketPlayOutPlayerInfo packet) {
        for (PacketPlayOutPlayerInfo.PlayerInfoData data : packet.getEntries()) {
            switch (packet.getAction()) {
                case ADD_PLAYER: {
                    if (this.getPlayer().getTabList().containsEntry(data.getUniqueId())) break;
                    this.getPlayer().getTabList().addEntry(TabListEntry.builder().tabList(this.getPlayer().getTabList()).displayName(Main.convertComponent(data.getDisplayName(), this.getVersion())).gameMode(data.getGameMode().ordinal() - 1).profile(new GameProfile(data.getUniqueId(), data.getName(), data.getSkin() == null ? new ArrayList() : (List)data.getSkin())).latency(data.getLatency()).build());
                    break;
                }
                case REMOVE_PLAYER: {
                    this.getPlayer().getTabList().removeEntry(data.getUniqueId());
                    break;
                }
                case UPDATE_DISPLAY_NAME: {
                    this.getEntry(data.getUniqueId()).setDisplayName(Main.convertComponent(data.getDisplayName(), this.getVersion()));
                    break;
                }
                case UPDATE_LATENCY: {
                    this.getEntry(data.getUniqueId()).setLatency(data.getLatency());
                    break;
                }
                case UPDATE_GAME_MODE: {
                    this.getEntry(data.getUniqueId()).setGameMode(data.getGameMode().ordinal() - 1);
                    break;
                }
            }
        }
    }

    private void handle(PacketPlayOutBoss packet) {
        switch (packet.getOperation()) {
            case ADD: {
                if (this.bossBars.containsKey(packet.getId())) {
                    return;
                }
                BossBar bar = BossBar.bossBar((Component)Main.convertComponent(IChatBaseComponent.optimizedComponent(packet.getName()), this.getVersion()), (float)packet.getPct(), (BossBar.Color)BossBar.Color.valueOf((String)packet.getColor().toString()), (BossBar.Overlay)BossBar.Overlay.valueOf((String)packet.getOverlay().toString()));
                if (packet.isCreateWorldFog()) {
                    bar.addFlag(BossBar.Flag.CREATE_WORLD_FOG);
                }
                if (packet.isDarkenScreen()) {
                    bar.addFlag(BossBar.Flag.DARKEN_SCREEN);
                }
                if (packet.isPlayMusic()) {
                    bar.addFlag(BossBar.Flag.PLAY_BOSS_MUSIC);
                }
                this.bossBars.put(packet.getId(), bar);
                this.getPlayer().showBossBar(bar);
                break;
            }
            case REMOVE: {
                this.getPlayer().hideBossBar(this.bossBars.get(packet.getId()));
                this.bossBars.remove(packet.getId());
                break;
            }
            case UPDATE_PCT: {
                this.bossBars.get(packet.getId()).progress(packet.getPct());
                break;
            }
            case UPDATE_NAME: {
                this.bossBars.get(packet.getId()).name(Main.convertComponent(IChatBaseComponent.optimizedComponent(packet.getName()), this.getVersion()));
                break;
            }
            case UPDATE_STYLE: {
                BossBar bar = this.bossBars.get(packet.getId());
                bar.overlay(BossBar.Overlay.valueOf((String)packet.getOverlay().toString()));
                bar.color(BossBar.Color.valueOf((String)packet.getColor().toString()));
                break;
            }
            case UPDATE_PROPERTIES: {
                BossBar bar = this.bossBars.get(packet.getId());
                this.processFlag(bar, packet.isCreateWorldFog(), BossBar.Flag.CREATE_WORLD_FOG);
                this.processFlag(bar, packet.isDarkenScreen(), BossBar.Flag.DARKEN_SCREEN);
                this.processFlag(bar, packet.isPlayMusic(), BossBar.Flag.PLAY_BOSS_MUSIC);
                break;
            }
        }
    }

    private void processFlag(BossBar bar, boolean targetValue, BossBar.Flag flag) {
        if (targetValue) {
            if (!bar.hasFlag(flag)) {
                bar.addFlag(flag);
            }
        } else if (bar.hasFlag(flag)) {
            bar.removeFlag(flag);
        }
    }

    private TabListEntry getEntry(UUID id) {
        for (TabListEntry entry : this.getPlayer().getTabList().getEntries()) {
            if (!entry.getProfile().getId().equals(id)) continue;
            return entry;
        }
        return TabListEntry.builder().tabList(this.getPlayer().getTabList()).displayName((Component)Component.text((String)"")).gameMode(0).profile(new GameProfile(UUID.randomUUID(), "empty", new ArrayList())).latency(0).build();
    }

    @Override
    public Object getSkin() {
        return this.getPlayer().getGameProfile().getProperties();
    }

    public Player getPlayer() {
        return (Player)this.player;
    }

    @Override
    public UUID getTablistUUID() {
        return this.tabListId;
    }

    @Override
    public boolean isOnline() {
        return this.getPlayer().isActive();
    }

    @Override
    public int getGamemode() {
        return 0;
    }
}

