/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.task.RepeatingTask;
import me.neznamy.tab.api.task.ThreadManager;
import me.neznamy.tab.shared.ErrorManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabRepeatingTask;

public class CpuManager
implements ThreadManager {
    private static final int BUFFER_SIZE_MILLIS = 10000;
    private Map<String, Map<String, AtomicLong>> featureUsageCurrent = new ConcurrentHashMap<String, Map<String, AtomicLong>>();
    private Map<String, AtomicLong> placeholderUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicLong> bridgePlaceholderUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicLong> methodUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
    private Map<String, AtomicInteger> packetsCurrent = new ConcurrentHashMap<String, AtomicInteger>();
    private Map<String, Map<String, AtomicLong>> featureUsagePrevious = new HashMap<String, Map<String, AtomicLong>>();
    private Map<String, AtomicLong> placeholderUsagePrevious = new HashMap<String, AtomicLong>();
    private Map<String, AtomicLong> bridgePlaceholderUsagePrevious = new HashMap<String, AtomicLong>();
    private Map<String, AtomicLong> methodUsagePrevious = new HashMap<String, AtomicLong>();
    private Map<String, AtomicInteger> packetsPrevious = new ConcurrentHashMap<String, AtomicInteger>();
    private ExecutorService thread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TAB Processing Thread").build());
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    private final Map<Runnable, String> taskQueue = new HashMap<Runnable, String>();
    private boolean enabled = false;
    private final ErrorManager errorManager;

    public CpuManager(ErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public void registerPlaceholder() {
        TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%cpu%", 10000, () -> {
            this.featureUsagePrevious = this.featureUsageCurrent;
            this.placeholderUsagePrevious = this.placeholderUsageCurrent;
            this.bridgePlaceholderUsagePrevious = this.bridgePlaceholderUsageCurrent;
            this.methodUsagePrevious = this.methodUsageCurrent;
            this.packetsPrevious = this.packetsCurrent;
            this.featureUsageCurrent = new ConcurrentHashMap<String, Map<String, AtomicLong>>();
            this.placeholderUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
            this.bridgePlaceholderUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
            this.methodUsageCurrent = new ConcurrentHashMap<String, AtomicLong>();
            this.packetsCurrent = new ConcurrentHashMap<String, AtomicInteger>();
            return "";
        });
        TAB.getInstance().getPlaceholderManager().addUsedPlaceholders(Collections.singletonList("%cpu%"));
    }

    public void cancelAllTasks() {
        ExecutorService old = this.thread;
        this.thread = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TAB Processing Thread").build());
        old.shutdownNow();
        this.threadPool.shutdownNow();
    }

    public void enable() {
        this.enabled = true;
        this.taskQueue.forEach((r, e) -> this.submit((String)e, (Runnable)r));
        this.taskQueue.clear();
    }

    @Override
    public Future<Void> runMeasuredTask(String errorDescription, TabFeature feature, String type, Runnable task) {
        return this.runMeasuredTask(errorDescription, feature.getFeatureName(), type, task);
    }

    @Override
    public Future<Void> runMeasuredTask(String errorDescription, String feature, String type, Runnable task) {
        return this.submit(errorDescription, () -> {
            long time = System.nanoTime();
            task.run();
            this.addTime(feature, type, System.nanoTime() - time);
        });
    }

    @Override
    public Future<Void> runTask(String errorDescription, Runnable task) {
        return this.submit(errorDescription, task);
    }

    @Override
    public RepeatingTask startRepeatingMeasuredTask(int intervalMilliseconds, String errorDescription, TabFeature feature, String type, Runnable task) {
        return new TabRepeatingTask(this.threadPool, task, errorDescription, feature, type, intervalMilliseconds);
    }

    @Override
    public Future<?> runTaskLater(int delayMilliseconds, String errorDescription, TabFeature feature, String type, Runnable task) {
        return this.threadPool.submit(() -> {
            try {
                Thread.sleep(delayMilliseconds);
                this.runMeasuredTask(errorDescription, feature, type, task);
            }
            catch (InterruptedException pluginDisabled) {
                Thread.currentThread().interrupt();
            }
        });
    }

    @Override
    public Future<?> runTaskLater(int delayMilliseconds, String errorDescription, Runnable task) {
        return this.threadPool.submit(() -> {
            try {
                Thread.sleep(delayMilliseconds);
                this.submit(errorDescription, task);
            }
            catch (InterruptedException pluginDisabled) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private Future<Void> submit(String errorDescription, Runnable task) {
        if (!this.enabled) {
            this.taskQueue.put(task, errorDescription);
            return null;
        }
        return this.thread.submit(() -> {
            try {
                task.run();
            }
            catch (Exception | LinkageError e) {
                this.errorManager.printError("An error occurred when " + errorDescription, e);
            }
        });
    }

    public Map<String, Float> getPlaceholderUsage() {
        return this.getUsage(this.placeholderUsagePrevious);
    }

    public Map<String, Float> getBridgeUsage() {
        return this.getUsage(this.bridgePlaceholderUsagePrevious);
    }

    public Map<String, Float> getMethodUsage() {
        return this.getUsage(this.methodUsagePrevious);
    }

    public Map<String, AtomicInteger> getSentPackets() {
        return this.sortByValue1(this.packetsPrevious);
    }

    private Map<String, Float> getUsage(Map<String, AtomicLong> map) {
        HashMap<String, Long> nanoMap = new HashMap<String, Long>();
        for (Map.Entry<String, AtomicLong> nanos : map.entrySet()) {
            String key = nanos.getKey();
            nanoMap.putIfAbsent(key, 0L);
            nanoMap.put(key, (Long)nanoMap.get(key) + nanos.getValue().get());
        }
        HashMap<String, Float> percentMap = new HashMap<String, Float>();
        for (Map.Entry entry : nanoMap.entrySet()) {
            percentMap.put((String)entry.getKey(), Float.valueOf(this.nanosToPercent((Long)entry.getValue())));
        }
        return this.sortByValue(percentMap);
    }

    public Map<String, Map<String, Float>> getFeatureUsage() {
        HashMap total = new HashMap();
        for (Map.Entry<String, Map<String, AtomicLong>> nanos : this.featureUsagePrevious.entrySet()) {
            String key = nanos.getKey();
            total.putIfAbsent(key, new HashMap());
            Map usage = (Map)total.get(key);
            for (Map.Entry<String, AtomicLong> entry : nanos.getValue().entrySet()) {
                usage.putIfAbsent(entry.getKey(), 0L);
                usage.put(entry.getKey(), (Long)usage.get(entry.getKey()) + entry.getValue().get());
            }
        }
        LinkedHashMap<String, Map<String, Float>> sorted = new LinkedHashMap<String, Map<String, Float>>();
        for (String key : this.sortKeys(total)) {
            Map local = this.sortByValue((Map)total.get(key));
            LinkedHashMap<String, Float> percent = new LinkedHashMap<String, Float>();
            for (Map.Entry entry : local.entrySet()) {
                percent.put((String)entry.getKey(), Float.valueOf(this.nanosToPercent((Long)entry.getValue())));
            }
            sorted.put(key, percent);
        }
        return sorted;
    }

    private float nanosToPercent(long nanos) {
        float percent = (float)nanos / 10000.0f / 1000000.0f;
        return percent *= 100.0f;
    }

    private <K, V extends Comparable<V>> Map<K, V> sortByValue(Map<K, V> map) {
        Comparator valueComparator = (k1, k2) -> {
            int diff = ((Comparable)map.get(k2)).compareTo((Comparable)map.get(k1));
            return diff == 0 ? 1 : diff;
        };
        TreeMap<K, V> sortedByValues = new TreeMap<K, V>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    private <K> Map<K, AtomicInteger> sortByValue1(Map<K, AtomicInteger> map) {
        Comparator valueComparator = (k1, k2) -> {
            int diff = ((AtomicInteger)map.get(k2)).get() - ((AtomicInteger)map.get(k1)).get();
            return diff == 0 ? 1 : diff;
        };
        TreeMap<K, AtomicInteger> sortedByValues = new TreeMap<K, AtomicInteger>(valueComparator);
        sortedByValues.putAll(map);
        return sortedByValues;
    }

    private <K> List<K> sortKeys(Map<K, Map<String, Long>> map) {
        LinkedHashMap<K, Long> simplified = new LinkedHashMap<K, Long>();
        for (Map.Entry<K, Map<String, Long>> entry : map.entrySet()) {
            simplified.put(entry.getKey(), entry.getValue().values().stream().mapToLong(Long::longValue).sum());
        }
        return new ArrayList(this.sortByValue(simplified).keySet());
    }

    public void addTime(TabFeature feature, String type, long nanoseconds) {
        this.featureUsageCurrent.computeIfAbsent(feature.getFeatureName(), f -> new ConcurrentHashMap()).computeIfAbsent(type, t -> new AtomicLong()).addAndGet(nanoseconds);
    }

    public void addTime(String feature, String type, long nanoseconds) {
        this.featureUsageCurrent.computeIfAbsent(feature, f -> new ConcurrentHashMap()).computeIfAbsent(type, t -> new AtomicLong()).addAndGet(nanoseconds);
    }

    private void addTime(Map<String, AtomicLong> map, String key, long time) {
        map.computeIfAbsent(key, k -> new AtomicLong()).addAndGet(time);
    }

    public void addPlaceholderTime(String placeholder, long nanoseconds) {
        this.addTime(this.placeholderUsageCurrent, placeholder, nanoseconds);
    }

    public void addBridgePlaceholderTime(String placeholder, long nanoseconds) {
        this.addTime(this.bridgePlaceholderUsageCurrent, placeholder, nanoseconds);
    }

    public void addMethodTime(String method, long nanoseconds) {
        this.addTime(this.methodUsageCurrent, method, nanoseconds);
    }

    public void packetSent(String feature) {
        this.packetsCurrent.computeIfAbsent(feature, f -> new AtomicInteger()).incrementAndGet();
    }
}

