/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.shared.TAB;

public class ErrorManager {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy - HH:mm:ss - ");
    private final File errorLog = new File(TAB.getInstance().getPlatform().getDataFolder(), "errors.log");
    private final File antiOverrideLog = new File(TAB.getInstance().getPlatform().getDataFolder(), "anti-override.log");
    private final File placeholderErrorLog = new File(TAB.getInstance().getPlatform().getDataFolder(), "placeholder-errors.log");

    public ErrorManager() {
        if (this.getErrorLog().exists() && this.getErrorLog().length() > 10L) {
            this.startupWarn("File &e" + this.getErrorLog().getPath() + "&c exists and is not empty. Take a look at the error messages and try to resolve them. After you do, delete the file.");
        }
    }

    public void printError(String message) {
        this.printError(message, null, false);
    }

    public void printError(String message, Throwable t) {
        this.printError(message, t, false);
    }

    public void printError(String message, Throwable t, boolean intoConsoleToo) {
        this.printError(message, t, intoConsoleToo, this.getErrorLog());
    }

    public void printError(String message, Throwable t, boolean intoConsoleToo, File file) {
        block14: {
            Throwable error = t;
            if (error instanceof InvocationTargetException) {
                error = error.getCause();
            }
            try {
                if (!this.createFile(file)) {
                    return;
                }
                if (file.length() > 1000000L) {
                    return;
                }
                try (BufferedWriter buf = new BufferedWriter(new FileWriter(file, true));){
                    if (message != null) {
                        this.write(buf, "&c[TAB v3.0.2] ", EnumChatFormat.decolor(message), intoConsoleToo);
                    }
                    if (error == null) break block14;
                    this.write(buf, "&c", error.getClass().getName() + ": " + error.getMessage(), intoConsoleToo);
                    for (StackTraceElement ste : error.getStackTrace()) {
                        this.write(buf, "&c       at ", ste.toString(), intoConsoleToo);
                    }
                }
            }
            catch (IOException ex) {
                TAB.getInstance().getPlatform().sendConsoleMessage("&c[TAB] An error occurred when printing error message into file", true);
                TAB.getInstance().getPlatform().sendConsoleMessage(ex.getClass().getName() + ": " + ex.getMessage(), true);
                for (StackTraceElement e : ex.getStackTrace()) {
                    TAB.getInstance().getPlatform().sendConsoleMessage("\t" + e.toString(), true);
                }
                TAB.getInstance().getPlatform().sendConsoleMessage("&c[TAB] Original error: " + message, true);
                if (error == null) break block14;
                TAB.getInstance().getPlatform().sendConsoleMessage(error.getClass().getName() + ": " + error.getMessage(), true);
                for (StackTraceElement e : error.getStackTrace()) {
                    TAB.getInstance().getPlatform().sendConsoleMessage("\t" + e.toString(), true);
                }
            }
        }
    }

    public void placeholderError(String message, Throwable t) {
        this.printError(message, t, false, this.placeholderErrorLog);
    }

    private boolean createFile(File file) {
        if (file.exists()) {
            return true;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            TAB.getInstance().getPlatform().sendConsoleMessage("&c[TAB] Failed to create file " + file.getPath() + ": " + e.getMessage(), true);
            return false;
        }
    }

    private void write(BufferedWriter buf, String prefix, String message, boolean forceConsole) throws IOException {
        buf.write(this.dateFormat.format(new Date()) + IChatBaseComponent.fromColoredText(prefix).toRawText() + message + System.getProperty("line.separator"));
        if (TAB.getInstance().isDebugMode() || forceConsole) {
            TAB.getInstance().getPlatform().sendConsoleMessage(EnumChatFormat.color(prefix) + message, false);
        }
    }

    public void criticalError(String message, Throwable t) {
        this.printError(message, t, true);
    }

    public int parseInteger(String string, int defaultValue) {
        try {
            return (int)Math.round(Double.parseDouble(string));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public float parseFloat(String string, float defaultValue) {
        try {
            return Float.parseFloat(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public double parseDouble(String string, double defaultValue) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public BarColor parseColor(String string, BarColor defaultValue) {
        try {
            return BarColor.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public BarStyle parseStyle(String string, BarStyle defaultValue) {
        try {
            return BarStyle.valueOf(string);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public int fixAnimationInterval(String name, int interval) {
        if (interval == 0) {
            this.startupWarn(String.format("Animation \"&e%s&c\" has refresh interval of 0 milliseconds! Did you forget to configure it? &bUsing 1000.", name));
            return 1000;
        }
        if (interval < 0) {
            this.startupWarn(String.format("Animation \"&e%s&c\" has refresh interval of %s. Refresh cannot be negative! &bUsing 1000.", name, interval));
            return 1000;
        }
        if (interval % 50 != 0) {
            int newInterval = interval - interval % 50;
            if (newInterval == 0) {
                newInterval = 50;
            }
            this.startupWarn(String.format("Animation \"&e%s&c\" has refresh interval of %s which is not divisible by 50! &bUsing %s.", name, interval, newInterval));
            return newInterval;
        }
        return interval;
    }

    public List<String> fixAnimationFrames(String name, List<String> list) {
        if (list == null) {
            this.startupWarn("Animation \"&e" + name + "&c\" does not have any texts! &bIgnoring.");
            return Collections.singletonList("<Invalid Animation>");
        }
        return list;
    }

    public void startupWarn(String message) {
        TAB.getInstance().getPlatform().sendConsoleMessage("&c[TAB] " + message, true);
    }

    public void missingAttribute(String objectType, Object objectName, String attribute) {
        this.startupWarn(objectType + " \"&e" + objectName + "&c\" is missing \"&e" + attribute + "&c\" attribute!");
    }

    public File getAntiOverrideLog() {
        return this.antiOverrideLog;
    }

    public File getErrorLog() {
        return this.errorLog;
    }
}

