/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.placeholder.PlayerPlaceholder;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.permission.LuckPerms;
import me.neznamy.tab.shared.permission.None;
import me.neznamy.tab.shared.permission.PermissionPlugin;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.event.EventSubscription;
import net.luckperms.api.event.group.GroupDataRecalculateEvent;
import net.luckperms.api.event.user.UserDataRecalculateEvent;

public class GroupManager
extends TabFeature {
    public static final String DEFAULT_GROUP = "NONE";
    private Object luckPermsSub;
    private Object luckPermsSub2;
    private final PermissionPlugin plugin;
    private final boolean groupsByPermissions = TAB.getInstance().getConfiguration().getConfig().getBoolean("assign-groups-by-permissions", false);
    private final List<String> primaryGroupFindingList = TAB.getInstance().getConfiguration().getConfig().getStringList("primary-group-finding-list", Arrays.asList("Owner", "Admin", "Helper", "default"));
    private PlayerPlaceholder groupPlaceholder;

    public GroupManager(PermissionPlugin plugin) {
        super("Permission group refreshing", "Refreshing group");
        this.plugin = plugin;
        if (plugin instanceof LuckPerms) {
            this.groupPlaceholder = TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%group%", 1000000000, TabPlayer::getGroup);
            this.groupPlaceholder.enableTriggerMode();
            this.registerLuckPermsSub();
        } else if (plugin instanceof None && !this.groupsByPermissions) {
            TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%group%", 1000000000, p -> DEFAULT_GROUP);
        } else {
            TAB.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%group%", 1000, this::detectPermissionGroup);
            this.addUsedPlaceholders(Collections.singletonList("%group%"));
        }
    }

    @Override
    public void refresh(TabPlayer p, boolean force) {
        ((ITabPlayer)p).setGroup(this.detectPermissionGroup(p), true);
    }

    private void registerLuckPermsSub() {
        this.luckPermsSub = LuckPermsProvider.get().getEventBus().subscribe(UserDataRecalculateEvent.class, this::updatePlayer);
        this.luckPermsSub2 = LuckPermsProvider.get().getEventBus().subscribe(GroupDataRecalculateEvent.class, this::updateGroup);
    }

    private void updatePlayer(UserDataRecalculateEvent event) {
        TAB.getInstance().getCPUManager().runMeasuredTask("Processing UserDataRecalculateEvent", this, "Processing UserDataRecalculateEvent", () -> {
            long time = System.nanoTime();
            TabPlayer p = TAB.getInstance().getPlayer(event.getUser().getUniqueId());
            if (p == null) {
                return;
            }
            this.refresh(p, false);
            TAB.getInstance().getCPUManager().addTime("Permission group refreshing", "UserDataRecalculateEvent", System.nanoTime() - time);
            this.groupPlaceholder.updateValue(p, p.getGroup());
        });
    }

    private void updateGroup(GroupDataRecalculateEvent event) {
        TAB.getInstance().getCPUManager().runTaskLater(50, "Processing GroupDataRecalculateEvent", this, "Processing GroupDataRecalculateEvent", () -> {
            long time = System.nanoTime();
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                this.refresh(player, false);
                this.groupPlaceholder.updateValue(player, player.getGroup());
            }
            TAB.getInstance().getCPUManager().addTime("Permission group refreshing", "UserDataRecalculateEvent", System.nanoTime() - time);
        });
    }

    @Override
    public void unload() {
        if (this.luckPermsSub != null) {
            ((EventSubscription)this.luckPermsSub).close();
        }
        if (this.luckPermsSub2 != null) {
            ((EventSubscription)this.luckPermsSub2).close();
        }
    }

    public String detectPermissionGroup(TabPlayer p) {
        if (this.isGroupsByPermissions()) {
            return this.getByPermission(p);
        }
        return this.getByPrimary(p);
    }

    private String getByPrimary(TabPlayer p) {
        try {
            return this.plugin.getPrimaryGroup(p);
        }
        catch (Exception e) {
            TAB.getInstance().getErrorManager().printError("Failed to get permission group of " + p.getName() + " using " + this.plugin.getName() + " v" + this.plugin.getVersion(), e);
            return DEFAULT_GROUP;
        }
    }

    private String getByPermission(TabPlayer p) {
        for (String group : this.primaryGroupFindingList) {
            if (!p.hasPermission("tab.group." + group)) continue;
            return String.valueOf(group);
        }
        return DEFAULT_GROUP;
    }

    public boolean isGroupsByPermissions() {
        return this.groupsByPermissions;
    }

    public PermissionPlugin getPlugin() {
        return this.plugin;
    }
}

