/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.util.ArrayList;
import me.neznamy.tab.api.Property;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.rgb.RGBUtils;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.placeholders.RelationalPlaceholderImpl;

public class PropertyImpl
implements Property {
    private final TabFeature listener;
    private final TabPlayer owner;
    private String rawValue;
    private String rawFormattedValue;
    private String temporaryValue;
    private String lastReplacedValue;
    private String source;
    private String[] placeholders;
    private String[] relPlaceholders;

    public PropertyImpl(TabFeature listener, TabPlayer owner, String rawValue) {
        this(listener, owner, rawValue, null);
    }

    public PropertyImpl(TabFeature listener, TabPlayer owner, String rawValue, String source) {
        this.listener = listener;
        this.owner = owner;
        this.source = source;
        this.rawValue = rawValue == null ? "" : rawValue;
        this.analyze(this.rawValue);
    }

    private void analyze(String value) {
        ArrayList<String> placeholders0 = new ArrayList<String>();
        ArrayList<String> relPlaceholders0 = new ArrayList<String>();
        for (String string : TAB.getInstance().getPlaceholderManager().detectPlaceholders(value)) {
            placeholders0.add(string);
            if (!string.startsWith("%rel_")) continue;
            relPlaceholders0.add(string);
        }
        String rawFormattedValue0 = value;
        for (String placeholder : placeholders0) {
            rawFormattedValue0 = rawFormattedValue0.replace(placeholder, "%s");
        }
        if (placeholders0.size() > 0 && rawFormattedValue0.contains("%")) {
            int n = rawFormattedValue0.lastIndexOf(37);
            if (rawFormattedValue0.length() == n + 1 || rawFormattedValue0.charAt(n + 1) != 's') {
                StringBuilder sb = new StringBuilder(rawFormattedValue0);
                sb.insert(n + 1, "%");
                rawFormattedValue0 = sb.toString();
            }
        }
        rawFormattedValue0 = RGBUtils.getInstance().applyFormats(rawFormattedValue0, true);
        this.rawFormattedValue = EnumChatFormat.color(rawFormattedValue0);
        this.placeholders = placeholders0.toArray(new String[0]);
        this.relPlaceholders = relPlaceholders0.toArray(new String[0]);
        if (this.listener != null) {
            this.listener.addUsedPlaceholders(placeholders0);
        }
        this.lastReplacedValue = this.rawFormattedValue;
        this.update();
    }

    @Override
    public void setTemporaryValue(String temporaryValue) {
        if (temporaryValue != null) {
            this.temporaryValue = temporaryValue;
            this.analyze(this.temporaryValue);
        } else {
            this.temporaryValue = null;
            this.analyze(this.rawValue);
        }
    }

    @Override
    public void changeRawValue(String newValue) {
        if (this.rawValue.equals(newValue)) {
            return;
        }
        this.rawValue = newValue;
        if (this.temporaryValue == null) {
            this.analyze(this.rawValue);
        }
    }

    @Override
    public String getCurrentRawValue() {
        return this.temporaryValue != null ? this.temporaryValue : this.rawValue;
    }

    @Override
    public String getTemporaryValue() {
        return this.temporaryValue;
    }

    @Override
    public String getOriginalRawValue() {
        return this.rawValue;
    }

    public String getSource() {
        return this.temporaryValue == null ? this.source : "API";
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String updateAndGet() {
        this.update();
        return this.get();
    }

    @Override
    public boolean update() {
        String string;
        if (this.placeholders.length == 0) {
            return false;
        }
        long time = System.nanoTime();
        if ("%s".equals(this.rawFormattedValue)) {
            string = TAB.getInstance().getPlaceholderManager().getPlaceholder(this.placeholders[0]).set(this.placeholders[0], this.owner);
        } else {
            Object[] values = new String[this.placeholders.length];
            for (int i = 0; i < this.placeholders.length; ++i) {
                values[i] = TAB.getInstance().getPlaceholderManager().getPlaceholder(this.placeholders[i]).set(this.placeholders[i], this.owner);
            }
            string = String.format(this.rawFormattedValue, values);
        }
        string = EnumChatFormat.color(string);
        if (!this.lastReplacedValue.equals(string)) {
            this.lastReplacedValue = string;
            TAB.getInstance().getCPUManager().addMethodTime("Property#update", System.nanoTime() - time);
            return true;
        }
        TAB.getInstance().getCPUManager().addMethodTime("Property#update", System.nanoTime() - time);
        return false;
    }

    @Override
    public String get() {
        return this.lastReplacedValue;
    }

    @Override
    public String getFormat(TabPlayer viewer) {
        String format = this.lastReplacedValue;
        for (String identifier : this.relPlaceholders) {
            RelationalPlaceholderImpl pl = (RelationalPlaceholderImpl)TAB.getInstance().getPlaceholderManager().getPlaceholder(identifier);
            format = format.replace(pl.getIdentifier(), viewer == null ? "" : pl.getLastValue(viewer, this.owner));
        }
        return format;
    }
}

