/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.HeaderFooterManager;
import me.neznamy.tab.api.PropertyConfiguration;
import me.neznamy.tab.api.ProtocolVersion;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.TablistFormatManager;
import me.neznamy.tab.api.bossbar.BossBarManager;
import me.neznamy.tab.api.config.ConfigurationFile;
import me.neznamy.tab.api.scoreboard.ScoreboardManager;
import me.neznamy.tab.api.team.TeamManager;
import me.neznamy.tab.shared.CpuManager;
import me.neznamy.tab.shared.ErrorManager;
import me.neznamy.tab.shared.FeatureManagerImpl;
import me.neznamy.tab.shared.GroupManager;
import me.neznamy.tab.shared.ITabPlayer;
import me.neznamy.tab.shared.Platform;
import me.neznamy.tab.shared.command.DisabledCommand;
import me.neznamy.tab.shared.command.TabCommand;
import me.neznamy.tab.shared.config.Configs;
import me.neznamy.tab.shared.event.EventBusImpl;
import me.neznamy.tab.shared.event.impl.TabLoadEventImpl;
import me.neznamy.tab.shared.features.AlignedPlayerList;
import me.neznamy.tab.shared.features.BelowName;
import me.neznamy.tab.shared.features.GhostPlayerFix;
import me.neznamy.tab.shared.features.HeaderFooter;
import me.neznamy.tab.shared.features.NickCompatibility;
import me.neznamy.tab.shared.features.PingSpoof;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.SpectatorFix;
import me.neznamy.tab.shared.features.YellowNumber;
import me.neznamy.tab.shared.features.layout.LayoutManager;
import me.neznamy.tab.shared.features.nametags.NameTag;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardManagerImpl;
import me.neznamy.tab.shared.features.sorting.Sorting;
import org.yaml.snakeyaml.error.YAMLException;

public class TAB
extends TabAPI {
    private static TAB instance;
    public static final String PLUGIN_VERSION = "3.0.2";
    private final Map<UUID, TabPlayer> data = new ConcurrentHashMap<UUID, TabPlayer>();
    private final Map<UUID, TabPlayer> playersByTablistId = new ConcurrentHashMap<UUID, TabPlayer>();
    private TabPlayer[] players = new TabPlayer[0];
    private TabCommand command;
    private final DisabledCommand disabledCommand = new DisabledCommand();
    private final Platform platform;
    private CpuManager cpu;
    private EventBusImpl eventBus;
    private ErrorManager errorManager;
    private FeatureManagerImpl featureManager;
    private Configs configuration;
    private boolean debugMode;
    private boolean disabled;
    private PlaceholderManagerImpl placeholderManager;
    private final ProtocolVersion serverVersion;
    private GroupManager groupManager;
    private boolean floodgate;

    public TAB(Platform platform, ProtocolVersion serverVersion) {
        this.platform = platform;
        this.serverVersion = serverVersion;
        TabAPI.setInstance(this);
        try {
            Class.forName("org.geysermc.floodgate.api.FloodgateApi");
            this.floodgate = true;
        }
        catch (ClassNotFoundException | IllegalStateException exception) {
            // empty catch block
        }
        try {
            this.eventBus = new EventBusImpl();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    @Override
    public TabPlayer[] getOnlinePlayers() {
        return this.players;
    }

    public TabPlayer getPlayerByTablistUUID(UUID tabListId) {
        return this.playersByTablistId.get(tabListId);
    }

    public void print(char color, String message) {
        this.platform.sendConsoleMessage("&" + color + "[TAB] " + message, true);
    }

    @Override
    public void debug(String message) {
        if (this.debugMode) {
            this.platform.sendConsoleMessage("&9[TAB DEBUG] " + message, true);
        }
    }

    public String load() {
        try {
            long time = System.currentTimeMillis();
            this.errorManager = new ErrorManager();
            this.cpu = new CpuManager(this.errorManager);
            this.featureManager = new FeatureManagerImpl();
            this.configuration = new Configs(this);
            this.configuration.loadFiles();
            this.placeholderManager = new PlaceholderManagerImpl();
            this.cpu.registerPlaceholder();
            this.featureManager.registerFeature("PlaceholderManager", this.placeholderManager);
            this.groupManager = new GroupManager(this.platform.detectPermissionPlugin());
            this.featureManager.registerFeature("GroupManager", this.groupManager);
            this.platform.loadFeatures();
            this.command = new TabCommand(this);
            this.featureManager.load();
            for (TabPlayer p : this.players) {
                ((ITabPlayer)p).markAsLoaded(false);
            }
            this.cpu.enable();
            if (this.eventBus != null) {
                this.eventBus.fire(TabLoadEventImpl.getInstance());
            }
            this.platform.callLoadEvent();
            this.disabled = false;
            this.print('a', "Enabled in " + (System.currentTimeMillis() - time) + "ms");
            return this.configuration.getMessages().getReloadSuccess();
        }
        catch (YAMLException e) {
            this.print('c', "Did not enable due to a broken configuration file.");
            this.kill();
            return this.configuration.getReloadFailedMessage().replace("%file%", "-");
        }
        catch (Exception e) {
            this.errorManager.criticalError("Failed to enable. Did you just invent a new way to break the plugin by misconfiguring it?", e);
            this.kill();
            return "&cFailed to enable due to an internal plugin error. Check console for more info.";
        }
    }

    public void unload() {
        if (this.disabled) {
            return;
        }
        try {
            long time = System.currentTimeMillis();
            if (this.configuration.getMysql() != null) {
                this.configuration.getMysql().closeConnection();
            }
            this.featureManager.unload();
            this.platform.sendConsoleMessage("&a[TAB] Disabled in " + (System.currentTimeMillis() - time) + "ms", true);
        }
        catch (Exception e) {
            this.errorManager.criticalError("Failed to disable", e);
        }
        this.kill();
    }

    private void kill() {
        this.disabled = true;
        this.data.clear();
        this.players = new TabPlayer[0];
        this.cpu.cancelAllTasks();
    }

    public void loadUniversalFeatures() {
        if (this.configuration.getConfig().getBoolean("header-footer.enabled", true)) {
            this.featureManager.registerFeature("HeaderFooter", new HeaderFooter());
        }
        if (this.configuration.isRemoveGhostPlayers()) {
            this.featureManager.registerFeature("GhostPlayerFix", new GhostPlayerFix());
        }
        if (this.serverVersion.getMinorVersion() >= 8 && this.configuration.getConfig().getBoolean("tablist-name-formatting.enabled", true)) {
            if (this.configuration.getConfig().getBoolean("tablist-name-formatting.align-tabsuffix-on-the-right", false)) {
                this.featureManager.registerFeature("PlayerList", new AlignedPlayerList());
            } else {
                this.featureManager.registerFeature("PlayerList", new PlayerList());
            }
        }
        if (this.configuration.getConfig().getBoolean("ping-spoof.enabled", false)) {
            this.featureManager.registerFeature("PingSpoof", new PingSpoof());
        }
        if (this.configuration.getConfig().getBoolean("yellow-number-in-tablist.enabled", true)) {
            this.featureManager.registerFeature("YellowNumber", new YellowNumber());
        }
        if (this.configuration.getConfig().getBoolean("prevent-spectator-effect.enabled", false)) {
            this.featureManager.registerFeature("SpectatorFix", new SpectatorFix());
        }
        if (this.configuration.getConfig().getBoolean("belowname-objective.enabled", true)) {
            this.featureManager.registerFeature("BelowName", new BelowName());
        }
        if (this.configuration.getConfig().getBoolean("scoreboard.enabled", false)) {
            this.featureManager.registerFeature("ScoreBoard", new ScoreboardManagerImpl());
        }
        if (this.serverVersion.getMinorVersion() >= 8 && this.configuration.getLayout().getBoolean("enabled", false)) {
            if (this.getTeamManager() == null) {
                this.featureManager.registerFeature("sorting", new Sorting(null));
            }
            this.featureManager.registerFeature("layout", new LayoutManager());
        }
        this.featureManager.registerFeature("nick", new NickCompatibility());
    }

    public void addPlayer(TabPlayer player) {
        this.data.put(player.getUniqueId(), player);
        this.playersByTablistId.put(player.getTablistUUID(), player);
        this.players = this.data.values().toArray(new TabPlayer[0]);
    }

    public void removePlayer(TabPlayer player) {
        this.data.remove(player.getUniqueId());
        this.playersByTablistId.remove(player.getTablistUUID());
        this.players = this.data.values().toArray(new TabPlayer[0]);
    }

    public static TAB getInstance() {
        return instance;
    }

    public static void setInstance(TAB instance) {
        TAB.instance = instance;
    }

    @Override
    public FeatureManagerImpl getFeatureManager() {
        return this.featureManager;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public CpuManager getCPUManager() {
        return this.cpu;
    }

    @Override
    public EventBusImpl getEventBus() {
        return this.eventBus;
    }

    public ErrorManager getErrorManager() {
        return this.errorManager;
    }

    public Configs getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public TabCommand getCommand() {
        return this.command;
    }

    public void setDebugMode(boolean debug) {
        this.debugMode = debug;
    }

    public DisabledCommand getDisabledCommand() {
        return this.disabledCommand;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    @Override
    public BossBarManager getBossBarManager() {
        return (BossBarManager)((Object)this.featureManager.getFeature("BossBar"));
    }

    @Override
    public ScoreboardManager getScoreboardManager() {
        return (ScoreboardManager)((Object)this.featureManager.getFeature("ScoreBoard"));
    }

    @Override
    public TeamManager getTeamManager() {
        if (this.featureManager.isFeatureEnabled("NameTag16")) {
            return (NameTag)this.featureManager.getFeature("NameTag16");
        }
        return (NameTag)this.featureManager.getFeature("NameTagX");
    }

    @Override
    public PlaceholderManagerImpl getPlaceholderManager() {
        return this.placeholderManager;
    }

    @Override
    public TabPlayer getPlayer(String name) {
        for (TabPlayer p : this.data.values()) {
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public TabPlayer getPlayer(UUID uniqueId) {
        return this.data.get(uniqueId);
    }

    @Override
    public void sendConsoleMessage(String message, boolean translateColors) {
        this.platform.sendConsoleMessage(message, translateColors);
    }

    @Override
    public HeaderFooterManager getHeaderFooterManager() {
        return (HeaderFooterManager)((Object)this.featureManager.getFeature("HeaderFooter"));
    }

    @Override
    public ConfigurationFile getPlayerCache() {
        return this.configuration.getPlayerDataFile();
    }

    @Override
    public ConfigurationFile getConfig() {
        return this.configuration.getConfig();
    }

    @Override
    public CpuManager getThreadManager() {
        return this.getCPUManager();
    }

    @Override
    public PropertyConfiguration getGroups() {
        return this.configuration.getGroups();
    }

    @Override
    public PropertyConfiguration getUsers() {
        return this.configuration.getUsers();
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public boolean isFloodgateInstalled() {
        return this.floodgate;
    }

    @Override
    public void logError(String message, Throwable t) {
        this.errorManager.printError(message, t);
    }

    @Override
    public TablistFormatManager getTablistFormatManager() {
        return (TablistFormatManager)((Object)this.featureManager.getFeature("PlayerList"));
    }
}

