/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import me.neznamy.tab.api.TabFeature;
import me.neznamy.tab.api.task.RepeatingTask;
import me.neznamy.tab.shared.TAB;

public class TabRepeatingTask
implements RepeatingTask {
    private final ExecutorService exe;
    private Runnable runnable;
    private final String errorDescription;
    private final TabFeature feature;
    private final String type;
    private int interval;
    private Future<?> task;

    public TabRepeatingTask(ExecutorService exe, Runnable runnable, String errorDescription, TabFeature feature, String type, int interval) {
        if (interval < 0) {
            throw new IllegalArgumentException("Interval cannot be negative");
        }
        this.exe = exe;
        this.runnable = runnable;
        this.errorDescription = errorDescription;
        this.feature = feature;
        this.type = type;
        this.interval = interval;
        this.createTask();
    }

    private void createTask() {
        this.task = this.exe.submit(() -> {
            long nextLoop = System.currentTimeMillis();
            while (true) {
                try {
                    while (true) {
                        long sleep;
                        if ((sleep = (nextLoop += (long)this.interval) - System.currentTimeMillis()) > (long)this.interval) {
                            sleep = this.interval;
                        }
                        if (sleep > 0L) {
                            Thread.sleep(sleep);
                        }
                        TAB.getInstance().getCPUManager().runMeasuredTask(this.errorDescription, this.feature, this.type, this.runnable);
                    }
                }
                catch (InterruptedException pluginDisabled) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception | LinkageError e) {
                    TAB.getInstance().getErrorManager().printError("An error occurred when " + this.errorDescription, e);
                    continue;
                }
                break;
            }
        });
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(int interval) {
        if (interval < 0) {
            throw new IllegalArgumentException("Interval cannot be negative");
        }
        this.cancel();
        this.interval = interval;
        this.createTask();
    }

    @Override
    public void cancel() {
        this.task.cancel(true);
    }

    @Override
    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }
}

