/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.chat.EnumChatFormat;
import me.neznamy.tab.api.chat.IChatBaseComponent;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.placeholders.TabPlaceholder;

public class CpuCommand
extends SubCommand {
    private final DecimalFormat decimal3 = new DecimalFormat("#.###");
    private static final char LINE_CHAR = '\u2551';
    private static final String SEPARATOR = "&8&l\u2551&8&m                                                    ";

    public CpuCommand() {
        super("cpu", "tab.cpu");
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        TAB tab = TAB.getInstance();
        Map<String, Float> placeholders = tab.getCPUManager().getPlaceholderUsage();
        double placeholdersTotal = placeholders.values().stream().mapToDouble(Float::floatValue).sum();
        Map<String, Float> bridgePlaceholders = tab.getCPUManager().getBridgeUsage();
        double bridgePlaceholdersTotal = bridgePlaceholders.values().stream().mapToDouble(Float::floatValue).sum();
        Map<String, Map<String, Float>> features = tab.getCPUManager().getFeatureUsage();
        double featuresTotal = 0.0;
        for (Map<String, Float> map : features.values()) {
            featuresTotal += map.values().stream().mapToDouble(Float::floatValue).sum();
        }
        this.sendMessage(sender, " ");
        this.sendMessage(sender, "&8&l\u2551&8&m             &r&8&l[ &bTAB CPU Stats &8&l]&r&8&l&m             ");
        this.sendMessage(sender, "&8&l\u2551 &6CPU stats from the last 10 seconds");
        this.sendMessage(sender, SEPARATOR);
        this.sendMessage(sender, "&8&l\u2551 &6Top 5 placeholders:");
        this.printPlaceholders(sender, tab.getCPUManager().getPlaceholderUsage());
        this.sendMessage(sender, SEPARATOR);
        this.sendMessage(sender, "&8&l\u2551 &6Some internal separately measured methods:");
        this.printMethods(sender);
        this.sendMessage(sender, SEPARATOR);
        if (!tab.getCPUManager().getBridgeUsage().isEmpty()) {
            this.sendMessage(sender, "&8&l\u2551 &6Top 5 placeholders on Bukkit servers:");
            this.printPlaceholders(sender, tab.getCPUManager().getBridgeUsage());
            this.sendMessage(sender, SEPARATOR);
        }
        if (sender != null) {
            this.sendToPlayer(sender, features);
        } else {
            this.sendToConsole(features);
        }
        this.sendMessage(sender, SEPARATOR);
        if (sender != null) {
            this.sendPacketCountToPlayer(sender);
        } else {
            this.sendPacketCountToConsole();
        }
        this.sendMessage(sender, String.format("&8&l%s &6&lPlaceholders Total: &a&l%s%%", Character.valueOf('\u2551'), this.colorize(this.decimal3.format(placeholdersTotal), 10.0f, 5.0f)));
        if (!tab.getCPUManager().getBridgeUsage().isEmpty()) {
            this.sendMessage(sender, String.format("&8&l%s &6&lBukkit bridge placeholders Total: &a&l%s%%", Character.valueOf('\u2551'), this.colorize(this.decimal3.format(bridgePlaceholdersTotal), 10.0f, 5.0f)));
        }
        this.sendMessage(sender, String.format("&8&l%s &6&lPlugin internals: &a&l%s%%", Character.valueOf('\u2551'), this.colorize(this.decimal3.format(featuresTotal - placeholdersTotal), 10.0f, 5.0f)));
        this.sendMessage(sender, String.format("&8&l%s &6&lTotal: &e&l%s%%", Character.valueOf('\u2551'), this.colorize(this.decimal3.format(featuresTotal + bridgePlaceholdersTotal), 10.0f, 5.0f)));
        this.sendMessage(sender, "&8&l\u2551&8&m             &r&8&l[ &bTAB CPU Stats &8&l]&r&8&l&m             ");
        this.sendMessage(sender, " ");
    }

    private void printPlaceholders(TabPlayer sender, Map<String, Float> map) {
        int printCounter = 0;
        for (Map.Entry<String, Float> entry : map.entrySet()) {
            if (printCounter++ == 5) break;
            String refresh = "";
            TabPlaceholder p = TAB.getInstance().getPlaceholderManager().getPlaceholder(entry.getKey());
            if (p != null && !p.isTriggerMode()) {
                refresh = " &8(" + p.getRefresh() + ")&7";
            }
            String colorized = entry.getKey().startsWith("%sync:") ? "&c" + this.decimal3.format(entry.getValue()) : this.colorize(this.decimal3.format(entry.getValue()), 1.0f, 0.3f);
            this.sendMessage(sender, String.format("&8&l%s &7%s - %s%%", Character.valueOf('\u2551'), entry.getKey() + refresh, colorized));
        }
    }

    private void printMethods(TabPlayer sender) {
        for (Map.Entry<String, Float> entry : TAB.getInstance().getCPUManager().getMethodUsage().entrySet()) {
            this.sendMessage(sender, String.format("&8&l%s &7%s: %s%%", Character.valueOf('\u2551'), entry.getKey(), this.colorize(this.decimal3.format(entry.getValue()), 5.0f, 2.0f)));
        }
    }

    public void sendToConsole(Map<String, Map<String, Float>> features) {
        TAB.getInstance().getPlatform().sendConsoleMessage("&8&l\u2551 &6Features:", true);
        for (Map.Entry<String, Map<String, Float>> entry : features.entrySet()) {
            double featureTotal = entry.getValue().values().stream().mapToDouble(Float::floatValue).sum();
            String core = String.format("&8&l%s &7%s &7(%s%%&7):", Character.valueOf('\u2551'), entry.getKey(), this.colorize(this.decimal3.format(featureTotal), 5.0f, 1.0f));
            ArrayList<String> messages = new ArrayList<String>();
            for (Map.Entry<String, Float> type : entry.getValue().entrySet()) {
                messages.add(String.format("&8&l%s     &7%s - %s%%", Character.valueOf('\u2551'), type.getKey(), this.colorize(this.decimal3.format(type.getValue()), 5.0f, 1.0f)));
            }
            TAB.getInstance().getPlatform().sendConsoleMessage(core, true);
            for (String message : messages) {
                TAB.getInstance().getPlatform().sendConsoleMessage(message, true);
            }
        }
    }

    public void sendToPlayer(TabPlayer sender, Map<String, Map<String, Float>> features) {
        this.sendMessage(sender, "&8&l\u2551 &6Features (hover with cursor for more info):");
        for (Map.Entry<String, Map<String, Float>> entry : features.entrySet()) {
            double featureTotal = entry.getValue().values().stream().mapToDouble(Float::floatValue).sum();
            String core = String.format("&8&l%s &7%s &7(%s%%&7):", Character.valueOf('\u2551'), entry.getKey(), this.colorize(this.decimal3.format(featureTotal), 5.0f, 1.0f));
            ArrayList<String> messages = new ArrayList<String>();
            for (Map.Entry<String, Float> type : entry.getValue().entrySet()) {
                messages.add("&3" + type.getKey() + " - " + this.colorize(this.decimal3.format(type.getValue()), 5.0f, 1.0f) + "%");
            }
            IChatBaseComponent message = new IChatBaseComponent(EnumChatFormat.color(core));
            message.getModifier().onHoverShowText(new IChatBaseComponent(EnumChatFormat.color(String.join((CharSequence)"\n", messages))));
            sender.sendMessage(message);
        }
    }

    public void sendPacketCountToConsole() {
        Map<String, AtomicInteger> packets = TAB.getInstance().getCPUManager().getSentPackets();
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<String, AtomicInteger> entry : packets.entrySet()) {
            messages.add("&8&l\u2551     &7" + entry.getKey() + " - " + entry.getValue());
        }
        TAB.getInstance().getPlatform().sendConsoleMessage("&8&l\u2551 &r&7Packets sent by the plugin: " + packets.values().stream().mapToInt(AtomicInteger::get).sum(), true);
        for (String message : messages) {
            TAB.getInstance().getPlatform().sendConsoleMessage(message, true);
        }
    }

    public void sendPacketCountToPlayer(TabPlayer sender) {
        Map<String, AtomicInteger> packets = TAB.getInstance().getCPUManager().getSentPackets();
        ArrayList<String> messages = new ArrayList<String>();
        for (Map.Entry<String, AtomicInteger> entry : packets.entrySet()) {
            messages.add("&3" + entry.getKey() + " - " + entry.getValue());
        }
        IChatBaseComponent message = new IChatBaseComponent(EnumChatFormat.color("&8&l\u2551 &r&7Packets sent by the plugin (hover for more info): " + packets.values().stream().mapToInt(AtomicInteger::get).sum()));
        message.getModifier().onHoverShowText(new IChatBaseComponent(EnumChatFormat.color(String.join((CharSequence)"\n", messages))));
        sender.sendMessage(message);
    }

    private String colorize(String usage, float threshold1, float threshold2) {
        float percent = Float.parseFloat(usage.replace(",", "."));
        if (percent > threshold1) {
            return "&c" + usage;
        }
        if (percent > threshold2) {
            return "&e" + usage;
        }
        return "&a" + usage;
    }
}

