/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.Arrays;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.PropertyCommand;

public class GroupCommand
extends PropertyCommand {
    public GroupCommand() {
        super("group");
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        if (args.length <= 1) {
            this.help(sender);
            return;
        }
        String group = args[0];
        String type = args[1].toLowerCase();
        String value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        String world = null;
        String server = null;
        if (args[args.length - 2].equals("-w")) {
            world = args[args.length - 1];
            value = value.substring(0, value.length() - world.length() - 4);
        }
        if (args[args.length - 2].equals("-s")) {
            server = args[args.length - 1];
            value = value.substring(0, value.length() - server.length() - 4);
        }
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if ("remove".equals(type)) {
            if (this.hasPermission(sender, "tab.remove")) {
                TAB.getInstance().getConfiguration().getGroups().remove(group);
                for (TabPlayer pl : TAB.getInstance().getOnlinePlayers()) {
                    if (!pl.getGroup().equals(group) && !"_DEFAULT_".equals(group)) continue;
                    pl.forceRefresh();
                }
                this.sendMessage(sender, this.getMessages().getGroupDataRemoved(group));
            } else {
                this.sendMessage(sender, this.getMessages().getNoPermission());
            }
            return;
        }
        for (String property : GroupCommand.getAllProperties()) {
            if (!type.equals(property)) continue;
            if (this.hasPermission(sender, "tab.change." + property)) {
                this.saveGroup(sender, group, type, value, server, world);
                if (this.extraProperties.contains(property) && !TAB.getInstance().getFeatureManager().isFeatureEnabled("NameTagX")) {
                    this.sendMessage(sender, this.getMessages().getUnlimitedNametagModeNotEnabled());
                }
            } else {
                this.sendMessage(sender, this.getMessages().getNoPermission());
            }
            return;
        }
        this.help(sender);
    }

    private void saveGroup(TabPlayer sender, String group, String type, String value, String server, String world) {
        if (value.length() > 0) {
            this.sendMessage(sender, this.getMessages().getGroupValueAssigned(type, value, group));
        } else {
            this.sendMessage(sender, this.getMessages().getGroupValueRemoved(type, group));
        }
        String[] property = TAB.getInstance().getConfiguration().getGroups().getProperty(group, type, server, world);
        if (property.length > 0 && String.valueOf(value.length() == 0 ? null : value).equals(String.valueOf(property[0]))) {
            return;
        }
        TAB.getInstance().getConfiguration().getGroups().setProperty(group, type, server, world, value.length() == 0 ? null : value);
        for (TabPlayer pl : TAB.getInstance().getOnlinePlayers()) {
            if (!pl.getGroup().equals(group) && !"_DEFAULT_".equals(group)) continue;
            pl.forceRefresh();
        }
    }
}

