/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import java.util.Arrays;
import java.util.List;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.PropertyCommand;

public class PlayerUUIDCommand
extends PropertyCommand {
    public PlayerUUIDCommand() {
        super("playeruuid");
    }

    @Override
    public void execute(TabPlayer sender, String[] args) {
        if (args.length <= 1) {
            this.help(sender);
            return;
        }
        TabPlayer changed = TAB.getInstance().getPlayer(args[0]);
        if (changed == null) {
            this.sendMessage(sender, this.getMessages().getPlayerNotFound(args[0]));
            return;
        }
        String type = args[1].toLowerCase();
        String value = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        String world = null;
        String server = null;
        if (args[args.length - 2].equals("-w")) {
            world = args[args.length - 1];
            value = value.substring(0, value.length() - world.length() - 4);
        }
        if (args[args.length - 2].equals("-s")) {
            server = args[args.length - 1];
            value = value.substring(0, value.length() - server.length() - 4);
        }
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1);
        }
        if ("remove".equals(type)) {
            if (this.hasPermission(sender, "tab.remove")) {
                TAB.getInstance().getConfiguration().getUsers().remove(changed.getUniqueId().toString());
                changed.forceRefresh();
                this.sendMessage(sender, this.getMessages().getPlayerDataRemoved(changed.getName() + "(" + changed.getUniqueId().toString() + ")"));
            } else {
                this.sendMessage(sender, this.getMessages().getNoPermission());
            }
            return;
        }
        for (String property : PlayerUUIDCommand.getAllProperties()) {
            if (!type.equals(property)) continue;
            if (this.hasPermission(sender, "tab.change." + property)) {
                this.savePlayer(sender, changed, type, value, server, world);
                if (this.extraProperties.contains(property) && !TAB.getInstance().getFeatureManager().isFeatureEnabled("NameTagX")) {
                    this.sendMessage(sender, this.getMessages().getUnlimitedNametagModeNotEnabled());
                }
            } else {
                this.sendMessage(sender, this.getMessages().getNoPermission());
            }
            return;
        }
        this.help(sender);
    }

    public void savePlayer(TabPlayer sender, TabPlayer player, String type, String value, String server, String world) {
        if (value.length() > 0) {
            this.sendMessage(sender, this.getMessages().getPlayerValueAssigned(type, value, player.getName() + "(" + player.getUniqueId().toString() + ")"));
        } else {
            this.sendMessage(sender, this.getMessages().getPlayerValueRemoved(type, player.getName() + "(" + player.getUniqueId().toString() + ")"));
        }
        String[] property = TAB.getInstance().getConfiguration().getUsers().getProperty(player.getUniqueId().toString(), type, server, world);
        if (property.length > 0 && String.valueOf(value.length() == 0 ? null : value).equals(String.valueOf(property[0]))) {
            return;
        }
        TAB.getInstance().getConfiguration().getUsers().setProperty(player.getUniqueId().toString(), type, server, world, value.length() == 0 ? null : value);
        player.forceRefresh();
    }

    @Override
    public List<String> complete(TabPlayer sender, String[] arguments) {
        if (arguments.length == 1) {
            return this.getOnlinePlayers(arguments[0]);
        }
        return super.complete(sender, arguments);
    }
}

